/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.util.Hashtable;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.MonitoringParser;
import org.eclipse.hyades.logging.parsers.ParserUtilities;
import org.eclipse.hyades.logging.parsers.internal.util.JavaLoggingSAXHandler;

public class JavaLoggingXMLLogParser
extends MonitoringParser {
    private JavaLoggingSAXHandler saxParser = null;
    private String currentLine = null;
    private String partialRecord = "";

    public void setConfiguration(Hashtable table) throws LogParserException {
        super.setConfiguration(table);
        this.saxParser = new JavaLoggingSAXHandler(eventFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommonBaseEvent[] parseNext() throws LogParserException {
        this.arrayIndex = 0;
        String currentRecord = null;
        try {
            while ((currentRecord = this.readCompleteXMLRecord("record")) != null) {
                if (this.filterExitClassInstance != null) {
                    try {
                        boolean pass = this.filterExitClassInstance.filter(currentRecord);
                        if (!pass) {
                            continue;
                        }
                    }
                    catch (AdapterException adapterException) {
                        throw new LogParserException(ParserUtilities.getResourceString("LOG_PARSER_FILTERING_ERROR_", this.curLine));
                    }
                }
                this.saxParser.parse(currentRecord);
                if (this.saxParser.size() > 0) {
                    this.messages[this.arrayIndex] = this.saxParser.getCommonBaseEvents()[0];
                    this.messages[this.arrayIndex].setSequenceNumber(this.seqNums.getSequenceNumber(this.messages[this.arrayIndex].getCreationTime()));
                    ++this.arrayIndex;
                    ++this.recordCount;
                }
                if (this.arrayIndex < this.MessageArraySize) continue;
                break;
            }
        }
        catch (Exception exception) {
            throw new LogParserException(ParserUtilities.getResourceString("JAVA_UTIL_LOGGIN_GENERAL_EXCEPTION_MESSAGE_ERROR_"));
        }
        if (this.recordCount == 0 || this.curLineNumber == 0L) {
            throw new LogParserException(Messages.getString((String)"INVALID_LOG_TYPE_INFO_", (String)this.file_path));
        }
        if (this.arrayIndex == 0) {
            this.setEndOfFile();
            return null;
        }
        int index = this.arrayIndex;
        while (index < this.MessageArraySize) {
            this.messages[index] = null;
            ++index;
        }
        return this.messages;
    }

    /*
     * Unable to fully structure code
     */
    private String readCompleteXMLRecord(String tag) throws LogParserException {
        recordStartIndex = -1;
        recordEndIndex = -1;
        logRecord = null;
        startTag = "<" + tag + ">";
        endTag = "</" + tag + ">";
        if (this.partialRecord.equals("") || (recordStartIndex = this.partialRecord.indexOf(startTag)) == -1) ** GOTO lbl23
        this.partialRecord = this.partialRecord.substring(recordStartIndex);
        recordStartIndex = 0;
        recordEndIndex = this.partialRecord.indexOf(endTag);
        if (recordEndIndex == -1) ** GOTO lbl23
        logRecord = this.partialRecord.substring(recordStartIndex, recordEndIndex + endTag.length());
        this.partialRecord = this.partialRecord.substring(recordEndIndex + endTag.length());
        return logRecord;
lbl-1000:
        // 1 sources

        {
            this.partialRecord = String.valueOf(this.partialRecord) + this.currentLine;
            this.currentLine = null;
            if (recordStartIndex == -1 && (recordStartIndex = this.partialRecord.indexOf(startTag)) != -1) {
                this.partialRecord = this.partialRecord.substring(recordStartIndex);
                recordStartIndex = 0;
            }
            if (recordStartIndex == -1 || (recordEndIndex = this.partialRecord.indexOf(endTag)) < 0) continue;
            logRecord = this.partialRecord.substring(recordStartIndex, recordEndIndex + endTag.length());
            this.partialRecord = this.partialRecord.substring(recordEndIndex + endTag.length());
            return logRecord;
lbl23:
            // 3 sources

            ** while ((this.currentLine = this.readALine()) != null)
        }
lbl24:
        // 1 sources

        return null;
    }

    public String getName() {
        return "Java Logging XML log";
    }

    public String getVersion() {
        return "1.4";
    }
}

