/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.eclipse.hyades.logging.parsers.ParserUtilities;

public class LogParserException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Throwable exception;

    public LogParserException() {
        this.exception = null;
    }

    public LogParserException(String message) {
        super(message);
        this.exception = null;
    }

    public LogParserException(Throwable e) {
        this.exception = e;
    }

    public LogParserException(String message, Throwable e) {
        super(message);
        this.exception = e;
    }

    public String getMessage() {
        String message = super.getMessage();
        String excMessage = null;
        if (this.exception != null && ((excMessage = this.exception.getMessage()) == null || excMessage.length() == 0)) {
            excMessage = this.exception.toString();
        }
        if (message == null || message.length() == 0) {
            if (excMessage != null) {
                return excMessage;
            }
            return null;
        }
        if (excMessage != null) {
            return String.valueOf(message) + "  " + ParserUtilities.getResourceString("EXCEPTION") + " = " + excMessage;
        }
        return message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void printStackTrace() {
        super.printStackTrace();
        if (this.exception != null) {
            System.err.println(ParserUtilities.getResourceString("EMBEDDED_EXCEPTION"));
            this.exception.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        if (this.exception != null) {
            s.println(ParserUtilities.getResourceString("EMBEDDED_EXCEPTION"));
            this.exception.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        if (this.exception != null) {
            s.println(ParserUtilities.getResourceString("EMBEDDED_EXCEPTION"));
            this.exception.printStackTrace(s);
        }
    }
}

