/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.hyades.internal.logging.core.Constants;
import org.eclipse.hyades.logging.parsers.LogParserException;

public final class ParserUtilities {
    private static final String RESOURCE_BUNDLE_LOCATION = "org.eclipse.hyades.logging.parsers.properties.messages";
    private static ResourceBundle resourceBundle = null;

    public static String getResourceString(String key) {
        if (key != null) {
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_LOCATION, Locale.getDefault());
                }
                catch (MissingResourceException missingResourceException) {
                    return key;
                }
            }
            try {
                return resourceBundle.getString(key.trim()).trim();
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return key;
    }

    public static String getResourceString(String key, String argument) {
        return ParserUtilities.getResourceString(key, new String[]{argument});
    }

    public static String getResourceString(String key, String argumentA, String argumentB) {
        return ParserUtilities.getResourceString(key, new String[]{argumentA, argumentB});
    }

    public static String getResourceString(String key, String argumentA, String argumentB, String argumentC) {
        return ParserUtilities.getResourceString(key, new String[]{argumentA, argumentB, argumentC});
    }

    public static String getResourceString(String key, String[] arguments) {
        try {
            return MessageFormat.format(ParserUtilities.getResourceString(key), arguments);
        }
        catch (Exception exception) {
            return key;
        }
    }

    public static String getResourceString(String key, Locale locale) {
        block6: {
            if (key != null) {
                Locale defaultLocale = Locale.getDefault();
                if (locale != null && !locale.equals(defaultLocale)) {
                    ResourceBundle localeResourceBundle = null;
                    try {
                        localeResourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_LOCATION, locale);
                    }
                    catch (MissingResourceException missingResourceException) {
                        return ParserUtilities.getResourceString(key);
                    }
                    try {
                        return localeResourceBundle.getString(key.trim()).trim();
                    }
                    catch (MissingResourceException missingResourceException) {
                        break block6;
                    }
                }
                return ParserUtilities.getResourceString(key);
            }
        }
        return key;
    }

    public static String getResourceString(String key, Locale locale, String argument) {
        return ParserUtilities.getResourceString(key, locale, new String[]{argument});
    }

    public static String getResourceString(String key, Locale locale, String argumentA, String argumentB) {
        return ParserUtilities.getResourceString(key, locale, new String[]{argumentA, argumentB});
    }

    public static String getResourceString(String key, Locale locale, String argumentA, String argumentB, String argumentC) {
        return ParserUtilities.getResourceString(key, locale, new String[]{argumentA, argumentB, argumentC});
    }

    public static String getResourceString(String key, Locale locale, String[] arguments) {
        try {
            return MessageFormat.format(ParserUtilities.getResourceString(key, locale), arguments);
        }
        catch (Exception exception) {
            return key;
        }
    }

    public static void exceptionHandler(Throwable throwable, long faultyLineNum, String faultyLine, String message) throws LogParserException {
        StringBuffer finalMsg = new StringBuffer();
        String lineSep = Constants.LINE_SEPARATOR;
        if (message != null && message.length() > 0) {
            finalMsg.append(message).append(lineSep);
        }
        finalMsg.append(ParserUtilities.getResourceString("INVALID_LINE_NUMBER_ERROR_", String.valueOf(faultyLineNum)));
        finalMsg.append(':').append(lineSep).append(lineSep).append(faultyLine);
        if (throwable != null) {
            String errorMsg = throwable.getMessage();
            if (errorMsg != null && errorMsg.length() > 0 && !(throwable instanceof NoClassDefFoundError)) {
                finalMsg.append(lineSep).append(errorMsg);
            } else {
                finalMsg.append(lineSep).append(throwable.toString());
            }
        }
        LogParserException lpe = new LogParserException(finalMsg.toString());
        lpe.fillInStackTrace();
        throw lpe;
    }

    public static void exceptionHandler(Throwable throwable, String message) throws LogParserException {
        String lineSep = Constants.LINE_SEPARATOR;
        StringBuffer finalMsg = new StringBuffer();
        if (message != null && message.length() > 0) {
            finalMsg.append(message);
        }
        if (throwable != null) {
            String errorMsg;
            if (finalMsg.length() > 0) {
                finalMsg.append(lineSep);
            }
            if ((errorMsg = throwable.getMessage()) != null && errorMsg.length() > 0 && !(throwable instanceof NoClassDefFoundError)) {
                finalMsg.append(errorMsg);
            } else {
                finalMsg.append(throwable.toString());
            }
        }
        LogParserException lpe = finalMsg.length() > 0 ? new LogParserException(finalMsg.toString()) : new LogParserException();
        lpe.fillInStackTrace();
        throw lpe;
    }

    public static boolean isValidIPAddress(String ipAddress) {
        StringTokenizer tokens = new StringTokenizer(ipAddress, ".", true);
        if (tokens.countTokens() == 7) {
            try {
                int number = Integer.parseInt(tokens.nextToken());
                if (number >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255 && tokens.nextToken().equals(".") && (number = Integer.parseInt(tokens.nextToken())) >= 0 && number <= 255) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return false;
    }
}

