/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.utility.WidgetRegistry");
cosmos.utility.WidgetRegistry = function () {
  	dojo.event.topic.subscribe("pullRegistry", this, "setRegistry");				
  	dojo.event.topic.subscribe("initializeWidget", this, "initalize");				
	this.initalize = function(styles){
		initParam = styles.getStyles()["cosmos:WidgetRegistry"];
	    this.widgetRegistry = initParam["widgetRegistry"];
		this.styles = styles;
		dojo.debug("initalizing registry");	
	}	
	this.dojoCellFactory = function(value, cell){
		var register = this.widgetRegistry[value.type];
		dojo.debug(value.type+ ' found ' + register);
		
		if (typeof(register) != 'undefined'){
			var properties= this.styles.getStyles()[register];
			if (typeof(properties) == 'undefined')
				properties = value;
			
			properties.value = value.value;
			properties.caption = value.caption;
			properties.datasource = value.datasource;
			var widget = dojo.widget.createWidget(register, properties); 
			var widgetContainer = document.createElement("div");
			widgetContainer.appendChild(widget.domNode);
			cell.appendChild(widgetContainer);
			return widget;
		}
		else{
			cell.innerHTML=value.value;
		}
		return null;
	}
	
	this.setRegistry = function(component){
			component.setRegistry(this);
	}
};

