/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.PropertiesContainer");
dojo.require("dojo.widget.TitlePane");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.ContentPane");
dojo.require("dojo.event.topic");
dojo.require("cosmos.widget.Property");
dojo.require("cosmos.widget.TitlePane");


dojo.widget.defineWidget(
	// class
	"cosmos.widget.PropertiesContainer",
	// superclass	
	dojo.widget.TitlePane,
	
	// member variables/functions
	{
		tableLabelNodeClass:"tplabel",
		widgetClass:'cosmos:PropertiesContainer',
		postCreate: function(){
			cosmos.widget.PropertiesContainer.superclass.postCreate.apply(this, arguments);			
			//call superclass			
		  	dojo.event.topic.subscribe("initializeWidget", this, "initWidget");
		},
		setRegistry: function(registryObj){
			this.renderDojoCell=registryObj;
		},
		initWidget: function(styles){
			this.topic = "refreshContainer";
			if (typeof(styles) != 'undefined'){
				initParam = styles.getStyles()[this.widgetClass];
			    this.topic = initParam.topic;
			    this.handler = initParam.handler;
			}
			dojo.event.topic.publish("pullRegistry", this);
			dojo.event.topic.subscribe(this.topic, this, "refreshContainer");
			dojo.debug("initalizing PropertiesContainer"  + this.id);	
		},
	    refreshContainer:function(contextMap) {
	    	if (typeof(contextMap) != 'undefined'){
		  	//should add a javascript method that will render itself and make a call
			//back to the server.  It will get the context from a queue.			
				resourceContext = contextMap['RESOURCE_CONTEXT'];	
				resourceClass = contextMap['RESOURCE_CLASS'];	
			}
			//make REST call to get content data
	    	if (typeof(resourceContext) != 'undefined'){
				dojo.io.bind({storeFunction : this,
					url: this.handler+"?context="+resourceContext,
					resourceClass:resourceClass,    
					load: function(type, data, evt){
					try{
						this.storeFunction.store(data, resourceClass);
						}catch(e){
						dojo.debug(e);
						}
					 },    
				 error: function(type, error){
				 	dojo.debug(error.message);
				 },
					mimetype: "application/json"
				});											
			}
	    },
	    setHandler:function(handler){
	    	this.handler = handler;
	    },
	    setTableLabelClass:function(value){
	      this.tableLabelNodeClass = value;
	    },
	    store:function(data, resourceClass){
	      if (typeof(this.containers) != 'undefined'){
			  var len = this.containers.length;
			  //clear the div element
			  for(var j = 0; j < len; j++)
	   		  {
	   		  	this.containers[j].destroy();
	   		  }
	   		}
			this.containers = new Array();
			customWidget = null;
			var div = null;
			if ((this.renderDojoCell) && (resourceClass)){
					div = document.createElement("div");			
					this.containerNode.appendChild(div);
					var argument = new Object;
					argument.type = resourceClass;
					argument.data = data;
					try{
						customWidget = this.renderDojoCell.dojoCellFactory(argument, div);
					}catch(e){
						customWidget = null;
					}
			}
			if (customWidget != null){
				this.containers.push(customWidget);
				}
			else{
				if (div != null){
					this.containerNode.removeChild(div);
				}
	        	this.createContainerWidget(data, this.containerNode, "pcRoot", 0);
	        }
	    },
	    createContainerWidget:function(data, parent, containerId, indent){
			for (var i=0;i < data.length;i++){
					var div = document.createElement("div");			
					parent.appendChild(div);
				if ((typeof(this.renderDojoCell) != "undefined") && (typeof(data[i].value)!="undefined")){
					this.containers.push(this.renderDojoCell.dojoCellFactory(data[i].value, div));
				}
				else{					
					var properties = data[i].properties;
					if (typeof(data[i].properties) != 'undefined'){								
						var propTable = document.createElement("table");
						div.appendChild(propTable);
						this.containers.push(dojo.widget.createWidget("cosmos:Property", {properties: data[i].properties, indent:((indent+1)*20)}, propTable));
					}
					var lc = dojo.widget.createWidget("cosmos:TitlePane", {indent:(indent*20),open:false, sizeMin:33, sizeShare:33, label:data[i].name, labelNodeClass:this.tableLabelNodeClass, containerNodeClass:"tpcontent"}, div);
					this.containers.push(lc);
					if (typeof(data[i].childProperties) != 'undefined')					
						this.createContainerWidget(data[i].childProperties, lc.containerNode, containerId+i+"_n_", indent+1);
				}
			}	    
	    }
		
	}
);
