/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.ReportChooser");
dojo.require("dojo.widget.Button");
dojo.require("dojo.widget.Menu2");


dojo.widget.defineWidget(
	// class
	"cosmos.widget.ReportChooser",

	// superclass	
	dojo.widget.DropDownButton,
	
	// member variables/functions
	{

		postCreate: function(){
			//create mneu bar.
			cosmos.widget.ReportChooser.superclass.postCreate.apply(this, arguments);
			var menuBar = dojo.widget.createWidget("PopupMenu2", {id:"popup",toggle:"wipe"});
			//link button to menu bar
			this.menuId = menuBar.id;
			dojo.debug('handler:' + this.handler);
			dojo.debug('datasource' + this.datasource);
			dojo.debug('value' + this.value);
  			dojo.io.bind({    
  			    popupMenu: menuBar,
				url: this.handler+"&value="+this.value,  
				value: this.value,
				datasource: this.datasource,
				targetTopics: this.targetTopics,  
				load: function(type, data, evt){
					dojo.debug('Returned list:'+data);
				     for(var i=0; i<data.length;i++){ 
						this.popupMenu.addChild(dojo.widget.createWidget("MenuItem2", {caption: data[i].caption, datasource:this.datasource, type:data[i].value,context: this.value, targetTopics: this.targetTopics,
							onClick: function(){
								var params= new Array();
								params['RESOURCE_CONTEXT']=this.context;
								params['REPORT_TYPE']=this.type;
								params['DATASOURCE_KEY']=this.datasource;
								dojo.debug(this.datasource);
								if (typeof(this.targetTopics) != 'undefined'){
										for (i=0;i < this.targetTopics.length;i++){
											dojo.event.topic.publish(this.targetTopics[i], params);
							 			}
					 			}	    
						    }
						}));
				      }				
				 },
				 error: function(type, error){
				 	dojo.debug(error.message);
				 },
				mimetype: "text/json"
			});	
			
		},
		mixInProperties: function(args, fragment, parent){
			this.caption = "Report";
//		  	dojo.event.topic.subscribe(treeSelector.eventNames.select, this, this.onReportSelect);			
//			this.listeners = [controller.widgetId,treeSelector.widgetId];
			//call superclass						
			cosmos.widget.ReportChooser.superclass.mixInProperties.apply(this, arguments);
		}		
	}
);
