/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.TitlePane");
dojo.require("dojo.widget.TitlePane");
dojo.require("dojo.widget.*");
dojo.require("dojo.widget.ContentPane");


dojo.widget.defineWidget(
	// class
	"cosmos.widget.TitlePane",
	// superclass	
	dojo.widget.TitlePane,
	
	// member variables/functions
	{
		open:false,
		expand:false,
		expandIcon:"cosmos/widget/img/minus.gif",
		collapseIcon:"cosmos/widget/img/plus.gif",
		postCreate:function () {
			cosmos.widget.TitlePane.superclass.postCreate.apply(this, arguments);
			if (this.indent)
				this.domNode.setAttribute("style", "margin-left:"+this.indent+"px");
		    this.setLabel(this.label);
		},		
		onLabelClick:function () {
			cosmos.widget.TitlePane.superclass.onLabelClick.apply(this, arguments);			
		    this.setLabel(this.label);
		}, setLabel:function (label) {
		    var iconLabel = label;
		    if (this.open)
				iconLabel = "<img src=\""+this.expandIcon+"\" alt=\"\" />"+label;
			else 
				iconLabel = "<img src=\""+this.collapseIcon+"\" alt=\"\" />"+label;
			cosmos.widget.TitlePane.superclass.setLabel.apply(this, [iconLabel]);
		}		
	}
);
