-- \************************************************************\


CREATE TABLE COSMOS.DIMENSION
   (
      ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
      NAME VARCHAR(24) NOT NULL,
      TYPE VARCHAR(255) NOT NULL
   );


ALTER TABLE COSMOS.DIMENSION
   ADD CONSTRAINT COSMOS.DIMENSION_PK Primary Key (
      ID);


-- \************************************************************\

CREATE TABLE COSMOS.KEY_SET
   (
      ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
      NAME VARCHAR(24) NOT NULL
   );


ALTER TABLE COSMOS.KEY_SET
   ADD CONSTRAINT COSMOS.KEY_SET_PK Primary Key (
      ID);

ALTER TABLE COSMOS.KEY_SET
   ADD CONSTRAINT COSMOS.KEY_SET_UNQ_NM Unique (
      NAME);


-- \************************************************************\
CREATE TABLE COSMOS.KEY_SET_ENTRY
   (
      ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
      KEYSET INTEGER NOT NULL,
      SEQUENCE INTEGER NOT NULL,
      DIMENSION INTEGER NOT NULL
   );
 

ALTER TABLE COSMOS.KEY_SET_ENTRY
   ADD CONSTRAINT COSMOS.KEY_SET_ENTRY_PK Primary Key (
      ID);

ALTER TABLE COSMOS.KEY_SET_ENTRY
   ADD CONSTRAINT COSMOS.KEY_SET_ENTRY_DIMENSION_FK Foreign Key (
      DIMENSION)
   REFERENCES COSMOS.DIMENSION (
      ID);

ALTER TABLE COSMOS.KEY_SET_ENTRY
   ADD CONSTRAINT COSMOS.KEY_SET_ENTRY_KEYSET_FK Foreign Key (
      KEYSET)
   REFERENCES COSMOS.KEY_SET (
      ID);


ALTER TABLE COSMOS.KEY_SET_ENTRY
   ADD CONSTRAINT COSMOS.KEY_SET_ENTRY_UNQ_NM Unique (
      KEYSET, SEQUENCE);

-- \************************************************************\


CREATE TABLE COSMOS.DATA_SOURCE_TYPE
   (
      ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
      NAME VARCHAR(255) NOT NULL
   );


ALTER TABLE COSMOS.DATA_SOURCE_TYPE
   ADD CONSTRAINT COSMOS.DATA_SOURCE_TYPE_PK Primary Key (
      ID);

ALTER TABLE COSMOS.DATA_SOURCE_TYPE
   ADD CONSTRAINT COSMOS.DATA_SOURCE_TYPE_UNQ_NM Unique (
      NAME);

-- \************************************************************\


CREATE TABLE COSMOS.DATA_SOURCE
   (
      ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
      TYPE INTEGER NOT NULL ,
      NAME VARCHAR(24) NOT NULL
   );


ALTER TABLE COSMOS.DATA_SOURCE
   ADD CONSTRAINT COSMOS.DATA_SOURCE_PK Primary Key (
      ID);

ALTER TABLE COSMOS.DATA_SOURCE
   ADD CONSTRAINT COSMOS.DATA_SOURCE_FK Foreign Key (
      TYPE)
   REFERENCES COSMOS.DATA_SOURCE_TYPE (
      ID);

ALTER TABLE COSMOS.DATA_SOURCE
   ADD CONSTRAINT COSMOS.DATA_SOURCE_UNQ_NM Unique (
      NAME);

-- \************************************************************\

CREATE TABLE COSMOS.DATA_FLOW
   (
      ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
      SOURCE INTEGER NOT NULL ,
      KEYSET INTEGER NOT NULL ,
      NAME VARCHAR(24) NOT NULL
   );


ALTER TABLE COSMOS.DATA_FLOW
   ADD CONSTRAINT COSMOS.DATA_FLOW_PK Primary Key (
      ID);

ALTER TABLE COSMOS.DATA_FLOW
   ADD CONSTRAINT COSMOS.DATA_FLOW_SOURCE_FK Foreign Key (
      SOURCE)
   REFERENCES COSMOS.DATA_SOURCE (
      ID);

ALTER TABLE COSMOS.DATA_FLOW
   ADD CONSTRAINT COSMOS.DATA_FLOW_KEYSET_FK Foreign Key (
      KEYSET)
   REFERENCES COSMOS.KEY_SET (
      ID);

ALTER TABLE COSMOS.DATA_FLOW
   ADD CONSTRAINT COSMOS.DATA_FLOW_UNQ_NM Unique (
      NAME);

-- \************************************************************\

CREATE TABLE COSMOS.DATA_SET
   (
      ID INTEGER GENERATED BY DEFAULT AS IDENTITY,
      FLOW INTEGER NOT NULL ,
      SOURCE INTEGER NOT NULL ,
      START_CAPTURE TIMESTAMP NOT NULL ,
      END_CAPTURE TIMESTAMP ,
      NAME VARCHAR(255) NOT NULL
   );


ALTER TABLE COSMOS.DATA_SET
   ADD CONSTRAINT COSMOS.DATA_SET_PK Primary Key (
      ID);

ALTER TABLE COSMOS.DATA_SET
   ADD CONSTRAINT COSMOS.DATA_SET_FLOW_FK Foreign Key (
      FLOW)
   REFERENCES COSMOS.DATA_FLOW (
      ID);

ALTER TABLE COSMOS.DATA_SET
   ADD CONSTRAINT COSMOS.DATA_SET_SOURCE_FK Foreign Key (
      SOURCE)
   REFERENCES COSMOS.DATA_SOURCE (
      ID);

ALTER TABLE COSMOS.DATA_SET
   ADD CONSTRAINT COSMOS.DATA_SET_UNQ_NM Unique (
      NAME);

