/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.common;

import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SMLCommonUtil {
    public static Node retrieveChildNode(Node parent, String uri, String localName) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (uri.equals(child.getNamespaceURI()) && localName.equals(child.getLocalName())) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public static String retrieveTextNode(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node textNode = children.item(i);
            String currentText = null;
            if (textNode.getNodeType() == 3 && (currentText = textNode.getNodeValue()) != null && (currentText = currentText.trim()).length() > 0) {
                sb.append(currentText);
            }
            ++i;
        }
        StringTokenizer st = new StringTokenizer(sb.toString(), "\n");
        StringBuffer finalTextValue = new StringBuffer();
        while (st.hasMoreTokens()) {
            String currentLine = st.nextToken().trim();
            if (currentLine.length() <= 0) continue;
            if (finalTextValue.length() > 0) {
                finalTextValue.append(" ");
            }
            finalTextValue.append(currentLine);
        }
        return finalTextValue.toString();
    }

    public static Node nestedNodeRetrieval(Node node, String[][] nodeNames) {
        return SMLCommonUtil.nestedNodeRetrieval(node, nodeNames, false, true);
    }

    public static Node nestedNodeRetrieval(Node node, String[][] nodeNames, boolean create, boolean append) {
        Node currentNode = node;
        int i = 0;
        while (i < nodeNames.length) {
            if (currentNode == null) {
                return null;
            }
            Node childNode = SMLCommonUtil.retrieveChildNode(currentNode, nodeNames[i][0], nodeNames[i][1]);
            if (childNode == null && create) {
                childNode = SMLCommonUtil.createFormattedElement(currentNode, nodeNames[i][0], nodeNames[i][1], append);
            }
            currentNode = childNode;
            ++i;
        }
        return currentNode;
    }

    public static Node createElement(Node parentNode, String uri, String localName) {
        Element node = parentNode.getOwnerDocument().createElementNS(uri, localName);
        node.setPrefix(parentNode.getPrefix());
        parentNode.appendChild(node);
        return node;
    }

    public static Node createFormattedElement(Node parentNode, String uri, String localName, boolean append) {
        Element childNode = null;
        Document ownerDocument = parentNode.getOwnerDocument();
        childNode = ownerDocument.createElementNS(uri, localName);
        childNode.setPrefix(parentNode.getPrefix());
        Node firstChild = parentNode.getFirstChild();
        Node sibiling = parentNode.getLastChild();
        Node indentNode = null;
        while (sibiling != null && sibiling.getNodeType() != 1) {
            sibiling = sibiling.getPreviousSibling();
        }
        if (sibiling != null && sibiling.getNodeType() == 1 && SMLValidatorUtil.isWhitespace((Node)(indentNode = sibiling.getPreviousSibling()))) {
            Node lastChildNode = parentNode.getLastChild();
            if (SMLValidatorUtil.isWhitespace((Node)lastChildNode)) {
                parentNode.removeChild(lastChildNode);
            }
            Text indent = ownerDocument.createTextNode(indentNode.getNodeValue());
            if (append) {
                parentNode.appendChild(indent);
            } else {
                parentNode.insertBefore(indent, firstChild);
            }
        }
        if (append) {
            parentNode.appendChild(childNode);
        } else if (indentNode != null) {
            parentNode.insertBefore(childNode, indentNode.getNextSibling());
        } else {
            parentNode.insertBefore(childNode, firstChild);
        }
        Node parentIndent = parentNode.getPreviousSibling();
        if (SMLValidatorUtil.isWhitespace((Node)parentNode)) {
            parentNode.insertBefore(ownerDocument.createTextNode(parentIndent.getNodeValue()), childNode.getNextSibling());
        }
        return childNode;
    }

    public static String[] retrieveAliases(Map userDefinedAliases, ISMLDocument document) {
        String[] userAliases = (String[])userDefinedAliases.get(document.getMetadata().getId());
        userAliases = userAliases == null ? new String[]{} : userAliases;
        String[] fileAliases = document.getMetadata().getAliases();
        fileAliases = fileAliases == null ? new String[]{} : fileAliases;
        String[] finalAliases = new String[userAliases.length + fileAliases.length];
        System.arraycopy(userAliases, 0, finalAliases, 0, userAliases.length);
        System.arraycopy(fileAliases, 0, finalAliases, userAliases.length, fileAliases.length);
        return finalAliases;
    }
}

