/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.rm.smlif.internal.SMLPlugin;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.smlif.internal.editor.AbstractFormPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.DocumentsPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.OverviewPage;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLFormToolkit;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFFormPart;
import org.eclipse.cosmos.rm.smlif.internal.editor.SMLIFTextPage;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SMLIFEditor
extends FormEditor
implements IResourceChangeListener {
    private static final String ID = "org.eclipse.cosmos.rm.smlif.internal.editor.smlifEditor";
    public static final int TYPE_IDENTITY = 0;
    private static final int SMLIF_TEXT_INDEX = 2;
    private OverviewPage overviewPage;
    private DocumentsPage documentsPage;
    private Node rootNode;
    private Node identityNode;
    private boolean reportedError;
    private SMLFormToolkit extendedToolkit;
    private AbstractFormPage[] formPages;
    private Document document;
    private SMLIFFormPart smlifFormPart;
    private boolean needsReload;
    private boolean enableResourceListener;
    private long lastModifiedDate;
    private static ActivateListener activateListener;
    private static IWorkbenchWindow lastWindow;
    private IFile workspaceFile;
    private File localFile;
    private String fileName;
    private SMLIFTextPage smlIFTextPage;

    public SMLIFEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 3);
        this.extendedToolkit = new SMLFormToolkit(SMLPlugin.getDefault().getWorkbench().getDisplay());
        this.smlifFormPart = new SMLIFFormPart(this);
        this.enableResourceListener = true;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.workspaceFile = null;
        this.localFile = null;
        if (input instanceof IFileEditorInput) {
            this.workspaceFile = ((IFileEditorInput)input).getFile();
        } else if (input instanceof IPathEditorInput) {
            this.localFile = new File(((IPathEditorInput)input).getPath().toString());
        }
        if (this.workspaceFile == null && this.localFile == null) {
            throw new PartInitException(SMLMessages.errorEditorWrongInput);
        }
        super.init(site, input);
        this.fileName = this.workspaceFile == null ? this.localFile.getName() : this.workspaceFile.getName();
        this.setPartName(this.fileName);
        if (site != null && lastWindow != site.getWorkbenchWindow()) {
            if (activateListener != null) {
                activateListener.dispose();
            }
            activateListener = new ActivateListener(site);
        }
    }

    protected void addPages() {
        this.overviewPage = new OverviewPage(this);
        this.documentsPage = new DocumentsPage(this);
        this.formPages = new AbstractFormPage[]{this.overviewPage, this.documentsPage};
        try {
            int i = 0;
            while (i < this.formPages.length) {
                this.addPage((IEditorPart)this.formPages[i], this.getEditorInput());
                ++i;
            }
            this.smlIFTextPage = new SMLIFTextPage();
            this.addPage((IEditorPart)this.smlIFTextPage, this.getEditorInput());
            this.setPageText(this.formPages.length, SMLMessages.editorSourceTitle);
            this.getSite().setSelectionProvider(null);
        }
        catch (PartInitException e) {
            SMLValidatorUtil.openErrorWithDetail((String)SMLMessages.errorEditorTitle, (String)SMLMessages.errorEditorPages, (Throwable)e);
        }
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex == 2) {
            this.smlIFTextPage.activated();
        } else {
            this.smlIFTextPage.deactivated();
        }
        super.pageChange(newPageIndex);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        activateListener.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.enableResourceListener = false;
        this.smlifFormPart.commit(true);
        if (!this.isDirty()) {
            this.editorDirtyStateChanged();
        }
        int i = 0;
        while (i < this.formPages.length) {
            this.formPages[i].doSave(monitor);
            ++i;
        }
        this.smlIFTextPage.doSave(monitor);
        this.enableResourceListener = true;
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!this.enableResourceListener || this.workspaceFile == null) {
            return;
        }
        block0 : switch (event.getType()) {
            case 2: {
                this.closeAllEditors(event);
                break;
            }
            case 1: {
                IEditorInput input = this.getEditorInput();
                if (input == null) {
                    return;
                }
                String inputPath = this.workspaceFile.getFullPath().toString();
                if (inputPath == null || inputPath.length() <= 0) {
                    return;
                }
                IResourceDelta[] affectedChildren = event.getDelta().getAffectedChildren();
                ArrayList affectedResourcePaths = new ArrayList();
                this.findAffectedResourcePaths(affectedChildren, affectedResourcePaths);
                int i = 0;
                int resourceCount = affectedResourcePaths.size();
                while (i < resourceCount) {
                    if (inputPath.equals(affectedResourcePaths.get(i))) {
                        this.needsReload = true;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void closeAllEditors(final IResourceChangeEvent resourceChangeEvent) {
        Runnable closeEditors = new Runnable(){

            public void run() {
                IWorkbenchPage[] pages = SMLIFEditor.this.getSite().getWorkbenchWindow().getPages();
                int i = 0;
                while (i < pages.length) {
                    if (resourceChangeEvent == null || SMLIFEditor.this.workspaceFile.getProject().equals((Object)resourceChangeEvent.getResource())) {
                        IEditorPart editorPart = pages[i].findEditor(SMLIFEditor.this.getEditorInput());
                        pages[i].closeEditor(editorPart, true);
                    }
                    ++i;
                }
            }
        };
        Display.getDefault().asyncExec(closeEditors);
    }

    private void findAffectedResourcePaths(IResourceDelta[] affectedChildren, List list) {
        int i = 0;
        while (i < affectedChildren.length) {
            IResourceDelta[] affected = affectedChildren[i].getAffectedChildren();
            if (affected == null || affected.length <= 0) {
                list.add(affectedChildren[i].getFullPath().toString());
            } else {
                this.findAffectedResourcePaths(affected, list);
            }
            ++i;
        }
    }

    public String retrieveField(int type, String name) {
        Node rootDocumentNode = this.getDocumentNode();
        if (rootDocumentNode == null) {
            return null;
        }
        if (type == 0) {
            this.identityNode = this.identityNode == null ? SMLCommonUtil.retrieveChildNode(rootDocumentNode, "http://schemas.serviceml.org/smlif/2007/02", "identity") : this.identityNode;
            return SMLCommonUtil.retrieveTextNode(SMLCommonUtil.retrieveChildNode(this.identityNode, "http://schemas.serviceml.org/smlif/2007/02", name));
        }
        return null;
    }

    public Node retrieveChildNode(String uri, String localName) {
        return SMLCommonUtil.retrieveChildNode(this.getDocumentNode(), uri, localName);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Node getDocumentNode() {
        if (this.rootNode != null) {
            return this.rootNode;
        }
        if (this.getEditorInput() == null) {
            return null;
        }
        if (this.workspaceFile == null && this.localFile == null) {
            return null;
        }
        if (this.workspaceFile != null && !this.workspaceFile.exists()) {
            this.closeAllEditors(null);
            return null;
        }
        InputStream is = null;
        Throwable exception = null;
        int lineNumber = -1;
        try {
            block22: {
                is = this.workspaceFile == null ? new FileInputStream(this.localFile) : this.workspaceFile.getContents();
                this.document = SMLValidatorUtil.domParseDocument((InputStream)is, (boolean)false, (boolean)false);
                NodeList children = this.document.getChildNodes();
                int i = 0;
                int childCount = children.getLength();
                while (i < childCount) {
                    if (children.item(i).getNodeType() == 1) {
                        this.rootNode = children.item(i);
                        break;
                    }
                    ++i;
                }
                if (this.rootNode == null || !"http://schemas.serviceml.org/smlif/2007/02".equals(this.rootNode.getNamespaceURI()) || !"model".equals(this.rootNode.getLocalName())) {
                    this.rootNode = null;
                    throw new SAXException(SMLMessages.errorWrongRootNode);
                }
                Node node = this.rootNode;
                Object var7_15 = null;
                try {
                    if (is == null) return node;
                    is.close();
                    return node;
                }
                catch (IOException iOException) {}
                return node;
                catch (CoreException e) {
                    exception = e;
                    break block22;
                }
                catch (ParserConfigurationException e) {
                    exception = e;
                    break block22;
                }
                catch (SAXParseException e) {
                    exception = e;
                    lineNumber = e.getLineNumber();
                    break block22;
                }
                catch (SAXException e) {
                    exception = e;
                    break block22;
                }
                catch (IOException e) {
                    exception = e;
                }
            }
            Object var7_17 = null;
        }
        catch (Throwable throwable) {
            Object var7_16 = null;
            try {}
            catch (IOException iOException) {}
            if (is == null) throw throwable;
            is.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (is != null) {
            is.close();
        }
        if (exception == null) return null;
        if (this.reportedError) return null;
        this.reportedError = true;
        SMLValidatorUtil.openErrorWithDetail((String)SMLMessages.errorOpeningTitle, (String)(String.valueOf(SMLMessages.errorOpening) + (lineNumber >= 0 ? String.valueOf(IValidationConstants.LINE_SEPARATOR) + NLS.bind((String)SMLMessages.errorOpeningFileLine, (Object)String.valueOf(lineNumber)) : "")), (Throwable)exception);
        int i = 0;
        while (i < this.formPages.length) {
            this.formPages[i].setEnabled(false);
            ++i;
        }
        return null;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.getDocumentNode();
        }
        return this.document;
    }

    public SMLFormToolkit getExtendedToolkit() {
        return this.extendedToolkit;
    }

    public SMLIFFormPart getSmlifFormPart() {
        return this.smlifFormPart;
    }

    public SMLIFTextPage getSmlifTextPage() {
        return this.smlIFTextPage;
    }

    private class ActivateListener
    implements IPartListener2,
    IWindowListener {
        public ActivateListener(IEditorSite site) {
            site.getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            SMLIFEditor.this.getEditorSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        }

        private void turnToTextPage() {
            SMLIFEditor.this.setActivePage(2);
        }

        public void windowActivated(IWorkbenchWindow window) {
            this.handleActivation();
        }

        private void handleActivation() {
            long currentModifiedDate = 0L;
            if (SMLIFEditor.this.workspaceFile == null) {
                return;
            }
            currentModifiedDate = new File(SMLIFEditor.this.workspaceFile.getRawLocation().toString()).lastModified();
            if (currentModifiedDate != 0L && currentModifiedDate != SMLIFEditor.this.lastModifiedDate && !SMLIFEditor.this.workspaceFile.isSynchronized(0)) {
                SMLIFEditor.this.lastModifiedDate = currentModifiedDate;
                if (!SMLIFEditor.this.needsReload && !MessageDialog.openQuestion(null, (String)SMLMessages.editorFileChangedTitle, (String)SMLMessages.editorFileChanged)) {
                    return;
                }
                try {
                    SMLIFEditor.this.workspaceFile.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    SMLValidatorUtil.openErrorWithDetail((String)SMLMessages.errorSynchronizeTitle, (String)SMLMessages.errorSynchronize, (Throwable)e, (boolean)false);
                    return;
                }
                SMLIFEditor.this.needsReload = true;
            }
            if (SMLIFEditor.this.needsReload) {
                SMLIFEditor.this.rootNode = null;
                SMLIFEditor.this.identityNode = null;
                SMLIFEditor.this.document = null;
                int i = 0;
                while (i < SMLIFEditor.this.formPages.length) {
                    SMLIFEditor.this.formPages[i].updateContent();
                    ++i;
                }
            }
            SMLIFEditor.this.needsReload = false;
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPage activePage = SMLPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage == null || !SMLIFEditor.ID.equals(activePage.getActivePart().getSite().getId())) {
                return;
            }
            this.handleActivation();
            if ("org.eclipse.ui.views.ProblemView".equals(partRef.getId())) {
                this.turnToTextPage();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
            IWorkbenchPart workbenchPart = partRef.getPage().getActivePart();
            if (workbenchPart instanceof IViewPart && "org.eclipse.ui.views.ProblemView".equals(((IViewPart)workbenchPart).getViewSite().getId())) {
                this.turnToTextPage();
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    }
}

