/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExportResourceTreeContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        Object[] kids = new IResource[]{};
        if (parentElement instanceof IFile) {
            return kids;
        }
        try {
            kids = ((IContainer)parentElement).members();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (kids.length == 0) {
            return kids;
        }
        return this.buildGoodKids((IResource[])kids);
    }

    protected Object[] buildGoodKids(IResource[] kids) {
        ArrayList<IResource> goodKids = new ArrayList<IResource>(kids.length);
        int i = 0;
        while (i < kids.length) {
            int type;
            IResource resource = this.getRefreshed(kids[i]);
            if (resource instanceof IContainer) {
                if (!resource.getName().startsWith(".") && (resource instanceof IProject || this.hasChildren(resource))) {
                    goodKids.add(resource);
                }
            } else if (!(resource.getName().startsWith(".") || (type = SMLValidatorUtil.identifyDocumentTypeShowError((IFile)((IFile)resource))) != 0 && type != 1)) {
                goodKids.add(resource);
            }
            ++i;
        }
        return goodKids.toArray();
    }

    private IResource getRefreshed(IResource resource) {
        if (resource == null) {
            return null;
        }
        if (!resource.isSynchronized(0)) {
            try {
                resource.refreshLocal(0, null);
            }
            catch (CoreException e) {
                SMLValidatorUtil.openErrorWithDetail((String)SMLMessages.errorSynchronizeTitle, (String)SMLMessages.errorSynchronize, (Throwable)e, (boolean)false);
                return null;
            }
        }
        return resource;
    }

    public Object getParent(Object element) {
        return ((IResource)element).getParent();
    }

    public boolean hasChildren(Object element) {
        IResource res = (IResource)element;
        return res.getType() != 1 && this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

