/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.smlif.internal.export.ui;

import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.smlif.internal.common.SMLCommonUtil;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportToSMLIFWizardPage3;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.ExportWizardRuleBinding;
import org.eclipse.cosmos.rm.smlif.internal.export.ui.RuleBindingTableLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;

public class RuleBindingTableCellModifier
implements ICellModifier {
    private static final Integer NOT_FOUND = new Integer(-1);
    private ExportToSMLIFWizardPage3 wizardPage;
    private List columnProperties;
    private Map userDefinedAliases;

    public RuleBindingTableCellModifier(List columnProperties, ExportToSMLIFWizardPage3 wizardPage, Map userDefinedAliases) {
        this.wizardPage = wizardPage;
        this.columnProperties = columnProperties;
        this.userDefinedAliases = userDefinedAliases;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.columnProperties.indexOf(property);
        Object modelDataForColumn = RuleBindingTableLabelProvider.getModelDataForColumn(element, columnIndex);
        if (modelDataForColumn == null) {
            return NOT_FOUND;
        }
        if ("DOCUMENT_COLUMN".equals(property)) {
            ISMLDocument file = (ISMLDocument)modelDataForColumn;
            return new Integer(this.wizardPage.getDocuments().indexOf(file));
        }
        if ("ALIAS_COLUMN".equals(property)) {
            String alias = (String)modelDataForColumn;
            IStructuredSelection tableSelection = (IStructuredSelection)this.wizardPage.ruleBindingsTableViewer.getSelection();
            ExportWizardRuleBinding selectedBinding = (ExportWizardRuleBinding)((Object)tableSelection.getFirstElement());
            String[] aliasChoices = null;
            if (selectedBinding.getDocument() != null) {
                aliasChoices = SMLCommonUtil.retrieveAliases(this.userDefinedAliases, selectedBinding.getDocument());
            }
            if (aliasChoices != null) {
                int i = 0;
                while (i < aliasChoices.length) {
                    if (aliasChoices[i].equals(alias)) {
                        return new Integer(i);
                    }
                    ++i;
                }
            }
            return alias;
        }
        if ("RULE_COLUMN".equals(property)) {
            String rule = (String)modelDataForColumn;
            String[] ruleChoices = this.wizardPage.ruleChoicesCombo.getItems();
            int i = 0;
            while (i < ruleChoices.length) {
                if (ruleChoices[i].equals(rule)) {
                    return new Integer(i);
                }
                ++i;
            }
            return rule;
        }
        return NOT_FOUND;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.columnProperties.indexOf(property);
        ExportWizardRuleBinding ruleBinding = null;
        if (element instanceof Item) {
            TableItem item = (TableItem)element;
            ruleBinding = (ExportWizardRuleBinding)((Object)item.getData());
        } else {
            ruleBinding = (ExportWizardRuleBinding)((Object)element);
        }
        int selectionIndex = -1;
        if (value instanceof Integer) {
            selectionIndex = (Integer)value;
        }
        switch (columnIndex) {
            case 0: {
                if (selectionIndex == -1) {
                    return;
                }
                List files = this.wizardPage.getDocuments();
                ISMLDocument file = (ISMLDocument)files.get(selectionIndex);
                if (file == null || file.equals(ruleBinding.getDocument())) break;
                ruleBinding.setDocument(file);
                ruleBinding.setAlias(null);
                this.wizardPage.aliasChoicesCombo.setItems(SMLCommonUtil.retrieveAliases(this.userDefinedAliases, file));
                break;
            }
            case 1: {
                String alias = null;
                alias = selectionIndex == -1 ? ((CCombo)this.wizardPage.aliasChoicesCombo.getControl()).getText() : this.wizardPage.aliasChoicesCombo.getItems()[selectionIndex];
                ruleBinding.setAlias(alias);
                break;
            }
            case 2: {
                String rule = null;
                rule = selectionIndex == -1 ? ((CCombo)this.wizardPage.ruleChoicesCombo.getControl()).getText() : this.wizardPage.ruleChoicesCombo.getItems()[selectionIndex];
                ruleBinding.setRule(rule);
                break;
            }
        }
        this.wizardPage.ruleBindingsTableViewer.refresh();
    }
}

