/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.core.FileSystemSMLRepository;
import org.eclipse.cosmos.rm.repository.internal.core.MetadataFileHandler;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataProcessor {
    public static final byte FIELD_NAME = 0;
    public static final byte FIELD_DISPLAY_NAME = 1;
    public static final byte FIELD_VERSION = 2;
    public static final byte FIELD_DESCRIPTION = 3;
    public static final byte FIELD_BASE_URI = 4;
    private FileSystemSMLRepository repository;
    private MetadataFileHandler metadataHandler;

    public MetadataProcessor(FileSystemSMLRepository repository) {
        this.repository = repository;
        this.metadataHandler = new MetadataFileHandler();
        this.load();
    }

    private void load() {
        File metadataFile = new File(String.valueOf(this.repository.getProperty("root.directory", "")) + "/" + ".smlif_meta");
        if (!metadataFile.exists()) {
            return;
        }
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(metadataFile, (DefaultHandler)this.metadataHandler);
            return;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.metadataHandler = new MetadataFileHandler();
    }

    public List retrieveDocuments(Map data, boolean isAlias) {
        Map aliasMap = this.metadataHandler.getAliasFileMap();
        Map ruleBindings = this.metadataHandler.getRuleAliasBinding();
        ArrayList finalListOfFiles = new ArrayList();
        for (String currentKey : data.keySet()) {
            ArrayList listOfData;
            List list = listOfData = isAlias ? (ArrayList)aliasMap.get(currentKey) : (List)ruleBindings.get(currentKey);
            if (!isAlias) {
                ArrayList listOfFiles = new ArrayList();
                if (listOfData != null) {
                    int i = 0;
                    int fileCount = listOfData.size();
                    while (i < fileCount) {
                        List o = (List)aliasMap.get(listOfData.get(i));
                        if (o != null) {
                            listOfFiles.addAll(o);
                        }
                        ++i;
                    }
                }
                listOfData = listOfFiles;
            }
            if (listOfData == null) continue;
            finalListOfFiles.addAll(listOfData);
        }
        SMLFileMetadata metadata = new SMLFileMetadata();
        ArrayList<ISMLDocument> listOfSMLDocuments = new ArrayList<ISMLDocument>();
        int i = 0;
        int fileCount = finalListOfFiles.size();
        while (i < fileCount) {
            metadata.setId((String)finalListOfFiles.get(i));
            ISMLDocument[] documents = null;
            try {
                documents = this.repository.fetchDocuments(metadata);
            }
            catch (RepositoryOperationException e) {
                e.printStackTrace();
            }
            if (documents != null) {
                int j = 0;
                while (j < documents.length) {
                    if (!listOfSMLDocuments.contains(documents[j])) {
                        listOfSMLDocuments.add(documents[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return listOfSMLDocuments;
    }

    public String[] retrieveAliases(String id) {
        ArrayList aliases = new ArrayList();
        this.addAliases(aliases, id);
        this.addAliases(aliases, SMLRepositoryUtil.getAlternativeId(this.repository, id));
        return aliases.toArray(new String[aliases.size()]);
    }

    private void addAliases(List aliases, String id) {
        List al = (List)this.metadataHandler.getFileAliasMap().get(id);
        if (al != null) {
            aliases.addAll(al);
        }
    }

    public Map retrieveBoundRules(String id) {
        Hashtable rules = new Hashtable();
        this.copyMap(this.retrieveRules(id), rules);
        this.copyMap(this.retrieveRules(SMLRepositoryUtil.getAlternativeId(this.repository, id)), rules);
        return rules;
    }

    private void copyMap(Map source, Map destination) {
        Set keys = source.keySet();
        for (String currentKey : keys) {
            List destValue = (List)destination.get(currentKey);
            List srcValue = (List)source.get(currentKey);
            if (destValue == null) {
                destination.put(currentKey, srcValue);
                continue;
            }
            int i = 0;
            int srcValueCount = srcValue.size();
            while (i < srcValueCount) {
                if (!destValue.contains(srcValue.get(i))) {
                    destValue.add(srcValue.get(i));
                }
                ++i;
            }
        }
    }

    private Map retrieveRules(String id) {
        String[] aliases = this.retrieveAliases(id);
        Hashtable<String, List> rules = new Hashtable<String, List>();
        if (aliases != null) {
            int i = 0;
            while (i < aliases.length) {
                List ruleAliases = (List)this.metadataHandler.getAliasRuleBinding().get(aliases[i]);
                if (ruleAliases != null) {
                    rules.put(aliases[i], ruleAliases);
                }
                ++i;
            }
        }
        return rules;
    }

    public void addAliases(String id, String[] aliases) {
        this.metadataHandler.addAlias(id, aliases);
    }

    public void addRuleBinding(String alias, String[] rules) {
        this.metadataHandler.addRuleBinding(alias, rules);
    }

    public void setField(byte field, String value) {
        this.metadataHandler.setField(field, value);
    }

    public void setFields(byte[] fields, String[] values) {
        int fieldCount = Math.min(fields.length, values.length);
        int i = 0;
        while (i < fieldCount) {
            this.metadataHandler.setField(fields[i], values[i]);
            ++i;
        }
    }

    public void write() {
        try {
            if (!this.metadataHandler.isDirty()) {
                return;
            }
            File metadataFile = new File(String.valueOf(this.repository.getProperty("root.directory", "")) + "/" + ".smlif_meta");
            if (!metadataFile.exists()) {
                metadataFile.createNewFile();
            }
            PrintStream metadataPrintStream = new PrintStream(metadataFile);
            this.metadataHandler.write(metadataPrintStream);
            metadataPrintStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MetadataFileHandler getMetadataHandler() {
        return this.metadataHandler;
    }
}

