/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.cosmos.rm.repository.internal.SMLRepositoryUtil;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLDocumentFragment;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocumentFragment;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLMetadata;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SMLFileDocument
implements ISMLDocument {
    private ISMLRepository repository;
    private ISMLMetadata metadata;
    private long lastModifiedDate;
    private Document domDocument;

    public SMLFileDocument(ISMLRepository repository) {
        this.repository = repository;
    }

    public ISMLMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ISMLMetadata metadata) {
        this.metadata = metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISMLDocumentFragment retrieveDocumentFragment(NamespaceContext namespaceContext, Node contextNode, String xpathExpression) throws RepositoryOperationException {
        if (this.getDOMDocument() == null) {
            return null;
        }
        try {
            XPath xPath = SMLValidatorUtil.xpath;
            synchronized (xPath) {
                if (namespaceContext != null) {
                    SMLValidatorUtil.xpath.setNamespaceContext(namespaceContext);
                }
                XPathExpression fieldXPath = SMLValidatorUtil.xpath.compile(xpathExpression);
                NodeList nodeList = (NodeList)fieldXPath.evaluate(contextNode == null ? this.getDOMDocument().getFirstChild() : contextNode, XPathConstants.NODESET);
                SMLDocumentFragment fragment = new SMLDocumentFragment();
                fragment.setParentDocument(this);
                fragment.setNodeList(nodeList);
                return fragment;
            }
        }
        catch (XPathExpressionException e) {
            throw new RepositoryOperationException(e.getLocalizedMessage(), e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ISMLDocument)) {
            return false;
        }
        ISMLMetadata metadata = ((ISMLDocument)o).getMetadata();
        if (this.metadata != null && this.metadata.getId() != null && metadata != null) {
            return this.metadata.getId().equals(metadata.getId());
        }
        return this == o;
    }

    public ISMLRepository getRepository() {
        return this.repository;
    }

    protected long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Document getDOMDocument() throws RepositoryOperationException {
        if (this.metadata == null || this.metadata.getId() == null) {
            return null;
        }
        File document = new File(this.metadata.getId());
        if (this.domDocument == null || document.lastModified() != this.lastModifiedDate) {
            if (!document.exists()) {
                return null;
            }
            try {
                this.domDocument = SMLValidatorUtil.domParseDocument((InputStream)new FileInputStream(document));
            }
            catch (Exception e) {
                throw new RepositoryOperationException(e.getLocalizedMessage(), e);
            }
        }
        return this.domDocument;
    }

    public String retrieveRootAttribute(String uri, String localName) throws RepositoryOperationException {
        Document document = this.getDOMDocument();
        Node node = document == null ? null : document.getFirstChild();
        return SMLRepositoryUtil.retrieveRootAttribute(node, uri, localName);
    }
}

