/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.repository.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileDocument;
import org.eclipse.cosmos.rm.repository.internal.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.repository.provisional.core.ISMLRepository;
import org.eclipse.cosmos.rm.repository.provisional.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDefinitionDocument;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLDocument;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLInstanceDocument;
import org.eclipse.cosmos.rm.repository.provisional.resource.ISMLMetadata;
import org.eclipse.cosmos.rm.validation.internal.common.ReferenceExtractor;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.xml.sax.helpers.DefaultHandler;

public class SMLFileInstanceDocument
extends SMLFileDocument
implements ISMLInstanceDocument,
Comparable {
    private List references;

    public SMLFileInstanceDocument(ISMLRepository repository) {
        super(repository);
    }

    public ISMLDocument[] retrieveReferences(ISMLMetadata metadata) throws RepositoryOperationException {
        if (this.getMetadata() == null || this.getMetadata().getId() == null) {
            return new ISMLDocument[0];
        }
        File document = new File(this.getMetadata().getId());
        if (this.references == null || super.getLastModifiedDate() != document.lastModified()) {
            if (!document.exists()) {
                return new ISMLDocument[0];
            }
            ReferenceExtractor referenceExtractor = new ReferenceExtractor();
            try {
                SMLValidatorUtil.saxParseDocument((InputStream)new FileInputStream(document), (DefaultHandler)referenceExtractor);
            }
            catch (Exception e) {
                throw new RepositoryOperationException(e.getLocalizedMessage(), e);
            }
            this.references = (List)referenceExtractor.getDataStructure();
        }
        String[] smlURIs = this.references.toArray(new String[this.references.size()]);
        int i = 0;
        while (i < smlURIs.length) {
            int anchor = smlURIs[i].indexOf(35);
            if (anchor > 0) {
                smlURIs[i] = smlURIs[i].substring(0, anchor);
            }
            smlURIs[i] = smlURIs[i].trim();
            ++i;
        }
        SMLFileMetadata queryMetadata = new SMLFileMetadata();
        queryMetadata.setAliases(smlURIs);
        TreeSet<ISMLDocument> references = new TreeSet<ISMLDocument>();
        ISMLDocument[] referencedDocuments = this.getRepository().fetchDocuments(queryMetadata);
        int i2 = 0;
        while (i2 < referencedDocuments.length) {
            references.add(referencedDocuments[i2]);
            ++i2;
        }
        queryMetadata.setAliases(null);
        i2 = 0;
        while (i2 < smlURIs.length) {
            queryMetadata.setId(smlURIs[i2]);
            referencedDocuments = this.getRepository().fetchDocuments(queryMetadata);
            if (referencedDocuments != null && referencedDocuments.length == 1) {
                references.add(referencedDocuments[0]);
            }
            ++i2;
        }
        if (referencedDocuments == null) {
            return new ISMLDocument[0];
        }
        ArrayList<ISMLDocument> finalDocumentList = new ArrayList<ISMLDocument>();
        for (ISMLDocument currentDocument : references) {
            ISMLMetadata documentMetadata = currentDocument.getMetadata();
            if (!this.isEqual(new String[]{metadata.getId(), metadata.getRootElementName()}, new String[]{documentMetadata.getId(), documentMetadata.getRootElementName()}) || !this.isEqual(metadata.getAliases(), documentMetadata.getAliases()) || !this.isEqual(metadata.getBoundRules(), documentMetadata.getBoundRules()) || !this.isEqual(metadata.getDocumentType(), documentMetadata.getDocumentType())) continue;
            finalDocumentList.add(currentDocument);
        }
        return finalDocumentList.toArray(new ISMLDocument[finalDocumentList.size()]);
    }

    private boolean isEqual(Map expected, Map actual) {
        if (expected == null) {
            return actual == null || actual.size() == 0;
        }
        if (expected.size() != actual.size()) {
            return false;
        }
        for (String currentKey : expected.keySet()) {
            if (expected.get(currentKey).equals(actual.get(currentKey))) continue;
            return false;
        }
        return true;
    }

    private boolean isEqual(int expected, int actual) {
        if (expected < 0) {
            return true;
        }
        return expected == actual;
    }

    private boolean isEqual(String[] expected, String[] actual) {
        if (expected == null || expected.length == 0) {
            return true;
        }
        boolean foundEntry = true;
        int j = 0;
        while (j < expected.length) {
            if (expected[j] != null) {
                foundEntry = false;
                if (actual != null) {
                    int j2 = 0;
                    while (j2 < actual.length) {
                        if (expected[j].equals(actual[j2])) {
                            foundEntry = true;
                            break;
                        }
                        ++j2;
                    }
                }
                if (!foundEntry) {
                    return false;
                }
            }
            ++j;
        }
        return true;
    }

    public ISMLDefinitionDocument retrieveDefinition() throws RepositoryOperationException {
        ISMLDocument[] definitionDocument;
        String filePath;
        String schemaLocation = this.retrieveRootAttribute("http://www.w3.org/2001/XMLSchema", "schemaLocation");
        if (schemaLocation == null) {
            return null;
        }
        int inx = schemaLocation.lastIndexOf(32);
        int n = inx = inx < 0 ? schemaLocation.lastIndexOf(9) : inx;
        if (inx >= 0) {
            schemaLocation = schemaLocation.substring(inx + 1).trim();
        }
        if (!schemaLocation.startsWith("/") && (filePath = this.getMetadata().getId()) != null) {
            inx = filePath.lastIndexOf(47);
            if (inx >= 0) {
                filePath = filePath.substring(0, inx + 1);
            }
            schemaLocation = String.valueOf(filePath) + schemaLocation;
        }
        return (definitionDocument = this.getRepository().fetchDocuments(new SMLFileMetadata(schemaLocation, -1, null, null, null))) != null && definitionDocument.length == 1 && definitionDocument[0] instanceof ISMLDefinitionDocument ? (ISMLDefinitionDocument)definitionDocument[0] : null;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof SMLFileDocument) {
            ISMLMetadata metadata = ((SMLFileDocument)arg0).getMetadata();
            String id = this.getMetadata() == null ? null : this.getMetadata().getId();
            return id == null ? -1 : id.compareTo(metadata.getId());
        }
        return -1;
    }

    public String toString() {
        return super.toString();
    }
}

