/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.common.TextOutput;

public class FileOutput
extends TextOutput {
    private File file;
    private BufferedWriter bufferedWriter;

    public void initialize(Map attributes) {
        String filePath = (String)attributes.get("attribute.file.output");
        try {
            if (filePath != null) {
                this.file = new File(filePath);
                FileOutputStream fileOutput = new FileOutputStream(filePath);
                this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutput));
                return;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {}
        this.file = null;
    }

    public String getFilePath() {
        if (this.file == null) {
            return SMLMessages.outputSystem;
        }
        return this.file.getAbsolutePath();
    }

    protected void writeMessage(String message) {
        try {
            if (this.bufferedWriter == null) {
                this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
            }
            this.bufferedWriter.write(String.valueOf(message) + IValidationConstants.LINE_SEPARATOR);
            this.bufferedWriter.flush();
        }
        catch (IOException iOException) {
            this.file = null;
            this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        }
    }

    public void close() {
        try {
            if (this.bufferedWriter != null) {
                this.bufferedWriter.close();
            }
        }
        catch (IOException iOException) {}
    }
}

