/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.core.IValidationListener;
import org.eclipse.cosmos.rm.validation.internal.core.IValidator;
import org.eclipse.cosmos.rm.validation.internal.core.ValidationEvent;

public abstract class AbstractValidator
implements IValidator {
    private IValidationOutput validationOutput;
    private Collection validationListeners;

    public void initialize(Map validationAttribute) {
        this.validationOutput = (IValidationOutput)validationAttribute.get("validation.output");
    }

    public IValidationOutput getValidationOutput() {
        return this.validationOutput;
    }

    public void setValidationOutput(IValidationOutput validationOutput) {
        this.validationOutput = validationOutput;
    }

    public final void addValidationListener(IValidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList();
        }
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    protected final void fireValidationEventOccurred(ValidationEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners != null) {
            Iterator listenerItr = this.validationListeners.iterator();
            while (listenerItr.hasNext()) {
                IValidationListener listener = (IValidationListener)listenerItr.next();
                listener.validationErrorOccurred(event);
            }
        }
    }
}

