/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.databuilders;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cosmos.rm.validation.internal.artifacts.TargetSchemaNode;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.util.ParserHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TargetSchemaBuilder
extends AbstractDataBuilder
implements IDataBuilder {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TargetSchemaBuilder";
    protected Map dataStructure = new HashMap();
    protected boolean uriElementFound = false;

    public Object getDataStructure() {
        return this.dataStructure;
    }

    public void startSchema(String uri) {
    }

    public void endSchema(String uri) {
        Map substitionMap = (Map)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.SubstitutionBuilder");
        Iterator iter = this.dataStructure.keySet().iterator();
        iter = substitionMap.keySet().iterator();
        while (iter.hasNext()) {
            Object namespaceURI = iter.next();
            String elementNameNonNS = ParserHelper.removeNameSpace((String)namespaceURI);
            TargetSchemaNode targetSchemaNode = (TargetSchemaNode)this.dataStructure.get(elementNameNonNS);
            if (targetSchemaNode != null) {
                Object substitionName = substitionMap.get(namespaceURI);
                TargetSchemaNode subTargetSchemaNode = (TargetSchemaNode)this.dataStructure.get(substitionName);
                targetSchemaNode.setSubstitutionGroup(subTargetSchemaNode);
                continue;
            }
            Map substitutionMap = (Map)substitionMap.get(namespaceURI);
            Iterator subtitutions = substitutionMap.keySet().iterator();
            while (subtitutions.hasNext()) {
                String elementName = (String)subtitutions.next();
                String substitutedElement = (String)substitutionMap.get(elementName);
                substitutedElement = substitutedElement == null ? null : ParserHelper.removeNameSpace(substitutedElement);
                TargetSchemaNode subTargetSchemaNode = (TargetSchemaNode)this.dataStructure.get(substitutedElement);
                if (subTargetSchemaNode == null) continue;
                this.dataStructure.put(elementNameNonNS, subTargetSchemaNode);
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("schema".equals(localName)) {
            this.startSchema(uri);
        } else if ("element".endsWith(localName)) {
            String elementName = attributes.getValue("name");
            String targetElement = attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "targetElement");
            String targetType = attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "targetType");
            String targetRequired = attributes.getValue("http://schemas.serviceml.org/sml/2007/02", "targetRequired");
            if (targetElement != null || targetType != null || targetRequired != null) {
                TargetSchemaNode schemaNode = new TargetSchemaNode(elementName, this.getFilePath(), this.locator == null ? -1 : this.locator.getLineNumber(), this.locator == null ? -1 : this.locator.getColumnNumber());
                schemaNode.setTargetElement(targetElement);
                schemaNode.setTargetType(targetType);
                schemaNode.setRequired(targetRequired);
                this.dataStructure.put(elementName, schemaNode);
            }
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("schema".equals(localName)) {
            this.endSchema(uri);
        }
    }

    public byte getPhase() {
        return 1;
    }
}

