/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.smlvalidators;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementModel;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.validation.internal.core.AbstractSMLValidator;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.ElementSourceBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.SMLValidatingBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaValidator
extends AbstractSMLValidator {
    private static final String VALIDATION_ERROR_PREFIX = "cvc";
    List validators;
    private List schemas;
    private IValidationOutput validationLogger;
    private boolean smlIfInput;
    private String input;

    public boolean validate() {
        boolean success;
        block12: {
            success = true;
            this.validationLogger = this.getValidationOutput();
            SMLValidatingBuilder validatingBuilder = new SMLValidatingBuilder();
            IDataBuilder elementSourceBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSourceHandler");
            this.schemas = ((ElementSourceBuilder)elementSourceBuilder).getSchemas();
            ArrayList<ByteArrayInputStream> schemaSourcesList = new ArrayList<ByteArrayInputStream>();
            Iterator iter = this.schemas.iterator();
            while (iter.hasNext()) {
                ElementModel schemaModel = (ElementModel)iter.next();
                StringBuffer buffer = new StringBuffer();
                buffer.append(schemaModel.getSource());
                schemaSourcesList.add(new ByteArrayInputStream(buffer.toString().getBytes()));
            }
            InputStream[] schemaSources = new InputStream[schemaSourcesList.size()];
            schemaSourcesList.toArray(schemaSources);
            ElementModel currentInstance = null;
            try {
                SAXParser newSaxParser = SMLValidatorUtil.createSAXParser(schemaSources, true, null, this.validationLogger);
                Iterator iter2 = ((ElementSourceBuilder)elementSourceBuilder).getInstances().iterator();
                while (iter2.hasNext()) {
                    currentInstance = (ElementModel)iter2.next();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(currentInstance.getSource());
                    try {
                        newSaxParser.parse(new InputSource(new ByteArrayInputStream(buffer.toString().getBytes())), (DefaultHandler)validatingBuilder);
                    }
                    catch (SAXParseException e) {
                        boolean validationError = e.getMessage().startsWith(VALIDATION_ERROR_PREFIX);
                        int lineNumber = -1;
                        ElementModel errorLocation = null;
                        if (validationError) {
                            errorLocation = currentInstance;
                            lineNumber = currentInstance.getLineNumber() + e.getLineNumber();
                        } else {
                            errorLocation = currentInstance;
                            lineNumber = currentInstance.getLineNumber();
                        }
                        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(errorLocation == null ? null : errorLocation.getFilePath(), lineNumber, e.getColumnNumber(), e.getLocalizedMessage()));
                        success = false;
                        if (!this.shouldAbortOnError()) continue;
                        return success;
                    }
                }
            }
            catch (SAXException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                success = false;
                if (this.shouldAbortOnError()) {
                    return success;
                }
            }
            catch (ParserConfigurationException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                success = false;
                if (this.shouldAbortOnError()) {
                    return success;
                }
            }
            catch (IOException e) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, e.getLocalizedMessage()));
                success = false;
                if (!this.shouldAbortOnError()) break block12;
                return success;
            }
        }
        return success;
    }

    public void initialize(Map validationAttribute) {
        super.initialize(validationAttribute);
        this.smlIfInput = !(validationAttribute.get("validation.input.type") instanceof String) || !"value.sml.unit".equals(validationAttribute.get("validation.input.type"));
        this.input = (String)validationAttribute.get("validation.instance");
        DataBuilderRegistry builderRegistry = DataBuilderRegistry.instance();
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.XMLDefaultHandler", new DocumentDOMBuilder());
        builderRegistry.registerDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementSourceHandler", new ElementSourceBuilder(this.smlIfInput ? this.input : null));
    }
}

