/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.common;

import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.registry.DataFlow;
import org.eclipse.cosmos.dc.common.registry.DataSet;
import org.eclipse.cosmos.dc.common.registry.DataSource;
import org.eclipse.cosmos.dc.common.registry.Dimension;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.spi.InboundContext;
import org.eclipse.cosmos.dc.common.spi.OutboundContext;
import org.eclipse.cosmos.dc.common.spi.RuntimeHost;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ConsoleExtension
implements CommandProvider {
    BundleContext context;
    private static RuntimeHost runtime;

    public static void setRuntime(RuntimeHost rt) {
        runtime = rt;
    }

    public ConsoleExtension(BundleContext context) {
        this.context = context;
        Hashtable props = new Hashtable();
        context.registerService(CommandProvider.class.getName(), (Object)this, props);
    }

    public void _dc(CommandInterpreter ci) throws Exception {
        block32: {
            String key;
            block37: {
                block36: {
                    block35: {
                        block34: {
                            block33: {
                                if (runtime == null) {
                                    System.out.println("No Runtime available");
                                    return;
                                }
                                key = ci.nextArgument();
                                if (!"start".equals(key)) break block33;
                                runtime.start();
                                break block32;
                            }
                            if (!"load".equals(key)) break block34;
                            String name = ci.nextArgument();
                            if (name == null) break block32;
                            try {
                                URL resource;
                                Bundle bundle = this.getBundleForLoadTarget(name);
                                if (bundle != null && (resource = bundle.getResource("/META-INF/cosmos/" + name)) != null) {
                                    runtime.loadContextFromStream(resource.openStream());
                                }
                                break block32;
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            break block32;
                        }
                        if (!"activate".equals(key)) break block35;
                        String name = ci.nextArgument();
                        if (name == null) break block32;
                        IDataCollectionContext ctx = runtime.getContextForName(name);
                        if (ctx == null) {
                            System.out.println("Unknown context " + name);
                        } else {
                            if (ctx instanceof InboundContext) {
                                ((InboundContext)((Object)ctx)).activate();
                            }
                            System.out.println("Context " + name + " activated");
                        }
                        break block32;
                    }
                    if (!"deactivate".equals(key)) break block36;
                    String name = ci.nextArgument();
                    if (name == null) break block32;
                    IDataCollectionContext ctx = runtime.getContextForName(name);
                    if (ctx == null) {
                        System.out.println("Unknown context " + name);
                    } else {
                        if (ctx instanceof InboundContext) {
                            ((InboundContext)((Object)ctx)).deactivate();
                        }
                        System.out.println("Context " + name + " deactivated");
                    }
                    break block32;
                }
                if (!"query".equals(key)) break block37;
                String name = ci.nextArgument();
                if (name == null) break block32;
                IDataCollectionContext ctx = runtime.getContextForName(name);
                if (ctx == null) {
                    System.out.println("Unknown context " + name);
                } else if (ctx instanceof OutboundContext) {
                    String dialect = ci.nextArgument();
                    String response = ci.nextArgument();
                    String queryString = ci.nextArgument();
                    String dataSource = ci.nextArgument();
                    IDataQueryService query = ((OutboundContext)((Object)ctx)).getRootQuery();
                    if (query.supportedQuery(dialect, response)) {
                        query.query(dialect, response, queryString, dataSource);
                    } else {
                        System.out.println("Unsupported query combination");
                    }
                } else {
                    System.out.println("Unable to query InboundContext " + name);
                }
                break block32;
            }
            if ("list".equals(key)) {
                String name = ci.nextArgument();
                if ("contexts".equals(name)) {
                    Collection<IDataCollectionContext> contexts = runtime.getContexts();
                    for (IDataCollectionContext ctx : contexts) {
                        String mode = "inbound";
                        if (ctx instanceof OutboundContext) {
                            mode = "outbound";
                        }
                        System.out.println(String.valueOf(ctx.getName()) + " " + mode);
                    }
                } else if ("datasets".equals(name)) {
                    ProviderRegistry reg = runtime.getRegistry();
                    ci.nextArgument();
                    String constraint = ci.nextArgument();
                    if ("flow".equals(constraint)) {
                        Collection<DataFlow> flows = reg.getAllDataFlows();
                        for (DataFlow flow : flows) {
                            Collection<DataSet> sets = reg.getDataSetsForFlow(flow);
                            if (sets.isEmpty()) continue;
                            System.out.println("Flow " + flow.getName());
                            for (DataSet set : sets) {
                                System.out.println("  DataSet " + set.getName());
                            }
                        }
                    } else if ("source".equals(constraint)) {
                        Collection<DataSource> sources = reg.getAllDataSources();
                        for (DataSource source : sources) {
                            Collection<DataSet> sets = reg.getDataSetsForSource(source);
                            if (sets.isEmpty()) continue;
                            System.out.println("Source " + source.getName());
                            for (DataSet set : sets) {
                                System.out.println("  DataSet " + set.getName());
                            }
                        }
                    } else {
                        Collection<DataSet> sets = reg.getAllDataSets();
                        for (DataSet set : sets) {
                            System.out.println("DataSet " + set.getName());
                            System.out.println("  Source " + set.getDataSource().getName());
                            System.out.println("  Start " + set.getStart());
                            System.out.println("  Stop " + set.getStop());
                            System.out.println("  Flow " + set.getDataFlow().getName());
                            System.out.println("  Source " + set.getDataFlow().getDataSource().getName());
                            System.out.println("  Dimensions ");
                            Collection<Dimension> dims = set.getDataFlow().getDimensionSet().getDimensions();
                            for (Dimension dim : dims) {
                                System.out.println("      Dim " + dim.getName());
                            }
                        }
                    }
                }
            }
        }
    }

    public void stop() {
        if (runtime != null) {
            runtime.stop();
        }
    }

    public String getHelp() {
        return "dc (start|stop) registers or unregisters service";
    }

    /*
     * Unable to fully structure code
     */
    private Bundle getBundleForLoadTarget(String target) {
        var6_3 = bundles = this.context.getBundles();
        var4_4 = 0;
        var5_5 = var6_3.length;
        while (var4_4 < var5_5) {
            block9: {
                bundle = var6_3[var4_4];
                try {
                    resources = bundle.getEntryPaths("META-INF/cosmos/");
                    if (resources == null) break block9;
                    switch (bundle.getState()) {
                        case 32: {
                            ** GOTO lbl19
                        }
                        case 4: {
                            bundle.start();
                            if (true) ** GOTO lbl19
                        }
                    }
                    break block9;
                    do {
                        if (!(element = (String)resources.nextElement()).endsWith("/" + target)) continue;
                        return bundle;
lbl19:
                        // 3 sources

                    } while (resources.hasMoreElements());
                }
                catch (NoSuchElementException v0) {
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            ++var4_4;
        }
        return null;
    }
}

