/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.fastxpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.eclipse.tptp.platform.provisional.fastxpath.ByteCodeInfo;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContextFactory;
import org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerNotAvailableException;

public class FastXPathAPI {
    public static final String FXP_BINDING_FACTORY = "FXP_BINDING_FACTORY";
    public static final String FXP_BINDING_FACTORY_DEFAULT = "org.eclipse.tptp.platform.provisional.fastxpath.emf.EMFFastXPathContextFactory";
    public static String bindingFactory;
    public static boolean debug;
    public static final CompiledExpressionEvaluator FAILED_COMPILATION_STUB;
    protected IFastXPathEngine fastXPathEngine = null;
    protected Map compiledXpathExpressions = new HashMap();
    protected LinkedList compiledXpathExpressionsFIFO = new LinkedList();
    protected Map xPathByteCodeIndexMap = null;
    protected boolean compileExpressions = true;
    protected boolean useSerializedByteCodeCache = true;
    protected FileChannel serializedCacheChannel = null;
    protected ByteBuffer xPathByteCodeCache = null;
    protected FileChannel serializedIndexChannel = null;
    protected ByteBuffer xPathByteCodeIndex = null;
    protected byte[] writeBuffer = null;
    protected byte[] readBuffer = null;
    protected ByteBuffer readByteBuffer = null;
    protected long currentSerializedCacheOffset = 0L;
    protected boolean isSerializedCacheDirty = false;
    protected long currentSerializedIndexOffset = 0L;
    protected boolean isSerializedIndexDirty = false;
    protected int expressionCountThreshold = 20000;
    private static FastXPathAPI globalXPathEngine;
    static /* synthetic */ Class class$0;

    static {
        String value;
        bindingFactory = FXP_BINDING_FACTORY_DEFAULT;
        debug = false;
        FAILED_COMPILATION_STUB = new CompiledExpressionEvaluator(){

            public Object eval(Object object, IFastXPathEngine fastXPathEngine) {
                return null;
            }
        };
        bindingFactory = System.getProperty(FXP_BINDING_FACTORY);
        if (bindingFactory == null) {
            bindingFactory = FXP_BINDING_FACTORY_DEFAULT;
        }
        if ((value = FastXPathAPI.getPlatformDebugOption("org.eclipse.tptp.platform.models/debug")) != null) {
            debug = value.equalsIgnoreCase("true");
        } else if (System.getProperty("ModelDebugger.debug") != null) {
            debug = Boolean.valueOf(System.getProperty("ModelDebugger.debug"));
        }
    }

    public static String getPlatformDebugOption(String option) {
        if (option == null) {
            return null;
        }
        try {
            Class<?> platform = Class.forName("org.eclipse.core.runtime.Platform");
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Method getDebugOption = platform.getMethod("getDebugOption", classArray);
            String value = (String)getDebugOption.invoke(null, (Object[])new String[]{option});
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FastXPathAPI(FastXPathContextFactory factory) throws InstantiationException {
        if (factory == null) {
            try {
                factory = (FastXPathContextFactory)this.getClass().getClassLoader().loadClass(bindingFactory).newInstance();
            }
            catch (Exception exception) {
                throw new InstantiationException("Error initializing " + bindingFactory);
            }
        }
        Class<?> c = null;
        int mode = 0;
        try {
            c = this.getClass().getClassLoader().loadClass("org.apache.xpath.XPathAPI");
            c.newInstance();
            mode = 1;
        }
        catch (Throwable throwable) {
            try {
                c = this.getClass().getClassLoader().loadClass("com.sun.org.apache.xpath.internal.XPathAPI");
                c.newInstance();
                mode = 2;
            }
            catch (Throwable e1) {
                throw new InstantiationException("Error initializing FastXPathEngine: " + e1.getCause());
            }
        }
        if (mode == 1) {
            try {
                c = this.getClass().getClassLoader().loadClass("org.eclipse.tptp.platform.provisional.jre14.fastxpath.FastXPathEngine");
                this.fastXPathEngine = (IFastXPathEngine)c.newInstance();
            }
            catch (Throwable e1) {
                throw new InstantiationException("Error initializing FastXPathEngine: " + e1.getCause());
            }
        }
        if (mode == 2) {
            try {
                c = this.getClass().getClassLoader().loadClass("org.eclipse.tptp.platform.provisional.sun50.fastxpath.FastXPathEngine");
                this.fastXPathEngine = (IFastXPathEngine)c.newInstance();
            }
            catch (Throwable e1) {
                throw new InstantiationException("Error initializing FastXPathEngine: " + e1.getCause());
            }
        }
        if (this.fastXPathEngine != null) {
            this.fastXPathEngine.setFastXPathContextFactory(factory);
        }
    }

    public boolean match(Object obj, String xpathExpr) throws TransformerException, ExpressionEvaluationException {
        return this.eval(obj, xpathExpr) == obj;
    }

    public Object eval(Object obj, String xpathExpr) throws TransformerException, ExpressionEvaluationException {
        if (this.compileExpressions) {
            CompiledExpressionEvaluator compiledEvaluator = this.getCompiledExpressionEvaluator(obj, xpathExpr);
            if (compiledEvaluator != null && FAILED_COMPILATION_STUB != compiledEvaluator) {
                try {
                    return this.fastXPathEngine.evalCompiled(compiledEvaluator, obj);
                }
                catch (NullPointerException nullPointerException) {
                    if (debug) {
                        System.out.println("NPE in the compiled expression: " + xpathExpr);
                    }
                }
            } else if (debug) {
                System.out.println("Failed to compile expression: " + xpathExpr);
            }
        }
        return this.fastXPathEngine.eval(xpathExpr, obj);
    }

    public Object[] selectNodes(Object obj, String xpathExpr) throws TransformerException, ExpressionEvaluationException {
        return this.fastXPathEngine.selectNodes(xpathExpr, obj);
    }

    public boolean setCompile(boolean compileExpressions) {
        boolean oldMode = this.compileExpressions;
        this.compileExpressions = compileExpressions;
        return oldMode;
    }

    public synchronized CompiledExpressionEvaluator getCompiledExpressionEvaluator(Object obj, String queryExpr) {
        CompiledExpressionEvaluator compiledEvaluator = (CompiledExpressionEvaluator)this.compiledXpathExpressions.get(queryExpr);
        if (compiledEvaluator == null) {
            try {
                if (this.useSerializedByteCodeCache && this.getByteCodeCache() != null) {
                    ByteCodeInfo info = (ByteCodeInfo)this.getByteCodeIndexMap().get(queryExpr);
                    if (info != null) {
                        this.readByteBuffer = ByteBuffer.allocate(info.getLenght());
                        this.serializedCacheChannel.read(this.readByteBuffer, info.getOffset());
                        compiledEvaluator = this.createCompiledExpressionEvaluator(this.readByteBuffer.array(), queryExpr);
                    } else {
                        compiledEvaluator = this.fastXPathEngine.compile(queryExpr, obj, null);
                        if (compiledEvaluator == null) {
                            compiledEvaluator = FAILED_COMPILATION_STUB;
                        }
                        byte[] byteCode = (byte[])this.fastXPathEngine.getClassesAsByteArrays().get(queryExpr);
                        this.updateCacheAndIndex(queryExpr, byteCode);
                        this.fastXPathEngine.getClassesAsByteArrays().remove(queryExpr);
                    }
                } else {
                    compiledEvaluator = this.fastXPathEngine.compile(queryExpr, obj, null);
                    if (compiledEvaluator == null) {
                        compiledEvaluator = FAILED_COMPILATION_STUB;
                    }
                }
            }
            catch (Throwable throwable) {
                compiledEvaluator = FAILED_COMPILATION_STUB;
            }
            if (this.compiledXpathExpressionsFIFO.size() == this.expressionCountThreshold) {
                this.compiledXpathExpressions.remove(this.compiledXpathExpressionsFIFO.get(0));
                this.compiledXpathExpressionsFIFO.remove(0);
            }
            this.compiledXpathExpressionsFIFO.add(queryExpr);
            this.compiledXpathExpressions.put(queryExpr, compiledEvaluator);
        }
        return compiledEvaluator;
    }

    protected synchronized void updateCacheAndIndex(String queryExpr, byte[] byteCode) throws IOException, UnsupportedEncodingException {
        ByteCodeInfo info = new ByteCodeInfo();
        info.setLenght(byteCode.length);
        info.setOffset(this.currentSerializedCacheOffset);
        this.getByteCodeCache().clear();
        this.getByteCodeCache().put(byteCode, 0, byteCode.length);
        this.getByteCodeCache().limit(byteCode.length);
        this.getByteCodeCache().flip();
        this.serializedCacheChannel.write(this.getByteCodeCache());
        this.isSerializedCacheDirty = true;
        this.currentSerializedCacheOffset += (long)byteCode.length;
        this.xPathByteCodeIndex.clear();
        byte[] b = queryExpr.getBytes("UTF-8");
        int recLength = 4 + b.length + 8 + 4;
        if (this.xPathByteCodeIndex.capacity() < recLength) {
            this.xPathByteCodeIndex = ByteBuffer.allocate(recLength);
        }
        this.xPathByteCodeIndex.putInt(b.length);
        this.xPathByteCodeIndex.put(b, 0, b.length);
        this.xPathByteCodeIndex.putLong(info.getOffset());
        this.xPathByteCodeIndex.putInt(info.getLenght());
        this.xPathByteCodeIndex.limit(recLength);
        this.xPathByteCodeIndex.flip();
        this.serializedIndexChannel.write(this.xPathByteCodeIndex);
        this.isSerializedIndexDirty = true;
        this.getByteCodeIndexMap().put(queryExpr, info);
    }

    protected ByteBuffer getByteCodeCache() {
        if (this.xPathByteCodeCache == null) {
            try {
                this.initByteCodeIndexAndCache(null);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException(e);
            }
        }
        return this.xPathByteCodeCache;
    }

    public IFastXPathEngine getFastXPathEngine() {
        return this.fastXPathEngine;
    }

    public void storeCompiledExpressions(File file) throws FileNotFoundException, IOException, CodeGenerationError {
        if (!this.useSerializedByteCodeCache) {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
            HashMap expressionsToClassBytes = new HashMap();
            Map classesAsBytes = this.fastXPathEngine.getClassesAsByteArrays();
            Iterator iter = classesAsBytes.keySet().iterator();
            while (iter.hasNext()) {
                String xpath = (String)iter.next();
                expressionsToClassBytes.put(xpath, classesAsBytes.get(xpath));
            }
            objectOutputStream.writeObject(expressionsToClassBytes);
            objectOutputStream.close();
        } else {
            if (this.isSerializedCacheDirty && this.serializedCacheChannel != null) {
                this.getByteCodeCache().flip();
                this.serializedCacheChannel.write(this.getByteCodeCache());
                this.isSerializedCacheDirty = false;
            }
            if (this.isSerializedIndexDirty && this.serializedIndexChannel != null) {
                this.xPathByteCodeIndex.flip();
                this.serializedCacheChannel.write(this.xPathByteCodeIndex);
                this.isSerializedIndexDirty = false;
            }
        }
    }

    public void loadCompiledExpressions(File file) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, CodeGenerationError, CompilerNotAvailableException {
        if (this.useSerializedByteCodeCache) {
            this.initByteCodeIndexAndCache(file);
        } else if (file.length() != 0L) {
            ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(file));
            HashMap expressionsToClassBytes = (HashMap)inputStream.readObject();
            inputStream.close();
            Iterator iter = expressionsToClassBytes.keySet().iterator();
            while (iter.hasNext()) {
                String xpath = (String)iter.next();
                CompiledExpressionEvaluator evaluator = this.createCompiledExpressionEvaluator(expressionsToClassBytes, xpath);
                this.compiledXpathExpressions.put(xpath, evaluator);
            }
        }
    }

    protected synchronized void initByteCodeIndexAndCache(File file) throws IOException, FileNotFoundException, ClassNotFoundException {
        if (file == null) {
            file = this.createTempFile("xPathCache");
        }
        String jvmVersion = this.getJVMVersion();
        int idx = file.getName().lastIndexOf("_" + jvmVersion + ".");
        if (idx == -1) {
            idx = file.getName().lastIndexOf(".");
        }
        StringBuffer serializedCachePath = new StringBuffer();
        if (file.isDirectory()) {
            serializedCachePath.append(file.getAbsolutePath());
            if (!file.getAbsolutePath().endsWith(File.separator)) {
                serializedCachePath.append(File.separator);
            }
            serializedCachePath.append("xPathCache");
        } else {
            serializedCachePath.append(file.getParent());
            serializedCachePath.append(File.separator);
            if (idx > 0) {
                serializedCachePath.append(file.getName().substring(0, idx));
            } else {
                serializedCachePath.append(file.getName());
            }
        }
        StringBuffer serializedIndexPath = new StringBuffer();
        serializedIndexPath.append(serializedCachePath);
        serializedCachePath.append("_");
        serializedCachePath.append("byteCode");
        serializedCachePath.append("_");
        serializedCachePath.append(jvmVersion);
        serializedCachePath.append(".dat");
        serializedIndexPath.append("_");
        serializedIndexPath.append("entries");
        serializedIndexPath.append("_");
        serializedIndexPath.append(jvmVersion);
        serializedIndexPath.append(".idx");
        File serializedCache = new File(serializedCachePath.toString());
        if (!serializedCache.exists()) {
            serializedCache.createNewFile();
        }
        this.serializedCacheChannel = new RandomAccessFile(serializedCache, "rw").getChannel();
        this.xPathByteCodeCache = ByteBuffer.allocate(65536);
        this.currentSerializedCacheOffset = serializedCache.length();
        this.serializedCacheChannel.position(this.currentSerializedCacheOffset);
        File serializedIndex = new File(serializedIndexPath.toString());
        if (!serializedIndex.exists()) {
            serializedIndex.createNewFile();
        }
        this.serializedIndexChannel = new RandomAccessFile(serializedIndex, "rw").getChannel();
        this.xPathByteCodeIndex = ByteBuffer.allocate(65536);
        this.xPathByteCodeIndexMap = new HashMap();
        if (serializedIndex.length() > 0L) {
            do {
                try {
                    this.xPathByteCodeIndex.clear();
                    this.xPathByteCodeIndex.limit(4);
                    this.serializedIndexChannel.read(this.xPathByteCodeIndex);
                    this.xPathByteCodeIndex.flip();
                    int expressionLength = this.xPathByteCodeIndex.getInt();
                    int exprInfoLength = expressionLength + 8 + 4;
                    if (this.xPathByteCodeIndex.capacity() < exprInfoLength) {
                        this.xPathByteCodeIndex = ByteBuffer.allocate(exprInfoLength);
                    }
                    this.xPathByteCodeIndex.clear();
                    this.xPathByteCodeIndex.limit(exprInfoLength);
                    this.serializedIndexChannel.read(this.xPathByteCodeIndex);
                    this.xPathByteCodeIndex.flip();
                    byte[] b = new byte[expressionLength];
                    this.xPathByteCodeIndex.get(b, 0, b.length);
                    String expression = new String(b, "UTF-8");
                    ByteCodeInfo byteCodeInfo = new ByteCodeInfo();
                    byteCodeInfo.setOffset(this.xPathByteCodeIndex.getLong());
                    byteCodeInfo.setLenght(this.xPathByteCodeIndex.getInt());
                    this.xPathByteCodeIndexMap.put(expression, byteCodeInfo);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            } while (this.serializedIndexChannel.position() < serializedIndex.length());
        }
        this.currentSerializedIndexOffset = serializedIndex.length();
        this.serializedIndexChannel.position(this.currentSerializedIndexOffset);
    }

    protected String getJVMVersion() {
        return "JVM_Version_" + System.getProperty("java.specification.version").replace('.', '_');
    }

    protected CompiledExpressionEvaluator createCompiledExpressionEvaluator(Map expressionsToClassBytes, String xpath) throws ClassNotFoundException, CodeGenerationError, CompilerNotAvailableException, InstantiationException, IllegalAccessException {
        Class evaluatorClass = this.fastXPathEngine.getClassGenerator().generateClass((byte[])expressionsToClassBytes.get(xpath));
        CompiledExpressionEvaluator evaluator = (CompiledExpressionEvaluator)evaluatorClass.newInstance();
        return evaluator;
    }

    protected CompiledExpressionEvaluator createCompiledExpressionEvaluator(byte[] byteCode, String xpath) throws ClassNotFoundException, CodeGenerationError, CompilerNotAvailableException, InstantiationException, IllegalAccessException {
        Class evaluatorClass = this.fastXPathEngine.getClassGenerator().generateClass(byteCode);
        CompiledExpressionEvaluator evaluator = (CompiledExpressionEvaluator)evaluatorClass.newInstance();
        return evaluator;
    }

    public void setUseSerializedByteCode(boolean newVal) {
        this.useSerializedByteCodeCache = newVal;
    }

    public boolean useSerializedByteCode() {
        return this.useSerializedByteCodeCache;
    }

    public void setExpressionCountThreshold(int expressionCountThreshold) {
        this.expressionCountThreshold = expressionCountThreshold;
    }

    public int getExpressionCountThreshold() {
        return this.expressionCountThreshold;
    }

    public synchronized void batchCompile(Object obj, List xpathExpressions) {
        String queryExpr;
        ArrayList<String> newExpressions = new ArrayList<String>();
        int i = 0;
        while (i < xpathExpressions.size()) {
            queryExpr = (String)xpathExpressions.get(i);
            if (this.getByteCodeIndexMap().get(queryExpr) == null) {
                newExpressions.add(queryExpr);
            }
            ++i;
        }
        if (newExpressions.size() == 0) {
            return;
        }
        xpathExpressions = newExpressions;
        this.fastXPathEngine.batchCompile(obj, xpathExpressions);
        i = 0;
        while (i < xpathExpressions.size()) {
            queryExpr = (String)xpathExpressions.get(i);
            if (this.getByteCodeIndexMap().get(queryExpr) == null) {
                byte[] byteCode = (byte[])this.fastXPathEngine.getClassesAsByteArrays().get(queryExpr);
                try {
                    this.updateCacheAndIndex(queryExpr, byteCode);
                    this.fastXPathEngine.getClassesAsByteArrays().remove(queryExpr);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    protected Map getByteCodeIndexMap() {
        if (this.xPathByteCodeIndexMap == null) {
            try {
                this.initByteCodeIndexAndCache(null);
            }
            catch (Exception e) {
                throw new ExpressionEvaluationException(e);
            }
        }
        return this.xPathByteCodeIndexMap;
    }

    protected File createTempFile(String fileName) {
        String tempFileString = String.valueOf(System.getProperty("java.io.tmpdir")) + "fastxpath-temp" + File.separator + fileName;
        File tempFile = new File(tempFileString);
        if (!tempFile.exists()) {
            if (tempFile.isDirectory()) {
                tempFile.mkdirs();
            } else {
                tempFile.getParentFile().mkdirs();
            }
        }
        return tempFile;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.serializedCacheChannel != null) {
            this.serializedCacheChannel.force(true);
        }
        if (this.serializedIndexChannel != null) {
            this.serializedIndexChannel.force(true);
        }
    }

    public static synchronized FastXPathAPI getGlobalInstance() throws Exception {
        if (globalXPathEngine == null) {
            globalXPathEngine = new FastXPathAPI(null);
        }
        return globalXPathEngine;
    }
}

