/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes.EPredicatedNodeTest;

public class CompilerContext
implements ICompilerContext {
    protected StringBuffer sb = new StringBuffer(" ");
    protected ArrayList nameStack = new ArrayList();
    protected ArrayList returnValueNameStack = new ArrayList();
    protected HashMap objNameMap = new HashMap();
    protected FastXPathContext runtimeContext;
    protected int maxStackSize = 0;
    protected int stackSize = 0;
    protected int lastStackSize = 0;
    protected int lastPredicateMarker = 0;
    protected ArrayList expressionStack = new ArrayList();
    protected IFastXPathEngine fastXPathEngine;
    protected int predicateDepth = 0;

    public CompilerContext(Object object, FastXPathContext context, IFastXPathEngine engine) {
        this.runtimeContext = context;
        this.runtimeContext.getBindingMetaData().getClassMapping(object);
        this.fastXPathEngine = engine;
    }

    public IExpression getPreviousExpresion() {
        if (this.expressionStack.size() > 0) {
            return (IExpression)this.expressionStack.get(0);
        }
        return null;
    }

    public StringBuffer getSb() {
        if (this.sb.indexOf("$*$*$*$* ") == -1) {
            this.sb.insert(this.lastPredicateMarker, "$*$*$*$* ");
        }
        if (this.sb.indexOf("$*$*$*$* ") + "$*$*$*$* ".length() == this.sb.length() && !this.nameStackToBuffer(this.sb, this.returnValueNameStack)) {
            this.sb.append(" obj");
        }
        return this.sb;
    }

    public void enterPredicate() {
        if (this.predicateDepth++ == 0) {
            this.returnValueNameStack = new ArrayList();
            this.returnValueNameStack.addAll(this.nameStack);
        }
    }

    public void exitPredicate() {
        --this.predicateDepth;
        this.lastPredicateMarker = this.sb.length();
    }

    public String getReturnExpression() {
        return this.sb.substring(this.lastPredicateMarker);
    }

    public void in(IExpression currentExpression) {
        this.expressionStack.add(0, currentExpression);
        if (!(currentExpression instanceof EPredicatedNodeTest)) {
            return;
        }
        if (++this.stackSize > this.maxStackSize) {
            this.maxStackSize = this.stackSize;
        }
        if (this.stackSize < this.lastStackSize) {
            this.maxStackSize = this.stackSize;
        }
        this.lastStackSize = this.stackSize;
    }

    public void out() {
        IExpression removed;
        if (this.expressionStack.size() > 0 && !((removed = (IExpression)this.expressionStack.remove(0)) instanceof EPredicatedNodeTest)) {
            return;
        }
        if (this.stackSize-- == this.maxStackSize) {
            this.nameStackToBuffer(this.sb, this.nameStack);
        }
        if (this.nameStack.size() > 1) {
            String s = (String)this.nameStack.get(this.nameStack.size() - 1);
            try {
                Double.parseDouble(s);
                this.nameStack.remove(this.nameStack.size() - 1);
            }
            catch (NumberFormatException numberFormatException) {}
            this.nameStack.remove(this.nameStack.size() - 1);
        }
    }

    protected boolean nameStackToBuffer(StringBuffer buffer, ArrayList stack) {
        if (stack.size() <= 1) {
            return false;
        }
        int i = 1;
        while (i < stack.size()) {
            String s = (String)stack.get(i);
            if (s.equals("FUNC_LAST_OBSERVED")) {
                buffer.append(".get( ");
                int j = 1;
                while (j < i) {
                    this.appendGetter2((String)stack.get(j));
                    ++j;
                }
                buffer.append(".size() -1)");
                stack.remove(i--);
            } else {
                try {
                    double d = Double.parseDouble(s);
                    int index = (int)d;
                    buffer.append(".get(" + index + ")");
                }
                catch (NumberFormatException numberFormatException) {
                    this.appendGetter2(s, i);
                }
            }
            ++i;
        }
        return true;
    }

    public void appendGetter2(String name) {
        if (name.equals("")) {
            return;
        }
        String first = name.substring(0, 1).toUpperCase();
        this.sb.append(" .get" + first + name.substring(1, name.length()) + "()");
    }

    public void appendGetter2(String name, int index) {
        if (name.equals("")) {
            return;
        }
        String first = name.substring(0, 1).toUpperCase();
        if (index > 1) {
            this.sb.append(".get" + first + name.substring(1, name.length()) + "()");
        } else {
            this.sb.append(" .get" + first + name.substring(1, name.length()) + "()");
        }
    }

    public void addName(String name) {
        this.nameStack.add(name);
    }

    public void append(String string) {
        if (string.equals(" ) ") && this.sb.indexOf(" ( ") == this.sb.length() - 3) {
            int i = this.sb.length();
            this.sb.delete(i - 3, i - 1);
        } else {
            this.sb.append(string);
        }
    }

    public IFastXPathEngine getFastXPathEngine() {
        return this.fastXPathEngine;
    }

    public FastXPathContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public ICompilerContext setRuntimeContext(FastXPathContext runtimeContext, Object object) {
        this.runtimeContext = runtimeContext;
        runtimeContext.getBindingMetaData().getClassMapping(object);
        return this;
    }

    public int getPredicateDepth() {
        return this.predicateDepth;
    }
}

