/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.mgmt.serializer;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.muse.core.serializer.Serializer;
import org.apache.muse.core.serializer.SerializerRegistry;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.eclipse.cosmos.dc.common.api.IDataCollectionContext;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataQueryService;
import org.eclipse.cosmos.dc.common.spi.InboundContext;
import org.eclipse.cosmos.dc.common.spi.RuntimeHost;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDMBinding;
import org.eclipse.cosmos.dc.mgmt.provisional.wsdm.impl.WSDMBindingFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SPISerializer
implements Serializer {
    ContributionManager manager;
    private static SPISerializer runtimeHostSerializer = new SPISerializer(RuntimeHost.class);
    private static SPISerializer contextSerializer = new SPISerializer(IDataCollectionContext.class);
    private static SPISerializer queryRootSerializer = new SPISerializer(IDataQueryService.class);
    private static SPISerializer queryResultSerializer = new SPISerializer(IDataQueryResult.class);
    private static final int RUNTIME_TYPE = 0;
    private static final int CONTEXT_TYPE = 1;
    private static final int QUERY_TYPE = 2;
    private static final int QUERY_RESULT_TYPE = 3;
    private static final int SOURCE_TYPE = 4;
    private static final int INVALID_TYPE = -1;
    private Class type;
    private int switchType = -1;

    public static SPISerializer getRuntimeHostSerializer() {
        return runtimeHostSerializer;
    }

    public static SPISerializer getContextSerializer() {
        return contextSerializer;
    }

    public static SPISerializer getQueryRootSerializer() {
        return queryRootSerializer;
    }

    public static SPISerializer getQueryResultSerializer() {
        return queryResultSerializer;
    }

    private SPISerializer(Class type) {
        this.type = type;
        if (RuntimeHost.class.isAssignableFrom(type)) {
            this.switchType = 0;
        } else if (IDataCollectionContext.class.isAssignableFrom(type)) {
            this.switchType = 1;
        } else if (IDataQueryService.class.isAssignableFrom(type)) {
            this.switchType = 2;
        } else if (IDataQueryResult.class.isAssignableFrom(type)) {
            this.switchType = 3;
        }
    }

    public Object fromXML(Element xml) throws SoapFault {
        try {
            String name = xml.getLocalName();
            if (RuntimeHost.RUNTIMEHOST_QNAME.getLocalPart().equals(name)) {
                return this.runtimeHostFromXML(xml);
            }
            throw new SoapFault("Invalid object type");
        }
        catch (Throwable t) {
            throw new SoapFault("Unable to deserialize ", t);
        }
    }

    private Object runtimeHostFromXML(Element xml) {
        XmlUtils.getAllElements((Node)xml, (String)"http://www.eclipse.org/xmlns/cosmos/1.0/RuntimeHost", (String)RuntimeHost.RUNTIMEHOST_QNAME.getLocalPart());
        return null;
    }

    public Class getSerializableType() {
        return this.type;
    }

    public Element toXML(Object obj, QName qname) throws SoapFault {
        Element child;
        block7: {
            block6: {
                child = null;
                if (obj == null || !this.type.isInstance(obj)) break block6;
                switch (this.switchType) {
                    case 0: {
                        child = this.toXML((RuntimeHost)obj);
                        break block7;
                    }
                    case 1: {
                        child = this.toXML((IDataCollectionContext)obj);
                        break block7;
                    }
                    case 2: {
                        child = this.toXML((IDataQueryService)obj);
                        break block7;
                    }
                    case 3: {
                        child = this.toXML((IDataQueryResult)obj);
                        break block7;
                    }
                    default: {
                        throw new SoapFault("Invalid object type:" + obj.getClass().getName());
                    }
                }
            }
            throw new SoapFault("Invalid object type:" + obj.getClass().getName());
        }
        return child;
    }

    private Element toXML(RuntimeHost host) {
        WSDMBinding binding = (WSDMBinding)((Object)WSDMBindingFactory.getDefault().getBindingForObject(host));
        Element dsElement = XmlUtils.createElement((QName)RuntimeHost.RUNTIMEHOST_QNAME);
        if (binding != null) {
            EndpointReference epr = binding.getEndpointReference();
            dsElement.appendChild(epr.toXML());
        }
        return dsElement;
    }

    private Element toXML(IDataQueryService queryRoot) {
        WSDMBinding binding = (WSDMBinding)((Object)WSDMBindingFactory.getDefault().getBindingForObject(queryRoot));
        Element dsElement = XmlUtils.createElement((QName)IDataQueryService.QUERY_QNAME);
        if (binding != null) {
            EndpointReference epr = binding.getEndpointReference();
            dsElement.appendChild(epr.toXML());
        }
        return dsElement;
    }

    private Element toXML(IDataQueryResult result) throws SoapFault {
        Element dsElement = XmlUtils.createElement((QName)IDataQueryResult.QUERY_RESULT_QNAME);
        result.getResponseType();
        result.getRawResponse();
        Collection resultCollection = result.getRawResponseCollection();
        Class<?> ret = null;
        Serializer ser = null;
        if (resultCollection != null && !resultCollection.isEmpty()) {
            Object retObj = resultCollection.iterator().next();
            ret = retObj.getClass();
            ser = SerializerRegistry.getInstance().getSerializer(ret);
            if (ser == null) {
                throw new SoapFault("No serializer found for class " + ret);
            }
            Element retElement = XmlUtils.createElement((QName)IDataQueryResult.QUERY_RESULT_COLLECTION_QNAME);
            for (Object obj : resultCollection) {
                Element next = ser.toXML(obj, IDataQueryResult.QUERY_RESULT_COLLECTION_QNAME);
                retElement.appendChild(next);
            }
            System.out.println("Returning " + XmlUtils.toString((Node)retElement));
            dsElement.appendChild(retElement);
            return dsElement;
        }
        return dsElement;
    }

    private Element toXML(IDataCollectionContext context) {
        WSDMBinding binding = (WSDMBinding)((Object)WSDMBindingFactory.getDefault().getBindingForObject(context));
        Element dsElement = XmlUtils.createElement((QName)IDataCollectionContext.CONTEXT_QNAME);
        dsElement.setAttribute("name", context.getName());
        if (context instanceof InboundContext) {
            dsElement.setAttribute("direction", "in");
        } else {
            dsElement.setAttribute("direction", "out");
        }
        if (binding != null) {
            EndpointReference epr = binding.getEndpointReference();
            dsElement.appendChild(epr.toXML());
        }
        return dsElement;
    }
}

