/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter;

import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.IStatus;
import org.eclipse.hyades.logging.adapter.impl.Status;
import org.eclipse.hyades.logging.adapter.internal.util.Controller;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class Adapter {
    private Controller rootController = null;
    private String contextFile = null;
    private String componentFile = null;
    private IOutputter logOutputter = null;
    private short loggingLevel = (short)-1;
    private Status status = new Status();

    public void setContextConfigPath(String configFilePath) {
        this.contextFile = configFilePath;
    }

    public void setComponentConfigPath(String configFilePath) {
        this.componentFile = configFilePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggingLevel(short newLevel) {
        Adapter adapter = this;
        synchronized (adapter) {
            this.loggingLevel = newLevel;
            if (this.rootController != null && newLevel > -1) {
                this.rootController.setLoggingLevel(newLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getLoggingLevel() {
        Adapter adapter = this;
        synchronized (adapter) {
            return this.loggingLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws AdapterException {
        Adapter adapter = this;
        synchronized (adapter) {
            if (this.rootController != null && this.rootController.getComponentConfigPath().equals(this.componentFile) && this.rootController.getContextConfigPath().equals(this.contextFile)) {
                this.rootController.setLogOutputter(this.logOutputter);
                this.rootController.prepareConfiguration(true);
            } else {
                this.rootController = new Controller();
                if (this.componentFile == null) {
                    this.componentFile = "SimpleComponentConfigurations.xml";
                }
                if (this.contextFile == null) {
                    this.contextFile = "SimpleContextConfiguration.xml";
                }
                this.rootController.setContextConfigPath(this.contextFile);
                this.rootController.setComponentConfigPath(this.componentFile);
                this.rootController.setLogOutputter(this.logOutputter);
                try {
                    this.rootController.prepareAdapter(true);
                }
                catch (Exception e) {
                    this.rootController.stop();
                    if (e instanceof AdapterException) {
                        throw (AdapterException)e;
                    }
                    throw new AdapterException(e);
                }
            }
            this.rootController.stop();
        }
    }

    public void start(boolean separateThread, boolean daemon) throws AdapterException {
        this.status.setActive(true);
        if (this.rootController != null && this.rootController.getComponentConfigPath().equals(this.componentFile) && this.rootController.getContextConfigPath().equals(this.contextFile)) {
            this.rootController.setLogOutputter(this.logOutputter);
            if (this.loggingLevel > -1) {
                this.rootController.setLoggingLevel(this.loggingLevel);
            }
            this.rootController.prepareConfiguration(false);
        } else {
            this.rootController = new Controller();
            if (this.componentFile == null) {
                this.componentFile = "SimpleComponentConfigurations.xml";
            }
            if (this.contextFile == null) {
                this.contextFile = "SimpleContextConfiguration.xml";
            }
            this.rootController.setContextConfigPath(this.contextFile);
            this.rootController.setComponentConfigPath(this.componentFile);
            this.rootController.setLogOutputter(this.logOutputter);
            if (this.loggingLevel > -1) {
                this.rootController.setLoggingLevel(this.loggingLevel);
            }
            this.rootController.prepareAdapter(false);
        }
        if (!separateThread) {
            this.rootController.run();
            this.status.setActive(false);
        } else {
            Thread serverThread = new Thread(this.rootController);
            serverThread.setDaemon(daemon);
            serverThread.start();
        }
    }

    public void stop() {
        if (this.rootController != null) {
            this.rootController.stop();
        }
        this.status.setActive(false);
    }

    public void hardStop() {
        if (this.rootController != null) {
            this.rootController.hardStop();
        }
        this.status.setActive(false);
    }

    public static void main(String[] args) {
        Adapter adapter = new Adapter();
        if (adapter.parseCommandLine(args)) {
            try {
                adapter.start(false, false);
            }
            catch (AdapterException e) {
                System.err.println(Messages.getString("HyadesGAAdapterFatal_ERROR_"));
                System.err.println(e.getMessage());
            }
        } else {
            System.out.println(Messages.getString("HyadesGACommand_line_usage"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseCommandLine(String[] args) {
        if (args == null || args.length <= 0) return true;
        String ccArgName = "-cc";
        String acArgName = "-ac";
        int i = 0;
        while (i < args.length) {
            if (ccArgName.equalsIgnoreCase(args[i])) {
                if (++i >= args.length || args[i] == null) return false;
                this.setContextConfigPath(args[i]);
            } else {
                if (!acArgName.equalsIgnoreCase(args[i])) return false;
                if (++i >= args.length || args[i] == null) return false;
                this.setComponentConfigPath(args[i]);
            }
            ++i;
        }
        return true;
    }

    public IStatus getStatus() {
        if (this.rootController != null) {
            this.status.setChildrenStatus(this.rootController.getStatus());
        } else {
            this.status.setActive(false);
        }
        return this.status;
    }

    public void setLogOutputter(IOutputter outputter) {
        this.logOutputter = outputter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContext[] getConfiguration() throws AdapterException {
        Adapter adapter = this;
        synchronized (adapter) {
            if (this.rootController != null) {
                if (!this.rootController.isRunning()) {
                    return this.rootController.getContexts();
                }
            } else {
                block12: {
                    this.rootController = new Controller();
                    if (this.componentFile == null) {
                        this.componentFile = "SimpleComponentConfigurations.xml";
                    }
                    if (this.contextFile == null) {
                        this.contextFile = "SimpleContextConfiguration.xml";
                    }
                    this.rootController.setContextConfigPath(this.contextFile);
                    this.rootController.setComponentConfigPath(this.componentFile);
                    this.rootController.setLogOutputter(this.logOutputter);
                    try {
                        this.rootController.prepareAdapter(true);
                    }
                    catch (Exception e) {
                        if (e instanceof PreparationException) {
                            throw (PreparationException)e;
                        }
                        if (e instanceof AdapterInvalidConfig) break block12;
                        if (e instanceof AdapterException) {
                            this.rootController.stop();
                            throw (AdapterException)e;
                        }
                        this.rootController.stop();
                        throw new AdapterException(e);
                    }
                }
                this.rootController.stop();
                return this.rootController.getContexts();
            }
            return null;
        }
    }
}

