/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.extractors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.MessageString;
import org.eclipse.hyades.logging.adapter.extractors.SimpleExtractor;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class RegularExpressionExtractor
extends SimpleExtractor {
    private Pattern compiledStartPattern = null;
    private Pattern compiledEndPattern = null;
    private boolean lineStartPattern = false;
    private boolean lineEndPattern = false;

    public void update() throws AdapterInvalidConfig {
        super.update();
        if ((this.getStartPattern() == null || this.getStartPattern().equals("")) && (this.getEndPattern() == null || this.getEndPattern().equals(""))) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_End_Pattern_Invalid_ERROR_", this.getStartPattern()));
        }
        if (this.getStartPattern() != null && !this.getStartPattern().equals("")) {
            try {
                this.compiledStartPattern = Pattern.compile(this.getStartPattern(), 8);
            }
            catch (PatternSyntaxException e) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_Start_Pattern_Invalid_ERROR_", e.getMessage()));
            }
            if (this.getStartPattern().equals("^")) {
                this.lineStartPattern = true;
            }
        }
        if (this.lineStartPattern && (this.getEndPattern() == null || this.getEndPattern().equals(""))) {
            this.setEndPattern("$");
        }
        if (this.getEndPattern() != null && !this.getEndPattern().equals("")) {
            try {
                this.compiledEndPattern = Pattern.compile(this.getEndPattern(), 8);
            }
            catch (PatternSyntaxException e) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGA_CBE_Regular_Expression_Extractor_End_Pattern_Invalid_ERROR_", e.getMessage()));
            }
            if (this.getEndPattern().equals("$")) {
                this.lineEndPattern = true;
            }
        }
    }

    protected void search(SimpleExtractor.StringPosition position, String pattern, String searchString, int startOffset) {
        String input;
        Matcher matcher;
        boolean found = false;
        Pattern expression = null;
        if (pattern == this.getStartPattern()) {
            expression = this.compiledStartPattern;
            if (this.lineStartPattern && startOffset == 0 && searchString.indexOf(this.localLineSeparator) == 0) {
                startOffset = this.localLineSeparator.length();
            }
        } else {
            expression = this.compiledEndPattern;
        }
        if (found = (matcher = expression.matcher(input = searchString.substring(startOffset))).find()) {
            if (matcher.start() == matcher.end()) {
                int matchOffset = startOffset + matcher.start();
                if (matcher.start() != 0 && matcher.start() != input.length() - 1) {
                    --matchOffset;
                }
                position.setStartPosition(matchOffset);
                position.setEndPosition(matchOffset);
            } else {
                position.setStartPosition(startOffset + matcher.start());
                position.setEndPosition(startOffset + matcher.end() - 1);
            }
            position.setValid(true);
        }
    }

    protected MessageString adjustMessage(String searchString, SimpleExtractor.StringPosition startPosition, SimpleExtractor.StringPosition endPosition) {
        int endOffset = searchString.length() - 1;
        int adjustedStart = this.getIncludeStartPattern() || this.lineStartPattern ? startPosition.getStartPosition() : startPosition.getEndPosition() + 1;
        int adjustedEnd = this.getIncludeEndPattern() || this.lineEndPattern ? (endPosition.getStartPosition() > endOffset ? endOffset + 1 : endPosition.getEndPosition() + 1) : (endPosition.getStartPosition() == endOffset ? endPosition.getStartPosition() + 1 : endPosition.getStartPosition());
        MessageString result = new MessageString();
        result.setValue(searchString.substring(adjustedStart, adjustedEnd));
        return result;
    }
}

