/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.parsers.internal.importer;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.importer.ILogParser;

public class LocalLogImportLoader
implements Log {
    protected Hashtable parserParameters = null;
    protected ILogParser parser = null;
    protected XMLLoader xmlLoader = null;
    protected Log logParser = null;
    protected boolean traceXML = false;
    public static final int TRACE_LEVEL = 0;
    public static final int DEBUG_LEVEL = 1;
    public static final int INFO_LEVEL = 2;
    public static final int WARN_LEVEL = 3;
    public static final int ERROR_LEVEL = 4;
    public static final int FATAL_LEVEL = 5;
    protected int loggingLevel;

    public LocalLogImportLoader() {
        this.parser = null;
        this.parserParameters = null;
    }

    public LocalLogImportLoader(ILogParser parser, Hashtable parserParameters, boolean traceXML) {
        this.parser = parser;
        this.parserParameters = parserParameters;
        this.traceXML = traceXML;
    }

    public void setXMLLoader(XMLLoader xmlLoader) {
        this.parserParameters.put("xmlLoader", xmlLoader);
        this.xmlLoader = xmlLoader;
    }

    public void startParsing() throws LogParserException {
        this.parser.setUserInput(this.parserParameters);
        this.parser.parse(this);
    }

    public void setParserLogger(Log logParser) {
        this.logParser = logParser;
        this.parser.setParserLogger(logParser);
    }

    public Log getParserLogger() {
        return this.logParser;
    }

    public XMLLoader getXMLLoader() {
        return this.xmlLoader;
    }

    public boolean isTraceEnabled() {
        return this.loggingLevel <= 0;
    }

    public boolean isDebugEnabled() {
        return this.loggingLevel <= 1;
    }

    public boolean isInfoEnabled() {
        return this.loggingLevel <= 2;
    }

    public boolean isWarnEnabled() {
        return this.loggingLevel <= 3;
    }

    public boolean isErrorEnabled() {
        return this.loggingLevel <= 4;
    }

    public boolean isFatalEnabled() {
        return this.loggingLevel <= 5;
    }

    public void trace(Object record) {
    }

    public void trace(Object record, Throwable throwable) {
    }

    public void debug(Object record) {
    }

    public void debug(Object record, Throwable throwable) {
    }

    public void info(Object record) {
    }

    public void info(Object record, Throwable throwable) {
    }

    public void warn(Object record) {
    }

    public void warn(Object record, Throwable throwable) {
    }

    public void error(Object record) {
    }

    public void error(Object record, Throwable throwable) {
    }

    public void fatal(Object record) {
    }

    public void fatal(Object record, Throwable throwable) {
    }
}

