/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.CacheMapManager;
import org.eclipse.birt.data.engine.executor.DataSetCacheUtil;
import org.eclipse.birt.data.engine.executor.DataSourceAndDataSet;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class DataSetCacheManager {
    private int cacheOption = 1;
    private int alwaysCacheRowCount = 0;
    private IBaseDataSourceDesign dataSourceDesign = null;
    private IBaseDataSetDesign dataSetDesign = null;
    private Collection parameterHints;
    private Map appContext;
    private CacheMapManager cacheMapManager;
    private int mode;

    public DataSetCacheManager(String tempDir, DataEngine dataEngine) {
        this.cacheMapManager = new CacheMapManager(tempDir);
        this.mode = 2;
    }

    public IBaseDataSourceDesign getCurrentDataSourceDesign() {
        return this.dataSourceDesign;
    }

    public IBaseDataSetDesign getCurrentDataSetDesign() {
        return this.dataSetDesign;
    }

    public Collection getCurrentParameterHints() {
        if (this.parameterHints != null) {
            return this.parameterHints;
        }
        return new ArrayList();
    }

    public Map getCurrentAppContext() {
        return this.appContext;
    }

    public void setCacheOption(int cacheOption) {
        this.cacheOption = cacheOption;
    }

    public int getCacheOption() {
        return this.cacheOption;
    }

    public void setCacheMode(int mode) {
        this.mode = mode;
    }

    public int suspendCache() {
        int lastCacheOption = this.cacheOption;
        this.setCacheOption(2);
        this.setCacheMode(2);
        return lastCacheOption;
    }

    public void setAlwaysCacheRowCount(int rowCount) {
        this.alwaysCacheRowCount = rowCount;
    }

    public void setDataSourceAndDataSet(IBaseDataSourceDesign dataSourceDesign, IBaseDataSetDesign dataSetDesign, Collection parameterHints, Map appContext) {
        this.dataSourceDesign = dataSourceDesign;
        this.dataSetDesign = dataSetDesign;
        this.parameterHints = parameterHints;
        this.appContext = appContext;
    }

    public boolean doesSaveToCache() {
        if (!this.needsToCache(this.dataSetDesign, this.cacheOption, this.alwaysCacheRowCount)) {
            return false;
        }
        return this.cacheMapManager.doesSaveToCache(DataSourceAndDataSet.newInstance(this.dataSourceDesign, this.dataSetDesign, this.parameterHints), this.mode, this.dataSourceDesign, this.dataSetDesign, this.parameterHints, this.appContext);
    }

    public boolean doesLikeToCache() {
        return this.needsToCache(this.dataSetDesign, this.cacheOption, this.alwaysCacheRowCount);
    }

    public boolean doesLoadFromCache(IBaseDataSourceDesign dataSourceDesign, IBaseDataSetDesign dataSetDesign, Collection parameterHints, Map appContext, int cacheOption, int alwaysCacheRowCount) {
        if (!this.needsToCache(dataSetDesign, cacheOption, alwaysCacheRowCount)) {
            return false;
        }
        this.setDataSourceAndDataSet(dataSourceDesign, dataSetDesign, parameterHints, appContext);
        return this.cacheMapManager.doesLoadFromCache(DataSourceAndDataSet.newInstance(this.dataSourceDesign, dataSetDesign, parameterHints));
    }

    public boolean needsToCache(IBaseDataSetDesign dataSetDesign, int cacheOption, int alwaysCacheRowCount) {
        return DataSetCacheUtil.needsToCache(dataSetDesign, cacheOption, alwaysCacheRowCount);
    }

    public int getCacheRowCount() {
        return DataSetCacheUtil.getCacheRowCount(this.cacheOption, this.alwaysCacheRowCount, this.dataSetDesign == null ? 0 : this.dataSetDesign.getCacheRowCount());
    }

    public void clearCache(IBaseDataSourceDesign dataSourceDesign2, IBaseDataSetDesign dataSetDesign2) {
        if (dataSourceDesign2 == null || dataSetDesign2 == null) {
            return;
        }
        DataSourceAndDataSet ds = DataSourceAndDataSet.newInstance(dataSourceDesign2, dataSetDesign2, null);
        this.cacheMapManager.clearCache(ds);
    }

    public IDataSetCacheObject getCacheObject() {
        return this.cacheMapManager.getCacheObject(DataSourceAndDataSet.newInstance(this.dataSourceDesign, this.dataSetDesign, this.parameterHints));
    }

    public boolean doesLoadFromCache() {
        if (!this.needsToCache(this.dataSetDesign, this.cacheOption, this.alwaysCacheRowCount)) {
            return false;
        }
        return this.cacheMapManager.doesLoadFromCache(DataSourceAndDataSet.newInstance(this.dataSourceDesign, this.dataSetDesign, this.parameterHints));
    }

    public void resetForTest() {
        this.dataSourceDesign = null;
        this.dataSetDesign = null;
        this.cacheOption = 1;
        this.alwaysCacheRowCount = 0;
        this.cacheMapManager.resetForTest();
    }

    public IResultMetaData getCachedResultMetadata(IBaseDataSourceDesign dataSource, IBaseDataSetDesign dataSet) throws DataException {
        IResultClass resultClass = this.cacheMapManager.getCachedResultClass(DataSourceAndDataSet.newInstance(dataSource, dataSet, null));
        if (resultClass != null) {
            return new ResultMetaData(resultClass);
        }
        return null;
    }
}

