/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.aggregation.BuiltInAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationFunctionDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.Row4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class AggregationCalculator {
    AggregationDefinition aggregation;
    private Accumulator[] accumulators;
    private int levelCount;
    private int[] measureIndex;
    private IDiskArray result = null;
    private IAggregationResultRow currentResultObj = null;
    private int[] parameterColIndex;
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationCalculator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    AggregationCalculator(AggregationDefinition aggregationDef, DimColumn[] paramterColNames, IFactTableRowIterator facttableRowIterator) throws DataException {
        Object[] params = new Object[]{aggregationDef, facttableRowIterator};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationCalculator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.entering(clazz.getName(), "AggregationCalculator", params);
        this.aggregation = aggregationDef;
        AggregationFunctionDefinition[] aggregationFunction = aggregationDef.getAggregationFunctions();
        this.levelCount = aggregationDef.getLevels() == null ? 0 : aggregationDef.getLevels().length;
        if (aggregationFunction != null) {
            this.accumulators = new Accumulator[aggregationFunction.length];
            this.measureIndex = new int[aggregationFunction.length];
            this.parameterColIndex = new int[aggregationFunction.length];
            int i = 0;
            while (i < aggregationFunction.length) {
                IAggregation aggregation = BuiltInAggregationFactory.getInstance().getAggregation(aggregationFunction[i].getFunctionName());
                this.parameterColIndex[i] = aggregation.getParameterDefn() != null && aggregation.getParameterDefn().length > 1 ? AggregationCalculator.find(paramterColNames, aggregationFunction[i].getParaCol()) : -1;
                this.accumulators[i] = aggregation.newAccumulator();
                this.accumulators[i].start();
                this.measureIndex[i] = facttableRowIterator.getMeasureIndex(aggregationFunction[i].getMeasureName());
                if (this.measureIndex[i] == -1) {
                    throw new DataException("data.olap.measureNameNotFound", aggregationFunction[i].getMeasureName());
                }
                ++i;
            }
        }
        this.result = new BufferedStructureArray(AggregationResultRow.getCreator(), 4000);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationCalculator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger.exiting(clazz2.getName(), "AggregationCalculator");
    }

    private static int find(DimColumn[] colArray, DimColumn col) {
        if (colArray == null || col == null) {
            return -1;
        }
        int i = 0;
        while (i < colArray.length) {
            if (col.equals(colArray[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    void onRow(Row4Aggregation row) throws IOException, DataException {
        if (this.currentResultObj == null) {
            this.newAggregationResultRow(row);
        } else if (this.currentResultObj.getLevelMembers() == null || AggregationCalculator.compare(row.getLevelMembers(), this.currentResultObj.getLevelMembers()) == 0) {
            if (this.accumulators != null) {
                int i = 0;
                while (i < this.accumulators.length) {
                    this.accumulators[i].onRow(this.getAccumulatorParameter(row, i));
                    ++i;
                }
            }
        } else {
            if (this.accumulators != null) {
                this.currentResultObj.setAggregationValues(new Object[this.accumulators.length]);
                int i = 0;
                while (i < this.accumulators.length) {
                    this.accumulators[i].finish();
                    this.currentResultObj.getAggregationValues()[i] = this.accumulators[i].getValue();
                    this.accumulators[i].start();
                    ++i;
                }
            }
            this.result.add(this.currentResultObj);
            this.newAggregationResultRow(row);
        }
    }

    IDiskArray getResult() throws IOException, DataException {
        if (this.currentResultObj != null && this.accumulators != null) {
            this.currentResultObj.setAggregationValues(new Object[this.accumulators.length]);
            int i = 0;
            while (i < this.accumulators.length) {
                this.accumulators[i].finish();
                this.currentResultObj.getAggregationValues()[i] = this.accumulators[i].getValue();
                this.accumulators[i].start();
                ++i;
            }
        }
        if (this.currentResultObj != null) {
            this.result.add(this.currentResultObj);
        }
        return this.result;
    }

    private void newAggregationResultRow(Row4Aggregation row) throws DataException {
        this.currentResultObj = new AggregationResultRow();
        if (this.levelCount > 0) {
            this.currentResultObj.setLevelMembers(new Member[this.levelCount]);
            System.arraycopy(row.getLevelMembers(), 0, this.currentResultObj.getLevelMembers(), 0, this.currentResultObj.getLevelMembers().length);
        }
        if (this.accumulators != null) {
            int i = 0;
            while (i < this.accumulators.length) {
                this.accumulators[i].onRow(this.getAccumulatorParameter(row, i));
                ++i;
            }
        }
    }

    private Object[] getAccumulatorParameter(Row4Aggregation row, int funcIndex) {
        Object[] parameters = null;
        parameters = this.parameterColIndex[funcIndex] == -1 ? new Object[]{row.getMeasures()[this.measureIndex[funcIndex]]} : new Object[]{row.getMeasures()[this.measureIndex[funcIndex]], row.getParameterValues()[this.parameterColIndex[funcIndex]]};
        return parameters;
    }

    private static int compare(Object[] key1, Object[] key2) {
        int i = 0;
        while (i < key1.length) {
            int result = ((Comparable)key1[i]).compareTo(key2[i]);
            if (result < 0) {
                return result;
            }
            if (result > 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }
}

