/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.util.ArrayList;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.impl.EmptySelection;
import org.eclipse.birt.data.engine.olap.data.impl.MultiKeySelection;
import org.eclipse.birt.data.engine.olap.data.impl.OneKeySelection;
import org.eclipse.birt.data.engine.olap.data.impl.RangeSelection;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;

public class SelectionUtil {
    private SelectionUtil() {
    }

    public static ISelection[] intersect(ISelection[] selections1, ISelection[] selections2) {
        ISelection[] temp = new ISelection[selections1.length + selections2.length];
        int i = 0;
        int j = 0;
        while (j < selections1.length) {
            temp[i++] = selections1[j];
            ++j;
        }
        j = 0;
        while (j < selections2.length) {
            temp[i++] = selections2[j];
            ++j;
        }
        return SelectionUtil.intersect(temp);
    }

    public static ISelection[] intersect(ISelection[] selections) {
        ArrayList<ISelection> rangeSelectionList = new ArrayList<ISelection>();
        ArrayList<ISelection> multiKeySelectionList = new ArrayList<ISelection>();
        ArrayList<ISelection> oneKeySelectionList = new ArrayList<ISelection>();
        int i = 0;
        while (i < selections.length) {
            if (selections[i] instanceof EmptySelection) {
                return new ISelection[]{SelectionFactory.createEmptySelection()};
            }
            if (selections[i] instanceof RangeSelection) {
                rangeSelectionList.add(selections[i]);
            } else if (selections[i] instanceof MultiKeySelection) {
                multiKeySelectionList.add(selections[i]);
            } else if (selections[i] instanceof OneKeySelection) {
                oneKeySelectionList.add(selections[i]);
            }
            ++i;
        }
        ArrayList<ISelection> intersecttList = new ArrayList<ISelection>();
        if (!rangeSelectionList.isEmpty()) {
            RangeSelection[] rangeSelections = new RangeSelection[rangeSelectionList.size()];
            rangeSelectionList.toArray(rangeSelections);
            intersecttList.add(SelectionUtil.intersect(rangeSelections));
        }
        if (!multiKeySelectionList.isEmpty()) {
            MultiKeySelection[] multiKeySelections = new MultiKeySelection[multiKeySelectionList.size()];
            multiKeySelectionList.toArray(multiKeySelections);
            intersecttList.add(SelectionUtil.intersect(multiKeySelections));
        }
        if (!oneKeySelectionList.isEmpty()) {
            OneKeySelection[] oneKeySelections = new OneKeySelection[oneKeySelectionList.size()];
            oneKeySelectionList.toArray(oneKeySelections);
            intersecttList.add(SelectionUtil.intersect(oneKeySelections));
        }
        ISelection[] result = new ISelection[intersecttList.size()];
        intersecttList.toArray(result);
        return result;
    }

    public static ISelection intersect(RangeSelection rangeSelection, OneKeySelection oneSelection) {
        Object[] min = rangeSelection.getMin();
        Object[] max = rangeSelection.getMax();
        boolean containsMin = rangeSelection.isContainsMinKey();
        boolean containsMax = rangeSelection.isContainsMaxKey();
        Object[] key = oneSelection.getKeyValue();
        int ret = CompareUtil.compare(key, min);
        if (ret < 0 || !containsMin && ret == 0) {
            return SelectionFactory.createEmptySelection();
        }
        ret = CompareUtil.compare(key, max);
        if (ret > 0 || !containsMax && ret == 0) {
            return SelectionFactory.createEmptySelection();
        }
        return SelectionFactory.createOneKeySelection(key);
    }

    public static ISelection intersect(MultiKeySelection mutiKeySelection, OneKeySelection oneKeySelection) {
        Object[] key = oneKeySelection.getKeyValue();
        int ret = CompareUtil.compare(key, mutiKeySelection.getMin());
        if (ret < 0) {
            return SelectionFactory.createEmptySelection();
        }
        ret = CompareUtil.compare(key, mutiKeySelection.getMax());
        if (ret > 0) {
            return SelectionFactory.createEmptySelection();
        }
        if (!mutiKeySelection.isSelected(key)) {
            return SelectionFactory.createEmptySelection();
        }
        return SelectionFactory.createOneKeySelection(key);
    }

    public static ISelection intersect(RangeSelection s1, MultiKeySelection s2) {
        Object[][] keyValues = s2.getKeyValues();
        ArrayList<Object[]> keyValueList = new ArrayList<Object[]>();
        int i = 0;
        while (i < keyValues.length) {
            if (s1.isSelected(keyValues[i])) {
                keyValueList.add(keyValues[i]);
            }
            ++i;
        }
        if (keyValueList.isEmpty()) {
            return SelectionFactory.createEmptySelection();
        }
        keyValues = new Object[keyValueList.size()][];
        i = 0;
        while (i < keyValues.length) {
            keyValues[i] = (Object[])keyValueList.get(i);
            ++i;
        }
        return SelectionFactory.createMutiKeySelection(keyValues);
    }

    public static ISelection intersect(RangeSelection[] selections) {
        if (selections == null || selections.length == 0) {
            return SelectionFactory.createEmptySelection();
        }
        Object[] min = null;
        Object[] max = null;
        boolean containsMin = false;
        boolean containsMax = false;
        min = selections[0].getMin();
        containsMin = selections[0].isContainsMinKey();
        int i = 1;
        while (i < selections.length) {
            if (CompareUtil.compare(selections[i].getMin(), min) > 0) {
                min = selections[i].getMin();
                containsMin = selections[i].isContainsMinKey();
            }
            ++i;
        }
        max = selections[0].getMax();
        containsMax = selections[0].isContainsMaxKey();
        i = 0;
        while (i < selections.length) {
            if (CompareUtil.compare(selections[i].getMax(), max) < 0) {
                max = selections[i].getMax();
                containsMax = selections[i].isContainsMaxKey();
            }
            ++i;
        }
        int ret = CompareUtil.compare(min, max);
        if (ret > 0 || ret == 0 && (!containsMin || !containsMax)) {
            return SelectionFactory.createEmptySelection();
        }
        return SelectionFactory.createRangeSelection(min, max, containsMin, containsMax);
    }

    public static ISelection intersect(MultiKeySelection[] selections) {
        if (selections == null || selections.length == 0) {
            return SelectionFactory.createEmptySelection();
        }
        Object[][] uniqueKeyValues = selections[0].getKeyValues();
        boolean[] removed = new boolean[uniqueKeyValues.length];
        int size = uniqueKeyValues.length;
        int i = 1;
        while (i < selections.length) {
            Object[][] keyValues = selections[i].getKeyValues();
            int k = 0;
            while (k < uniqueKeyValues.length) {
                boolean found = false;
                int j = 0;
                while (j < keyValues.length) {
                    if (!removed[k] && CompareUtil.compare(uniqueKeyValues[k], keyValues[j]) == 0) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    removed[k] = true;
                    --size;
                }
                ++k;
            }
            ++i;
        }
        if (size == 0) {
            return SelectionFactory.createEmptySelection();
        }
        Object[][] intersectedKeyValues = new Object[size][];
        int i2 = 0;
        int j = 0;
        while (i2 < uniqueKeyValues.length) {
            if (!removed[i2]) {
                intersectedKeyValues[j++] = uniqueKeyValues[i2];
            }
            ++i2;
        }
        return SelectionFactory.createMutiKeySelection(intersectedKeyValues);
    }

    public static ISelection intersect(OneKeySelection[] selections) {
        if (selections == null || selections.length == 0) {
            return SelectionFactory.createEmptySelection();
        }
        Object[] key = selections[0].getKeyValue();
        int i = 0;
        while (i < selections.length) {
            if (CompareUtil.compare(key, selections[i].getKeyValue()) != 0) {
                return SelectionFactory.createEmptySelection();
            }
            ++i;
        }
        return SelectionFactory.createOneKeySelection(key);
    }

    public static ISelection union(OneKeySelection[] selections) {
        ArrayList<Object[]> keyValueList = new ArrayList<Object[]>();
        int i = 0;
        while (i < selections.length) {
            boolean found = false;
            int j = 0;
            while (j < keyValueList.size()) {
                Object[] keyValue = (Object[])keyValueList.get(j);
                if (CompareUtil.compare(keyValue, selections[i].getKeyValue()) == 0) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                keyValueList.add(selections[i].getKeyValue());
            }
            ++i;
        }
        Object[][] keyValues = new Object[keyValueList.size()][];
        int i2 = 0;
        while (i2 < keyValues.length) {
            keyValues[i2] = (Object[])keyValueList.get(i2);
            ++i2;
        }
        return SelectionFactory.createMutiKeySelection(keyValues);
    }
}

