/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.validation.internal.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.cosmos.rm.validation.internal.SMLActivator;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.validation.internal.artifacts.ResourceWrapper;
import org.eclipse.cosmos.rm.validation.internal.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationConstants;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationMessage;
import org.eclipse.cosmos.rm.validation.internal.common.IValidationOutput;
import org.eclipse.cosmos.rm.validation.internal.common.SMLMessages;
import org.eclipse.cosmos.rm.validation.internal.content.DefinitionContentDescriber;
import org.eclipse.cosmos.rm.validation.internal.content.InstanceContentDescriber;
import org.eclipse.cosmos.rm.validation.internal.content.SMLIFContentDescriber;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.validation.internal.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.validation.internal.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.validation.internal.reference.DerefXPathFunction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SMLValidatorUtil {
    public static XPath xpath;

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = xpath = factory == null ? null : factory.newXPath();
        if (xpath != null) {
            xpath.setXPathFunctionResolver(new XPathFunctionResolver(){

                public XPathFunction resolveFunction(QName functionName, int arity) {
                    if ("http://schemas.serviceml.org/sml/function/2006/07".equals(functionName.getNamespaceURI()) || "http://schemas.serviceml.org/smlfn/query/2006/07".equals(functionName.getNamespaceURI()) && "deref".equals(functionName.getLocalPart()) && arity == 1) {
                        return DerefXPathFunction.instance();
                    }
                    return null;
                }
            });
        }
    }

    public static Object retrieveDataStructure(String databuilderId) {
        IDataBuilder databuilder = DataBuilderRegistry.instance().getDataStructureBuilder(databuilderId);
        if (databuilder == null) {
            return null;
        }
        return databuilder.getDataStructure();
    }

    public static String removeLineBreaks(String str, boolean replaceWithSpace) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int lastChar = 0;
        int i = 0;
        int strLength = str.length();
        while (i < strLength) {
            char currentChar = str.charAt(i);
            if (currentChar != '\r' && (lastChar != 10 || currentChar != '\t' && currentChar != ' ')) {
                sb.append(currentChar == '\n' ? (replaceWithSpace ? " " : "") : String.valueOf(currentChar));
                lastChar = currentChar;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeLineBreaks(String str) {
        return SMLValidatorUtil.removeLineBreaks(str, true);
    }

    public static Map retrieveNestedMap(Map map, String key, boolean create) {
        Hashtable nestedMap = (Hashtable)map.get(key);
        if (create && nestedMap == null) {
            nestedMap = new Hashtable();
            map.put(key, nestedMap);
        }
        return nestedMap;
    }

    /*
     * Exception decompiling
     */
    public static Node retrieveRemoteDocument(String uri) throws RemoteRetrievalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Document domParseDocument(InputStream resource, boolean ignoreComments, boolean ignoreWhitespace) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        docBuilderFactory.setIgnoringElementContentWhitespace(ignoreWhitespace);
        docBuilderFactory.setIgnoringComments(ignoreComments);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(resource);
    }

    public static Document domParseDocument(InputStream resource) throws ParserConfigurationException, SAXException, IOException {
        return SMLValidatorUtil.domParseDocument(resource, true, true);
    }

    public static void saxParseDocument(InputStream resource, DefaultHandler contentHandler) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
        saxParserFactory.newSAXParser().parse(resource, contentHandler);
    }

    public static int identifyDocumentType(File resource) throws IOException, CoreException {
        FileInputStream fileInputStream = new FileInputStream(resource);
        try {
            int type = 3;
            Object[][] describer = new Object[][]{{new SMLIFContentDescriber(), new Integer(2)}, {new DefinitionContentDescriber(), new Integer(0)}, {new InstanceContentDescriber(), new Integer(1)}};
            BufferedReader br = new BufferedReader(new InputStreamReader(fileInputStream));
            StringBuffer sb = new StringBuffer();
            String input = null;
            while ((input = br.readLine()) != null) {
                sb.append(String.valueOf(input) + IValidationConstants.LINE_SEPARATOR);
            }
            int i = 0;
            while (i < describer.length) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(sb.toString().getBytes());
                if (((IContentDescriber)describer[i][0]).describe((InputStream)byteArrayInputStream, null) == 2) {
                    int n = (Integer)describer[i][1];
                    return n;
                }
                ++i;
            }
            int n = type;
            return n;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static int identifyDocumentType(IFile file) throws IOException, CoreException {
        int type = 3;
        InputStream fileInputStream = null;
        fileInputStream = file.exists() ? file.getContents() : new FileInputStream(file.getFullPath().toOSString());
        IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileInputStream, file.getName());
        int i = 0;
        while (i < types.length) {
            if ("org.eclipse.cosmos.rm.validation.smlifContentType".equals(types[i].getId())) {
                return 2;
            }
            if ("org.eclipse.cosmos.rm.validation.definitionContentType".equals(types[i].getId())) {
                return 0;
            }
            if ("org.eclipse.cosmos.rm.validation.instanceContentType".equals(types[i].getId())) {
                type = 1;
            }
            ++i;
        }
        return type;
    }

    public static int identifyDocumentType(ResourceWrapper resourceWrapper) throws IOException, CoreException {
        return resourceWrapper.getResource() instanceof File ? SMLValidatorUtil.identifyDocumentType((File)resourceWrapper.getResource()) : SMLValidatorUtil.identifyDocumentType((IFile)resourceWrapper.getResource());
    }

    public static void addElement(StringBuffer stringBuffer, int indent, String elementName, boolean close, boolean end) {
        if (stringBuffer == null) {
            return;
        }
        if (indent > 0) {
            SMLValidatorUtil.addIndent(stringBuffer, indent);
        }
        stringBuffer.append("<");
        stringBuffer.append(close ? "/" : "");
        stringBuffer.append(elementName);
        stringBuffer.append(end ? ">" + (close ? IValidationConstants.LINE_SEPARATOR : "") : "");
    }

    public static void addAttribute(StringBuffer stringBuffer, NamedNodeMap attributes, boolean close, boolean end) {
        int i = 0;
        int attCount = attributes.getLength();
        while (i < attCount) {
            Node currentAttribute = attributes.item(i);
            stringBuffer.append(" ");
            stringBuffer.append(currentAttribute.getNodeName());
            stringBuffer.append("=");
            stringBuffer.append("\"");
            stringBuffer.append(currentAttribute.getNodeValue());
            stringBuffer.append("\"");
            ++i;
        }
        stringBuffer.append(close ? "/" : "");
        stringBuffer.append(end ? ">" + (close ? IValidationConstants.LINE_SEPARATOR : "") : "");
    }

    public static void addIndent(StringBuffer stringBuffer, int indent) {
        int i = 0;
        while (i < indent) {
            stringBuffer.append("\t");
            ++i;
        }
    }

    public static boolean deleteFileTree(File root) {
        if (root.exists()) {
            if (root.isFile()) {
                return root.delete();
            }
            File[] children = root.listFiles();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    SMLValidatorUtil.deleteFileTree(children[i]);
                    ++i;
                }
            }
            return root.delete();
        }
        return true;
    }

    public static Node[] retrieveChildElements(Node node) {
        if (node == null) {
            return new Node[0];
        }
        ArrayList<Node> childElements = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                childElements.add(child);
            }
            ++i;
        }
        return childElements.toArray(new Node[childElements.size()]);
    }

    public static String tagNameFor(String namespace, String elementName) {
        StringBuffer buffer = new StringBuffer("");
        if (namespace != null) {
            buffer.append(namespace).append(":");
        }
        buffer.append(elementName);
        return buffer.toString();
    }

    public static String beginTagFor(String elementName) {
        return SMLValidatorUtil.tagFor(false, null, elementName);
    }

    public static String beginTagFor(String namespace, String elementName) {
        return SMLValidatorUtil.tagFor(false, namespace, elementName);
    }

    public static String endTagFor(String elementName) {
        return SMLValidatorUtil.tagFor(true, null, elementName);
    }

    public static String endTagFor(String namespace, String elementName) {
        return SMLValidatorUtil.tagFor(true, namespace, elementName);
    }

    public static String tagFor(boolean end, String namespace, String elementName) {
        StringBuffer tagBuffer = new StringBuffer();
        tagBuffer.append("<");
        if (end) {
            tagBuffer.append("/");
        }
        tagBuffer.append(SMLValidatorUtil.tagNameFor(namespace, elementName));
        tagBuffer.append(">");
        return tagBuffer.toString();
    }

    public static String createElementTag(String elementName, String elementData) {
        return String.valueOf(SMLValidatorUtil.beginTagFor(elementName)) + elementData + SMLValidatorUtil.endTagFor(elementName);
    }

    public static String createElementTag(String namespace, String elementName, String elementData) {
        return String.valueOf(SMLValidatorUtil.beginTagFor(namespace, elementName)) + elementData + SMLValidatorUtil.endTagFor(namespace, elementName);
    }

    public static void openErrorWithDetail(Shell parent, String title, String message, String cause) {
        class CustomErrorDialog
        extends ErrorDialog {
            private String cause;
            private static final int LIST_ITEM_COUNT = 7;
            private List list;
            private boolean isListDisplayed;
            private Clipboard clipboard;

            public CustomErrorDialog(Shell parentShell, int severity, String dialogTitle, String message, String cause) {
                super(parentShell, dialogTitle, cause == null ? null : message, (IStatus)new Status(severity, "org.eclipse.cosmos.rm.validation", severity, message, cause == null ? null : new Throwable(cause)), 7);
                this.cause = cause;
                this.isListDisplayed = false;
            }

            public void openErrorDialog() {
                this.open();
            }

            protected List createDropDownList(Composite parent) {
                if (this.isListDisplayed) {
                    this.isListDisplayed = false;
                    this.list.dispose();
                    return this.list;
                }
                this.isListDisplayed = true;
                this.list = new List(parent, 2818);
                if (this.cause != null) {
                    StringTokenizer st = new StringTokenizer(this.cause, "\n");
                    String indents = "";
                    boolean addedIndentation = false;
                    while (st.hasMoreTokens()) {
                        String currentToken = st.nextToken();
                        currentToken = currentToken.replace('\r', ' ');
                        currentToken = currentToken.trim();
                        if (!addedIndentation && currentToken.startsWith("at")) {
                            indents = String.valueOf(indents) + "  ";
                            addedIndentation = true;
                        } else if (addedIndentation && !currentToken.startsWith("at")) {
                            addedIndentation = false;
                        }
                        this.list.add(String.valueOf(indents) + currentToken);
                    }
                }
                GridData data = new GridData(1808);
                data.heightHint = this.list.getItemHeight() * 7;
                data.horizontalSpan = 2;
                this.list.setLayoutData((Object)data);
                this.list.setFont(parent.getFont());
                Menu copyMenu = new Menu((Control)this.list);
                MenuItem copyItem = new MenuItem(copyMenu, 0);
                copyItem.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.copyToClipboard();
                    }
                });
                copyItem.setText(SMLMessages.commonCopy);
                this.list.setMenu(copyMenu);
                return this.list;
            }

            private void copyToClipboard() {
                if (this.clipboard != null) {
                    this.clipboard.dispose();
                }
                StringBuffer clipBoardBuffer = new StringBuffer();
                String[] listEntrySelections = this.list.getSelection();
                int i = 0;
                while (i < listEntrySelections.length) {
                    clipBoardBuffer.append(String.valueOf(listEntrySelections[i]) + IValidationConstants.LINE_SEPARATOR);
                    ++i;
                }
                this.clipboard = new Clipboard(this.list.getDisplay());
                this.clipboard.setContents(new Object[]{clipBoardBuffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
        CustomErrorDialog errorDialog = new CustomErrorDialog(parent, 4, title, message, cause);
        errorDialog.openErrorDialog();
    }

    public static void openErrorWithDetail(String title, String message, Throwable t) {
        SMLValidatorUtil.openErrorWithDetail(title, message, t, true);
    }

    public static void openErrorWithDetail(final String title, final String message, Throwable t, final boolean defaultParent) {
        Object exceptionCause = null;
        String stackTrace = null;
        if (t != null) {
            stackTrace = SMLValidatorUtil.getExceptionStackTrace(t);
            exceptionCause = t.getCause() != null ? t.getCause() : t;
        }
        final String cause = exceptionCause == null ? null : String.valueOf(exceptionCause.getClass().getName()) + "\n" + ((Throwable)exceptionCause).getMessage() + "\n" + stackTrace;
        SMLActivator.getDefault().getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                SMLValidatorUtil.openErrorWithDetail(defaultParent ? SMLActivator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell() : null, title, message, cause);
            }
        });
    }

    protected static String getExceptionStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        Throwable throwable = SMLValidatorUtil.findCause(t);
        StringWriter stackTrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stackTrace));
        return stackTrace.toString();
    }

    protected static Throwable findCause(Throwable t) {
        Throwable cause = null;
        if (t instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)t).getTargetException();
        } else if (t instanceof CoreException) {
            cause = ((CoreException)t).getStatus().getException();
        }
        if (cause == null) {
            return t;
        }
        return SMLValidatorUtil.findCause(cause);
    }

    /*
     * Unable to fully structure code
     */
    public static String stringReplace(String originalString, String oldSubstring, String newSubstring) {
        result = new StringBuffer();
        index = 0;
        if (newSubstring != null) ** GOTO lbl14
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            prevIndex = index;
            if (index + oldSubstring.length() <= originalString.length() && (oldSubstring.length() == 0 || originalString.substring(index, index + oldSubstring.length()).equals(oldSubstring))) {
                result.append(newSubstring);
                index += oldSubstring.length();
            }
            if (prevIndex != index && !"".equals(oldSubstring)) continue;
            result.append(originalString.charAt(index));
            ++index;
lbl14:
            // 3 sources

            ** while (index < originalString.length())
        }
lbl15:
        // 1 sources

        return result.toString();
    }

    public static IValidationMessage createValidationMessage(DocumentDOMBuilder builder, Node node, String error) {
        if (!(node instanceof Element)) {
            return AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, error);
        }
        ElementLocation elementLocation = builder.getLocation((Element)node);
        return AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(elementLocation == null ? null : elementLocation.getFilePath(), elementLocation == null ? -1 : elementLocation.getLineNumber(), error);
    }

    public static void serializeNode(StringBuffer buffer, Node node, int indent, boolean autoFormat) {
        SMLValidatorUtil.serializeNode(buffer, node, indent, null, null, autoFormat);
    }

    public static void serializeNode(StringBuffer buffer, Node node) {
        SMLValidatorUtil.serializeNode(buffer, node, -1, false);
    }

    public static void serializeNode(StringBuffer buffer, Node node, int indent, String currentIndex, Map indices, boolean autoFormat) {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: {
                if (!autoFormat) {
                    buffer.append(node.getNodeValue());
                    break;
                }
                StringBuffer textValueBuffer = new StringBuffer();
                String textValue = node.getNodeValue();
                StringTokenizer st = new StringTokenizer(textValue, "\n");
                while (st.hasMoreTokens()) {
                    String currentToken = st.nextToken().trim();
                    if (currentToken.length() <= 0) continue;
                    textValueBuffer.append(IValidationConstants.LINE_SEPARATOR);
                    SMLValidatorUtil.addIndent(textValueBuffer, indent);
                    textValueBuffer.append(currentToken);
                }
                buffer.append(textValueBuffer);
                break;
            }
            case 8: {
                if (node.getNodeValue() == null) {
                    return;
                }
                SMLValidatorUtil.addIndent(buffer, indent);
                buffer.append("<!--" + node.getNodeValue() + "-->");
                buffer.append(IValidationConstants.LINE_SEPARATOR);
                break;
            }
            case 1: {
                if (autoFormat) {
                    boolean needsLineSep = false;
                    int i = buffer.length() - 1;
                    while (i >= 0) {
                        char currentChar = buffer.charAt(i);
                        if (currentChar == '\n') break;
                        if (currentChar != '\t' && currentChar != ' ' && currentChar != '\r') {
                            needsLineSep = true;
                            break;
                        }
                        --i;
                    }
                    if (needsLineSep) {
                        buffer.append(IValidationConstants.LINE_SEPARATOR);
                    }
                }
                NamedNodeMap attributes = node.getAttributes();
                Node[] children = SMLValidatorUtil.retrieveChildNodes(node);
                boolean hasAttributes = attributes != null && attributes.getLength() > 0;
                boolean hasChildren = children != null && children.length > 0;
                int[] elementIndices = new int[2];
                elementIndices[0] = buffer.length();
                if (autoFormat) {
                    SMLValidatorUtil.addElement(buffer, indent, node.getNodeName(), false, false);
                } else {
                    SMLValidatorUtil.addIndent(buffer, indent);
                    buffer.append("<").append(node.getNodeName());
                }
                if (hasAttributes) {
                    if (autoFormat) {
                        SMLValidatorUtil.addAttribute(buffer, attributes, !hasChildren, true);
                    } else {
                        int i = 0;
                        int attCount = attributes.getLength();
                        while (i < attCount) {
                            Node currentAttribute = attributes.item(i);
                            buffer.append(" " + currentAttribute.getNodeName() + "=" + "\"" + currentAttribute.getNodeValue() + "\"");
                            ++i;
                        }
                        buffer.append(hasChildren ? ">" : "/>");
                    }
                } else if (hasChildren) {
                    buffer.append(">");
                } else {
                    buffer.append("/").append(">");
                }
                if (!hasChildren) {
                    elementIndices[1] = buffer.length();
                    if (currentIndex != null) {
                        indices.put(currentIndex, elementIndices);
                    }
                    return;
                }
                int counter = -1;
                if (autoFormat) {
                    int i = 0;
                    while (i < children.length) {
                        Node child = children[i];
                        if (!SMLValidatorUtil.isWhitespace(child)) {
                            buffer.append(IValidationConstants.LINE_SEPARATOR);
                            if (child.getNodeType() == 1) {
                                ++counter;
                            }
                            SMLValidatorUtil.serializeNode(buffer, child, indent + 1, currentIndex == null ? null : String.valueOf(currentIndex) + "," + counter, indices, autoFormat);
                        }
                        ++i;
                    }
                } else {
                    NodeList children1 = node.getChildNodes();
                    int i = 0;
                    int nodeCount = children1.getLength();
                    while (i < nodeCount) {
                        Node currentChild = children1.item(i);
                        if (currentChild.getNodeType() == 1) {
                            ++counter;
                        }
                        SMLValidatorUtil.serializeNode(buffer, currentChild, 0, currentIndex == null ? null : String.valueOf(currentIndex) + "," + counter, indices, autoFormat);
                        ++i;
                    }
                }
                if (autoFormat) {
                    buffer.append(IValidationConstants.LINE_SEPARATOR);
                    SMLValidatorUtil.addElement(buffer, indent, node.getNodeName(), true, true);
                } else {
                    buffer.append("<").append("/").append(node.getNodeName()).append(">");
                }
                elementIndices[1] = buffer.length();
                if (currentIndex == null) break;
                indices.put(currentIndex, elementIndices);
                break;
            }
            case 9: {
                buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + IValidationConstants.LINE_SEPARATOR);
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int i = 0;
                int childCount = children.getLength();
                while (i < childCount) {
                    SMLValidatorUtil.serializeNode(buffer, children.item(i), indent, currentIndex, indices, autoFormat);
                    ++i;
                }
                break;
            }
        }
    }

    private static Node[] retrieveChildNodes(Node node) {
        if (node == null) {
            return null;
        }
        NodeList children = node.getChildNodes();
        ArrayList<Node> finalChildrenList = new ArrayList<Node>();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (!SMLValidatorUtil.isWhitespace(child)) {
                finalChildrenList.add(child);
            }
            ++i;
        }
        return finalChildrenList.toArray(new Node[finalChildrenList.size()]);
    }

    public static boolean isWhitespace(Node node) {
        return node != null && node.getNodeType() == 3 && (node.getNodeValue() == null || node.getNodeValue().trim().length() <= 0);
    }

    public static SAXParser createSAXParser(Object schemaSource, boolean validating, LexicalHandler lexicalHandler, IValidationOutput validationLogger) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(validating);
        saxParserFactory.setFeature("http://xml.org/sax/features/validation", validating);
        saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
        saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser newSaxParser = saxParserFactory.newSAXParser();
        if (schemaSource == null) {
            return newSaxParser;
        }
        try {
            newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSource);
            if (lexicalHandler != null) {
                newSaxParser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            }
        }
        catch (Exception exception) {
            validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(-1, SMLMessages.errorUnsupportedSAXProperty0));
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            newSaxParser = saxParserFactory.newSAXParser();
        }
        return newSaxParser;
    }

    public static String retrieveAbsolutePath(String path) {
        Path resourcePath = new Path(path);
        if (resourcePath.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(resourcePath.segment(0)).getLocation().toOSString();
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        if (file != null && SMLValidatorUtil.checkWorkspaceResourceName(path)) {
            return file.getLocation().toOSString();
        }
        return path;
    }

    public static boolean checkWorkspaceDirName(String dirName) {
        boolean okForFolder = ResourcesPlugin.getWorkspace().validatePath(dirName, 2).isOK();
        if (!okForFolder) {
            okForFolder = ResourcesPlugin.getWorkspace().validatePath(dirName, 4).isOK();
        }
        return okForFolder;
    }

    public static boolean checkWorkspaceResourceName(String resourceName) {
        if (!resourceName.startsWith("/")) {
            resourceName = String.valueOf('/') + resourceName;
        }
        return ResourcesPlugin.getWorkspace().validatePath(resourceName, 1).isOK();
    }

    public static class RemoteRetrievalException
    extends Exception {
        private static final long serialVersionUID = 7633895444717500045L;

        public RemoteRetrievalException(String message) {
            super(message);
        }

        public RemoteRetrievalException(Exception cause) {
            super(cause);
        }
    }
}

