/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.sample.components.query;

import com.ibatis.common.resources.Resources;
import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapClientBuilder;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import org.eclipse.cosmos.dc.common.api.IDataFilterService;
import org.eclipse.cosmos.dc.common.api.IDataQueryResult;
import org.eclipse.cosmos.dc.common.api.IDataResponseService;
import org.eclipse.cosmos.dc.common.api.IDataTransformService;
import org.eclipse.cosmos.dc.common.api.impl.AbstractQuery;
import org.eclipse.cosmos.dc.common.api.impl.SimpleDataQueryResult;
import org.eclipse.cosmos.dc.common.registry.ProviderRegistry;
import org.eclipse.cosmos.dc.common.spi.IWireTarget;
import org.eclipse.cosmos.dc.mgmt.annotations.ManagedResource;
import org.eclipse.cosmos.dc.mgmt.common.ContributionManager;
import org.eclipse.cosmos.dc.sample.components.sink.cbe.CBERDBSink;
import org.eclipse.cosmos.dc.spec.capabilitiy.CBEQueryCapability;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;

@ManagedResource
public class CBEQuery
extends AbstractQuery
implements CBEQueryCapability {
    private static Class[] supportedTypes = new Class[]{CommonBaseEvent.class};
    private SqlMapClient sqlMapper;
    private ProviderRegistry registry;
    private static String[] supportedDialects = new String[]{"CBEPOJO"};
    private static SqlMapClient CBESqlMapper;

    static {
        try {
            Thread.currentThread().setContextClassLoader(CBERDBSink.class.getClassLoader());
            Reader reader = Resources.getResourceAsReader((String)"org/eclipse/cosmos/dc/sample/components/sink/cbe/CBESqlMapConfig.xml");
            CBESqlMapper = SqlMapClientBuilder.buildSqlMapClient((Reader)reader);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CBEQuery(ContributionManager manager, SqlMapClient sqlMapper, ProviderRegistry registry, Element binding) {
        super(manager);
        this.sqlMapper = sqlMapper;
        this.registry = registry;
    }

    public boolean acceptWireTarget(IWireTarget target) throws Exception {
        if (target instanceof IDataFilterService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n2 = classArray.length;
            while (n < n2) {
                Class type = classArray[n];
                if (((IDataFilterService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (target instanceof IDataTransformService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n3 = classArray.length;
            while (n < n3) {
                Class type = classArray[n];
                if (((IDataTransformService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        if (target instanceof IDataResponseService) {
            Class[] classArray = supportedTypes;
            int n = 0;
            int n4 = classArray.length;
            while (n < n4) {
                Class type = classArray[n];
                if (((IDataResponseService)target).acceptType(type)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return false;
    }

    public String[] getSupportedDialects() {
        return supportedDialects;
    }

    public String[] getSupportedResponses() {
        return null;
    }

    public IDataQueryResult pageQuery(String dialect, String response, String queryString, String dataSource, int max, int start) throws Exception {
        return null;
    }

    public IDataQueryResult query(String dialect, String response, String queryString, String dataSource) throws Exception {
        return null;
    }

    public boolean supportedQuery(String dialect, String response) {
        return false;
    }

    public Class[] getOutputTypes() {
        return null;
    }

    public IDataQueryResult getAllCBE(String dataset) throws Exception {
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        try {
            try {
                this.sqlMapper.startTransaction();
                List list = CBESqlMapper.queryForList("selectAllCBE", (Object)dataset);
                this.sqlMapper.commitTransaction();
                result.setRawResponseCollection((Collection)list);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.sqlMapper.endTransaction();
            }
        }
        finally {
            this.sqlMapper.endTransaction();
        }
        return result;
    }

    public IDataQueryResult getCBECountBySeverity(String dataset) throws Exception {
        SimpleDataQueryResult result = new SimpleDataQueryResult();
        try {
            this.sqlMapper.startTransaction();
            List list = CBESqlMapper.queryForList("countCBEbySeverity", (Object)dataset);
            this.sqlMapper.commitTransaction();
            result.setRawResponseCollection((Collection)list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

