/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public abstract class ReportElementHandle
extends DesignElementHandle {
    protected DesignElement element;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.api.ReportElementHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ReportElementHandle(Module module, DesignElement element) {
        super(module);
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError();
        }
        this.element = element;
    }

    public DesignElement getElement() {
        return this.element;
    }

    public Iterator propertyMaskIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("propertyMasks");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public String getPropertyMask(String propName) {
        ElementPropertyDefn prop = this.getElement().getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getElement().getPropertyMask(this.module, propName);
    }

    public void setPropertyMask(String propName, String maskValue) throws SemanticException {
        if ("propertyMasks".equalsIgnoreCase(propName)) {
            return;
        }
        ElementPropertyDefn maskProp = this.getElement().getPropertyDefn("propertyMasks");
        if (maskProp == null) {
            throw new PropertyNameException(this.element, propName);
        }
        ElementPropertyDefn prop = this.getElement().getPropertyDefn(propName);
        if (prop == null) {
            return;
        }
        ArrayList masks = (ArrayList)this.getElement().getLocalProperty(this.getModule(), "propertyMasks");
        PropertyMask mask = null;
        if (masks == null) {
            masks = new ArrayList();
            this.getElement().setProperty("propertyMasks", masks);
        }
        int i = 0;
        while (i < masks.size()) {
            PropertyMask tmpMask = (PropertyMask)masks.get(i);
            if (propName.equalsIgnoreCase(tmpMask.getName())) {
                mask = tmpMask;
                break;
            }
            ++i;
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.module, this.getElement());
        if (maskValue == null && mask != null) {
            cmd.removeItem((MemberRef)new CachedMemberRef(maskProp), masks.indexOf(mask));
        } else {
            StructPropertyDefn maskDefn = (StructPropertyDefn)maskProp.getStructDefn().getMember("mask");
            StructPropertyDefn nameDefn = (StructPropertyDefn)maskProp.getStructDefn().getMember("name");
            String value = maskDefn.validateValue(this.getModule(), maskValue).toString();
            if (mask == null) {
                mask = new PropertyMask();
                mask.setProperty(maskDefn, (Object)value);
                mask.setProperty(nameDefn, (Object)propName);
                cmd.addItem((MemberRef)new CachedMemberRef(maskProp), (Object)mask);
            } else {
                CachedMemberRef memberRef = new CachedMemberRef(maskProp, masks.indexOf(mask), "mask");
                PropertyCommand pCmd = new PropertyCommand(this.module, this.getElement());
                pCmd.setMember(memberRef, value);
            }
        }
    }

    public void setDisplayNameKey(String displayNameKey) throws SemanticException {
        this.setStringProperty("displayNameID", displayNameKey);
    }

    public String getDisplayNameKey() {
        return this.getStringProperty("displayNameID");
    }

    public void setDisplayName(String displayName) throws SemanticException {
        this.setStringProperty("displayName", displayName);
    }

    public String getDisplayName() {
        return this.getStringProperty("displayName");
    }

    public void setCustomXml(String customXml) throws SemanticException {
        this.setStringProperty("customXml", customXml);
    }

    public String getCustomXml() {
        return this.getStringProperty("customXml");
    }

    public void setComments(String theComments) throws SemanticException {
        this.setStringProperty("comments", theComments);
    }

    public String getComments() {
        return this.getStringProperty("comments");
    }

    void duplicateExtendedElement() {
        block3: {
            DesignElementHandle extendedElementHandle = this.getExtends();
            if (extendedElementHandle == null) {
                return;
            }
            try {
                DesignElement cloned;
                this.element = cloned = (DesignElement)extendedElementHandle.getElement().clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public boolean isValidReferenceForCompoundElement() {
        return ModelUtil.isValidReferenceForCompoundElement(this.getModule(), this.element);
    }

    public boolean isValidLayoutForCompoundElement() {
        return ModelUtil.isValidLayout(this.getModule(), this.element);
    }
}

