/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.CircularExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.command.ExtendsForbiddenException;
import org.eclipse.birt.report.model.api.command.InvalidParentException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.command.WrongTypeException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IObjectDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.SimpleListValidator;
import org.eclipse.birt.report.model.api.validators.StructureListValidator;
import org.eclipse.birt.report.model.api.validators.UnsupportedElementValidator;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.IPropertySet;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.MultiElementSlot;
import org.eclipse.birt.report.model.core.PropertySearchStrategy;
import org.eclipse.birt.report.model.core.SingleElementSlot;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.interfaces.IDesignElementModel;
import org.eclipse.birt.report.model.elements.strategy.CopyForPastePolicy;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.IContainerDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;
import org.eclipse.birt.report.model.validators.ValidationExecutor;

public abstract class DesignElement
implements IDesignElement,
IPropertySet,
IDesignElementModel {
    public static final long NO_BASE_ID = -1L;
    public static final long NO_ID = 0L;
    private static final int MAX_DISPLAY_LABEL_LEN = 30;
    protected String name = null;
    protected ArrayList listeners = null;
    protected Map propValues = new HashMap();
    protected HashMap userProperties = null;
    protected ContainerContext containerInfo = null;
    protected ContainerSlot[] slots = null;
    protected ElementRefValue extendsRef = null;
    protected ArrayList derived = null;
    protected long id = 0L;
    protected IElementDefn cachedDefn = null;
    protected boolean isValid = true;
    protected DesignElementHandle handle = null;
    protected List errors;
    protected long baseId = -1L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.core.DesignElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DesignElement() {
    }

    public DesignElement(String theName) {
        this.name = theName;
    }

    public void addListener(Listener obj) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (obj != null && !this.listeners.contains(obj)) {
            this.listeners.add(obj);
        }
    }

    public void removeListener(Listener obj) {
        if (this.listeners == null) {
            return;
        }
        int posn = this.listeners.indexOf(obj);
        if (posn != -1) {
            this.listeners.remove(posn);
        }
    }

    public void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }

    public void sendEvent(NotificationEvent ev) {
        ev.setDeliveryPath(0);
        this.broadcast(ev);
    }

    public Module getRoot() {
        DesignElement element = this;
        while (element.getContainer() != null) {
            element = element.getContainer();
        }
        if (!(element instanceof Module)) {
            return null;
        }
        return (Module)element;
    }

    public final void broadcast(NotificationEvent ev) {
        if (this instanceof Module || this.getContainer() != null) {
            this.broadcast(ev, this.getRoot());
        }
    }

    public void broadcast(NotificationEvent ev, Module module) {
        if (this.listeners != null) {
            ArrayList tmpListeners = new ArrayList(this.listeners);
            Iterator iter = tmpListeners.iterator();
            while (iter.hasNext()) {
                ((Listener)iter.next()).elementChanged(this.getHandle(module), ev);
            }
        }
        if (this.derived != null) {
            if (ev.getDeliveryPath() == 4) {
                return;
            }
            if (ev.getDeliveryPath() != 2) {
                ev.setDeliveryPath(1);
            }
            Iterator iter = this.derived.iterator();
            while (iter.hasNext()) {
                ((DesignElement)iter.next()).broadcast(ev, module);
            }
        }
    }

    public final boolean isVirtualElement() {
        return this.baseId != -1L;
    }

    public DesignElement getVirtualParent() {
        if (!this.isVirtualElement()) {
            return null;
        }
        DesignElement parent = null;
        DesignElement cur = this;
        while (cur != null) {
            DesignElement extendsElement = cur.getExtendsElement();
            if (extendsElement != null) {
                parent = extendsElement;
                break;
            }
            cur = cur.getContainer();
        }
        if (parent == null) {
            return null;
        }
        if (!$assertionsDisabled && !(parent.getContainer() instanceof Module)) {
            throw new AssertionError();
        }
        return parent.getRoot().getElementByID(this.baseId);
    }

    public Object getProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getProperty(module, prop);
    }

    public Object getProperty(Module module, ElementPropertyDefn prop) {
        Object value = this.getStrategy().getPropertyExceptRomDefault(module, this, prop);
        if (value != null) {
            this.updateContainerForContentElement(module, prop, value);
            return value;
        }
        return prop.getDefault();
    }

    private void updateContainerForContentElement(Module module, ElementPropertyDefn prop, Object value) {
        ContentElementInfo info = null;
        if (this instanceof ContentElement) {
            info = ((ContentElement)this).getValueContainer();
        } else if (prop.getTypeCode() == 24 || prop.getSubTypeCode() == 24) {
            info = new ContentElementInfo(this, prop);
        }
        if (prop.getTypeCode() != 24 && prop.getSubTypeCode() != 24) {
            return;
        }
        if (value instanceof ContentElement) {
            Module root = ((ContentElement)value).getRoot();
            ContentElementInfo tmpInfo = null;
            if (root != module) {
                tmpInfo = info;
            }
            ((ContentElement)value).setValueContainer(tmpInfo);
        } else if (value instanceof List) {
            List items = (List)value;
            Module root = null;
            ContentElementInfo tmpInfo = null;
            int i = 0;
            while (i < items.size()) {
                ContentElement item = (ContentElement)items.get(i);
                if (root == null && (root = item.getRoot()) != module) {
                    tmpInfo = info;
                }
                item.setValueContainer(tmpInfo);
                ++i;
            }
        }
    }

    public PropertySearchStrategy getStrategy() {
        return PropertySearchStrategy.getInstance();
    }

    public Object getProperty(Module module, PropertyDefn prop) {
        return this.getProperty(module, (ElementPropertyDefn)prop);
    }

    public boolean isStyle() {
        return false;
    }

    public Object getLocalProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getLocalProperty(module, prop);
    }

    public Object getLocalProperty(Module module, ElementPropertyDefn prop) {
        if (prop.isIntrinsic()) {
            return this.getIntrinsicProperty(prop.getName());
        }
        switch (prop.getTypeCode()) {
            case 15: {
                this.resolveElementReference(module, prop);
                break;
            }
            case 19: {
                this.resolveStructReference(module, prop);
                break;
            }
            case 20: {
                if (prop.getSubTypeCode() != 15) break;
                return this.resolveElementReferenceList(module, prop);
            }
        }
        return this.propValues.get(prop.getName());
    }

    protected Object getIntrinsicProperty(String propName) {
        if ("name".equals(propName)) {
            return this.name;
        }
        if ("extends".equals(propName)) {
            if (this.extendsRef != null && !this.extendsRef.isResolved()) {
                ReferenceValueUtil.resloveExtends(this.getRoot(), this, this.extendsRef);
            }
            return this.extendsRef;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected void setIntrinsicProperty(String propName, Object value) {
        if (propName.equals("name")) {
            this.setName((String)value);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void setProperty(String propName, Object value) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        this.setProperty(prop, value);
    }

    public void setProperty(ElementPropertyDefn prop, Object value) {
        ReferenceValue oldRef;
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        String propName = prop.getName();
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(propName, value);
            return;
        }
        if (prop.getTypeCode() == 15) {
            oldRef = (ElementRefValue)this.propValues.get(propName);
            ReferenceValueUtil.updateReference(this, oldRef, (ReferenceValue)value, prop);
        }
        if (prop.getTypeCode() == 19) {
            oldRef = (StructRefValue)this.propValues.get(propName);
            ReferenceValueUtil.updateReference(this, oldRef, (StructRefValue)value, prop);
        }
        if (value == null) {
            this.propValues.remove(propName);
        } else {
            this.propValues.put(propName, value);
        }
    }

    public String getPropertyMask(Module module, String propName) {
        DesignElement e = this;
        do {
            ArrayList masks;
            if ((masks = (ArrayList)e.getLocalProperty(module, "propertyMasks")) == null) continue;
            int i = 0;
            while (i < masks.size()) {
                PropertyMask mask = (PropertyMask)masks.get(i);
                if (propName.equals(mask.getName())) {
                    return mask.getMask();
                }
                ++i;
            }
        } while ((e = e.getExtendsElement()) != null);
        return null;
    }

    public void setProperty(PropertyDefn prop, Object value) {
        this.setProperty((ElementPropertyDefn)prop, value);
    }

    public void clearProperty(String propName) {
        this.setProperty(propName, null);
    }

    public IElementDefn getDefn() {
        if (this.cachedDefn == null) {
            this.cachedDefn = MetaDataDictionary.getInstance().getElement(this.getElementName());
            if (!$assertionsDisabled && this.cachedDefn == null) {
                throw new AssertionError();
            }
        }
        return this.cachedDefn;
    }

    public void addUserPropertyDefn(UserPropertyDefn userProp) {
        if (!$assertionsDisabled && !this.getDefn().allowsUserProperties()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && userProp == null) {
            throw new AssertionError();
        }
        String propName = userProp.getName();
        if (!$assertionsDisabled && this.getUserPropertyDefn(propName) != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.getDefn().getProperty(propName) != null) {
            throw new AssertionError();
        }
        if (this.userProperties == null) {
            this.userProperties = new LinkedHashMap();
        }
        this.userProperties.put(propName, userProp);
    }

    public void dropUserPropertyDefn(UserPropertyDefn prop) {
        if (!$assertionsDisabled && !this.getDefn().allowsUserProperties()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.userProperties == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.userProperties.get(prop.getName()) != prop) {
            throw new AssertionError();
        }
        this.userProperties.remove(prop.getName());
    }

    public UserPropertyDefn getLocalUserPropertyDefn(String propName) {
        if (this.userProperties == null) {
            return null;
        }
        return (UserPropertyDefn)this.userProperties.get(propName);
    }

    public UserPropertyDefn getUserPropertyDefn(String propName) {
        DesignElement e = this;
        while (e != null) {
            UserPropertyDefn p = e.getLocalUserPropertyDefn(propName);
            if (p != null) {
                return p;
            }
            e = e.getExtendsElement();
        }
        return null;
    }

    public DesignElement getExtendsElement() {
        if (this.extendsRef == null) {
            return null;
        }
        if (!this.extendsRef.isResolved()) {
            ReferenceValueUtil.resloveExtends(this.getRoot(), this, this.extendsRef);
        }
        return this.extendsRef.getElement();
    }

    public String getExtendsName() {
        if (this.extendsRef == null) {
            return null;
        }
        return StringUtil.buildQualifiedReference(this.extendsRef.getLibraryNamespace(), this.extendsRef.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getName();
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public DesignElement getContainer() {
        return this.containerInfo == null ? null : this.containerInfo.container;
    }

    public ElementPropertyDefn getPropertyDefn(String propName) {
        if (propName == null) {
            return null;
        }
        ElementPropertyDefn prop = (ElementPropertyDefn)this.getDefn().getProperty(propName);
        if (prop == null) {
            prop = this.getUserPropertyDefn(propName);
        }
        return prop;
    }

    void validatePropertyName(String propName) throws PropertyNameException {
        if (this.getPropertyDefn(propName) == null) {
            throw new PropertyNameException(this, propName);
        }
    }

    public Object validatePropertyValue(Module module, String propName, Object value) throws PropertyNameException, PropertyValueException {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            throw new PropertyNameException(this, propName);
        }
        try {
            return prop.validateValue(module, value);
        }
        catch (PropertyValueException e) {
            e.setElement(this);
            e.setPropertyName(propName);
            throw e;
        }
    }

    public StyleElement getStyle(Module module) {
        return null;
    }

    public StyleElement getStyle() {
        return null;
    }

    public void addDerived(DesignElement child) {
        if (this.derived == null) {
            this.derived = new ArrayList();
        }
        if (!$assertionsDisabled && child == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child.getExtendsElement() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.derived.contains(child)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child.getDefn() != this.getDefn()) {
            throw new AssertionError();
        }
        this.derived.add(child);
    }

    public void dropDerived(DesignElement child) {
        if (!$assertionsDisabled && this.derived == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && child.getExtendsElement() != this) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.derived.contains(child)) {
            throw new AssertionError();
        }
        this.derived.remove(child);
    }

    public void setExtendsElement(DesignElement base) {
        DesignElement oldExtends = this.getExtendsElement();
        if (base == oldExtends && base != null) {
            return;
        }
        if (oldExtends != null) {
            oldExtends.dropDerived(this);
        }
        if (base == null) {
            this.extendsRef = null;
        } else {
            if (!$assertionsDisabled && base.getDefn() != this.getDefn()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && base.getName() == null) {
                throw new AssertionError();
            }
            String namespace = null;
            Module root = base.getRoot();
            if (root instanceof Library) {
                namespace = ((Library)root).getNamespace();
            }
            this.extendsRef = new ElementRefValue(namespace, base);
            base.addDerived(this);
        }
    }

    public TemplateParameterDefinition getTemplateParameterElement(Module module) {
        ElementRefValue templateParam = (ElementRefValue)this.getProperty(module, "refTemplateParameter");
        if (templateParam == null) {
            return null;
        }
        return (TemplateParameterDefinition)templateParam.getElement();
    }

    public List getDescendents() {
        ArrayList list = new ArrayList();
        this.gatherDescendents(list);
        return list;
    }

    public void gatherDescendents(ArrayList list) {
        if (this.derived == null) {
            return;
        }
        int i = 0;
        while (i < this.derived.size()) {
            DesignElement child = (DesignElement)this.derived.get(i);
            list.add(child);
            child.gatherDescendents(list);
            ++i;
        }
    }

    public boolean hasUserProperties() {
        return this.userProperties != null && !this.userProperties.isEmpty();
    }

    public boolean hasLocalPropertyValues() {
        return !this.propValues.isEmpty();
    }

    public Iterator propertyWithLocalValueIterator() {
        return this.propValues.keySet().iterator();
    }

    public ContainerSlot getSlot(int slot) {
        return null;
    }

    public List getUserProperties() {
        ArrayList props = new ArrayList();
        DesignElement e = this;
        while (e != null) {
            List prop = e.getLocalUserProperties();
            if (prop != null) {
                props.addAll(prop);
            }
            e = e.getExtendsElement();
        }
        return props;
    }

    public List getLocalUserProperties() {
        if (this.userProperties == null) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.userProperties.values());
    }

    public boolean isKindOf(DesignElement element) {
        DesignElement e = this;
        while (e != null) {
            if (e == element) {
                return true;
            }
            e = e.getExtendsElement();
        }
        return false;
    }

    public boolean hasDerived() {
        return this.derived != null && this.derived.size() > 0;
    }

    public String getDisplayName() {
        return (String)this.getLocalProperty(null, "displayName");
    }

    public String getDisplayNameID() {
        return (String)this.getLocalProperty(null, "displayNameID");
    }

    public void setID(long newID) {
        this.id = newID;
    }

    public long getID() {
        return this.id;
    }

    public boolean isContentOf(DesignElement element) {
        DesignElement e = this;
        while (e != null) {
            if (e == element) {
                return true;
            }
            e = e.getContainer();
        }
        return false;
    }

    public BigDecimal getNumberProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        Object value = this.getProperty(module, prop);
        return prop.getNumberValue(module, value);
    }

    public abstract void apply(ElementVisitor var1);

    public String getStringProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        Object value = this.getProperty(module, prop);
        return prop.getStringValue(module, value);
    }

    public String getDisplayProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getDisplayProperty(module, prop);
    }

    public String getDisplayProperty(Module module, PropertyDefn prop) {
        Object value = this.getProperty(module, prop);
        if (value == null) {
            return null;
        }
        return prop.getDisplayValue(module, value);
    }

    public void setExtendsName(String name) {
        this.setExtendsElement(null);
        name = StringUtil.trimString(name);
        if (name == null) {
            return;
        }
        String namespace = StringUtil.extractNamespace(name);
        name = StringUtil.extractName(name);
        this.extendsRef = new ElementRefValue(namespace, name);
    }

    public final List validateWithContents(Module module) {
        ElementDefn elementDefn = (ElementDefn)this.getDefn();
        List validatorList = ValidationExecutor.getValidationNodes(this, elementDefn.getTriggerDefnSet(), true);
        ValidationExecutor executor = module.getValidationExecutor();
        this.errors = executor.perform(this, validatorList);
        ArrayList list = new ArrayList(this.errors);
        int count = this.getDefn().getSlotCount();
        int i = 0;
        while (i < count) {
            Iterator iter = this.getSlot(i).iterator();
            while (iter.hasNext()) {
                list.addAll(((DesignElement)iter.next()).validateWithContents(module));
            }
            ++i;
        }
        return list;
    }

    public List validate(Module module) {
        this.errors = new ArrayList();
        this.errors.addAll(UnsupportedElementValidator.getInstance().validate(module, this));
        ArrayList propMasks = (ArrayList)this.getLocalProperty(module, "propertyMasks");
        if (propMasks != null) {
            ListIterator masks = propMasks.listIterator();
            while (masks.hasNext()) {
                PropertyMask mask = (PropertyMask)masks.next();
                this.errors.addAll(mask.validate(module, this));
            }
        }
        return this.errors;
    }

    protected List validateStructureList(Module module, String propName) {
        return StructureListValidator.getInstance().validate(module, this, propName);
    }

    public void checkStructureList(Module module, PropertyDefn propDefn, List list, IStructure toAdd) throws PropertyValueException {
        List errorList = StructureListValidator.getInstance().validateForAdding(this.getHandle(module), propDefn, list, toAdd);
        if (errorList.size() > 0) {
            throw (PropertyValueException)((Object)errorList.get(0));
        }
    }

    public void checkExtends(DesignElement parent) throws ExtendsException {
        String extendsName = this.getExtendsName();
        IElementDefn defn = this.getDefn();
        if (parent == null) {
            throw new InvalidParentException(this, extendsName, "Error.InvalidParentException.PARENT_NOT_FOUND");
        }
        if (!defn.canExtend()) {
            throw new ExtendsForbiddenException(this, parent.getName(), "Error.ExtendsForbiddenException.CANT_EXTEND");
        }
        if (parent.getDefn() != defn) {
            throw new WrongTypeException(this, parent, "Error.WrongTypeException.WRONG_TYPE");
        }
        if (parent == this) {
            throw new CircularExtendsException(this, extendsName, "Error.CircularExtendsException.SELF_EXTEND");
        }
        if (parent.isKindOf(this)) {
            throw new CircularExtendsException(this, parent, "Error.CircularExtendsException.CIRCULAR");
        }
    }

    public int getIntProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return 0;
        }
        Object value = this.getProperty(module, prop);
        return prop.getIntValue(module, value);
    }

    public double getFloatProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return 0.0;
        }
        Object value = this.getProperty(module, prop);
        return prop.getFloatValue(module, value);
    }

    public boolean getBooleanProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return false;
        }
        Object value = this.getProperty(module, prop);
        return prop.getBooleanValue(module, value);
    }

    public List getListProperty(Module module, String propName) {
        Object value = this.getProperty(module, propName);
        if (value == null) {
            return null;
        }
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        return null;
    }

    public List getPropertyDefns() {
        List list = this.getDefn().getProperties();
        DesignElement e = this;
        while (e != null) {
            if (e.userProperties != null) {
                list.addAll(e.userProperties.values());
            }
            e = e.getExtendsElement();
        }
        return list;
    }

    public abstract String getElementName();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof DesignElementHandle) {
            return ((DesignElementHandle)obj).getElement() == this;
        }
        return false;
    }

    public int findSlotOf(DesignElement content) {
        if (content == null || content.getContainer() != this) {
            return -1;
        }
        return content.getContainerInfo().getSlotID();
    }

    public boolean canEdit(Module module) {
        return !this.isRootIncludedByModule() && (module == null || !module.isReadOnly());
    }

    public boolean canDrop(Module module) {
        List clients;
        if (this.isRootIncludedByModule() || module != null && module.isReadOnly()) {
            return false;
        }
        if (this.isVirtualElement()) {
            return false;
        }
        if (this.getContainer() instanceof TemplateParameterDefinition) {
            if (!$assertionsDisabled && this.getContainerInfo().getSlotID() != 0) {
                throw new AssertionError();
            }
            return false;
        }
        DesignElement element = this;
        return !(element instanceof TemplateParameterDefinition) || (clients = ((TemplateParameterDefinition)element).getClientList()).size() == 0;
    }

    public boolean isRootIncludedByModule() {
        Module tmpContainer = this.getRoot();
        return tmpContainer instanceof Library && ((Library)tmpContainer).getHost() != null;
    }

    public List checkContent(Module module, ContainerContext containerInfo, DesignElement content) {
        return new ArrayList();
    }

    public List checkContent(Module module, ContainerContext containerInfo, IElementDefn defn) {
        return new ArrayList();
    }

    public ContainerContext getContainerInfo() {
        return this.containerInfo;
    }

    public IObjectDefn getObjectDefn() {
        return this.getDefn();
    }

    public DesignElement getReferenceProperty(Module module, String propName) {
        ElementRefValue ref = (ElementRefValue)this.getProperty(module, propName);
        if (ref == null) {
            return null;
        }
        return ref.getElement();
    }

    public boolean hasReferences() {
        return false;
    }

    public Object getFactoryProperty(Module module, ElementPropertyDefn prop) {
        if (!$assertionsDisabled && prop.isStyleProperty()) {
            throw new AssertionError();
        }
        return this.getStrategy().getPropertyExceptRomDefault(module, this, prop);
    }

    public Object getFactoryProperty(Module module, String propName) {
        ElementPropertyDefn prop = this.getPropertyDefn(propName);
        if (prop == null) {
            return null;
        }
        return this.getFactoryProperty(module, prop);
    }

    public List getDerived() {
        if (this.derived != null) {
            return new ArrayList(this.derived);
        }
        return new ArrayList();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String getDisplayLabel(Module module, int level) {
        String displayLabel = ModelUtil.searchForExternalizedValue(this, "displayNameID", ThreadResources.getLocale());
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = this.getDisplayName();
        }
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = this.getNameForDisplayLabel();
        }
        if (level == 0) {
            return displayLabel;
        }
        MetaDataDictionary dictionary = MetaDataDictionary.getInstance();
        IElementDefn elementDefn = dictionary.getElement(this.getElementName());
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = elementDefn.getDisplayName();
        }
        if (StringUtil.isBlank(displayLabel)) {
            displayLabel = elementDefn.getName();
        }
        return displayLabel;
    }

    protected String getNameForDisplayLabel() {
        return this.getName();
    }

    protected String limitStringLength(String displayLabel) {
        if (displayLabel == null) {
            return null;
        }
        if (displayLabel.length() > 30) {
            int pos = (displayLabel = displayLabel.substring(0, 30)).lastIndexOf(" ");
            if (pos != -1) {
                displayLabel = displayLabel.substring(0, pos);
            }
            return String.valueOf(displayLabel) + "...";
        }
        return displayLabel;
    }

    public final Object clone() throws CloneNotSupportedException {
        return this.doClone(CopyForPastePolicy.getInstance());
    }

    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        int slotCount;
        DesignElement element = (DesignElement)this.baseClone();
        if (policy != null) {
            policy.execute(this, element);
        }
        if ((slotCount = this.getDefn().getSlotCount()) > 0) {
            element.slots = new ContainerSlot[slotCount];
            int i = 0;
            while (i < slotCount) {
                element.slots[i] = this.slots[i].copy(element, i, policy);
                ++i;
            }
        }
        return element;
    }

    protected final void initSlots() {
        int slotCount = this.getDefn().getSlotCount();
        if (slotCount == 0) {
            return;
        }
        this.slots = new ContainerSlot[slotCount];
        int i = 0;
        while (i < slotCount) {
            SlotDefn slot = (SlotDefn)this.getDefn().getSlot(i);
            this.slots[i] = slot.isMultipleCardinality() ? new MultiElementSlot() : new SingleElementSlot();
            ++i;
        }
    }

    public List getErrors() {
        if (this.errors == null) {
            return new ArrayList();
        }
        return this.errors;
    }

    public String getIdentifier() {
        if (this.getFullName() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDefn().getDisplayName());
            sb.append("(\"");
            sb.append(this.getFullName());
            sb.append("\")");
            return sb.toString();
        }
        if (this instanceof ReportDesign) {
            return "report";
        }
        if (this instanceof Library) {
            return "library";
        }
        if (this.getContainer() == null) {
            return this.getDefn().getName();
        }
        IContainerDefn containerDefn = this.getContainerInfo().getContainerDefn();
        StringBuffer sb = new StringBuffer();
        sb.append(this.getContainer().getIdentifier());
        sb.append(".");
        sb.append(containerDefn.getDisplayName());
        sb.append("[");
        sb.append(this.getContainerInfo().indexOf(this));
        sb.append("]");
        return sb.toString();
    }

    public void setBaseId(long baseId) {
        this.baseId = baseId;
    }

    public long getBaseId() {
        return this.baseId;
    }

    public void clearAllProperties() {
        this.name = null;
        this.extendsRef = null;
        this.propValues.clear();
    }

    public boolean isManagedByNameSpace() {
        if (this.getContainerInfo() == null) {
            return false;
        }
        return this.getContainerInfo().isManagedByNameSpace();
    }

    public final boolean canTransformToTemplate(Module module) {
        if (!ModelUtil.isTemplateSupported(this) || !this.canDrop(module)) {
            return false;
        }
        IElementDefn templateReportItem = MetaDataDictionary.getInstance().getElement("TemplateReportItem");
        IElementDefn templateDataSet = MetaDataDictionary.getInstance().getElement("TemplateDataSet");
        DesignElement container = this.getContainer();
        if (container != null) {
            ContainerContext containerInfor = this.getContainerInfo();
            return containerInfor.canContain(module, templateReportItem) || containerInfor.canContain(module, templateDataSet);
        }
        return true;
    }

    public boolean isTemplateParameterValue(Module module) {
        return this.getTemplateParameterElement(module) != null;
    }

    public void checkSimpleList(Module module, PropertyDefn propDefn, List list, Object toAdd) throws PropertyValueException {
        List errorList = SimpleListValidator.getInstance().validateForAdding(this.getHandle(module), propDefn, list, toAdd);
        if (errorList.size() > 0) {
            throw (PropertyValueException)((Object)errorList.get(0));
        }
    }

    private final Object baseClone() throws CloneNotSupportedException {
        String key;
        DesignElement element = (DesignElement)super.clone();
        element.containerInfo = null;
        element.listeners = null;
        element.derived = null;
        element.cachedDefn = null;
        element.handle = null;
        element.propValues = new HashMap();
        if (this.extendsRef != null) {
            element.extendsRef = (ElementRefValue)this.extendsRef.copy();
        }
        Iterator iter = null;
        if (!this.isVirtualElement() && this.userProperties != null) {
            element.userProperties = new LinkedHashMap();
            iter = this.userProperties.keySet().iterator();
            while (iter.hasNext()) {
                key = iter.next();
                UserPropertyDefn uDefn = (UserPropertyDefn)this.userProperties.get(key);
                element.userProperties.put(key, uDefn.copy());
            }
        }
        iter = this.propValues.keySet().iterator();
        while (iter.hasNext()) {
            Object clonedValue;
            key = (String)iter.next();
            ElementPropertyDefn propDefn = this.getPropertyDefn(key);
            Object value = this.propValues.get(key);
            if (value == null || (clonedValue = ModelUtil.copyValue(propDefn, value)) == null) continue;
            element.propValues.put(key, clonedValue);
            if (!propDefn.isElementType()) continue;
            if (propDefn.isList()) {
                ArrayList values = (ArrayList)clonedValue;
                int i = 0;
                while (i < values.size()) {
                    DesignElement item = (DesignElement)values.get(i);
                    item.setContainer(element, key);
                    ++i;
                }
                continue;
            }
            ((DesignElement)clonedValue).setContainer(element, key);
        }
        return element;
    }

    void setContainer(DesignElement obj, int slot) {
        this.containerInfo = new ContainerContext(obj, slot);
    }

    public void setContainer(DesignElement obj, String propName) {
        this.containerInfo = new ContainerContext(obj, propName);
    }

    public void add(DesignElement content, int slotID) {
        this.getSlot(slotID).add(content);
        content.setContainer(this, slotID);
    }

    public void add(DesignElement content, int slotID, int posn) {
        this.getSlot(slotID).insert(content, posn);
        content.setContainer(this, slotID);
    }

    public void remove(DesignElement content, int slotID) {
        this.getSlot(slotID).remove(content);
        content.containerInfo = null;
    }

    public void add(Module module, DesignElement content, String propName) {
        ElementPropertyDefn defn = this.getPropertyDefn(propName);
        if (defn != null) {
            if (defn.isList()) {
                ArrayList<DesignElement> values = (ArrayList<DesignElement>)this.getLocalProperty(module, propName);
                if (values == null) {
                    values = new ArrayList<DesignElement>();
                }
                if (!values.contains(content)) {
                    values.add(content);
                }
                this.setProperty(propName, values);
                content.setContainer(this, propName);
            } else {
                this.setProperty(defn, (Object)content);
                content.setContainer(this, propName);
            }
        }
    }

    public void add(Module module, DesignElement content, String propName, int posn) {
        ElementPropertyDefn defn = this.getPropertyDefn(propName);
        if (defn != null) {
            if (defn.isList()) {
                ArrayList<DesignElement> values = (ArrayList<DesignElement>)this.getLocalProperty(module, propName);
                if (values == null) {
                    values = new ArrayList<DesignElement>();
                }
                if (!values.contains(content)) {
                    values.add(posn, content);
                }
                this.setProperty(propName, values);
                content.setContainer(this, propName);
            } else {
                if (!$assertionsDisabled && posn != 0) {
                    throw new AssertionError();
                }
                this.setProperty(defn, (Object)content);
                content.setContainer(this, propName);
            }
        }
    }

    public void remove(Module module, DesignElement content, String propName) {
        ElementPropertyDefn defn = this.getPropertyDefn(propName);
        if (defn != null) {
            if (defn.isList()) {
                List values = (List)this.getLocalProperty(module, propName);
                if (values != null) {
                    values.remove(content);
                    content.containerInfo = null;
                }
            } else {
                this.clearProperty(propName);
                content.containerInfo = null;
            }
        }
    }

    public List resolveElementReferenceList(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        if (!$assertionsDisabled && value != null && !(value instanceof List)) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || prop.getTypeCode() == 20 && prop.getSubTypeCode() == 15)) {
            throw new AssertionError();
        }
        if (value == null) {
            return null;
        }
        List valueList = (List)value;
        int i = 0;
        while (i < valueList.size()) {
            ElementRefValue item = (ElementRefValue)valueList.get(i);
            ReferenceValueUtil.resolveElementReference(module, this, prop, item);
            ++i;
        }
        return valueList;
    }

    public ElementRefValue resolveElementReference(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        if (!$assertionsDisabled && value != null && !(value instanceof ElementRefValue)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && prop.getTypeCode() != 15) {
            throw new AssertionError();
        }
        if (!(value instanceof ElementRefValue)) {
            return null;
        }
        if (module == null) {
            return null;
        }
        return ReferenceValueUtil.resolveElementReference(module, this, prop, (ElementRefValue)value);
    }

    public StructRefValue resolveStructReference(Module module, ElementPropertyDefn prop) {
        Object value = this.propValues.get(prop.getName());
        if (!(value instanceof StructRefValue)) {
            return null;
        }
        if (module == null) {
            return null;
        }
        return ReferenceValueUtil.resolveStructReference(module, this, prop, (StructRefValue)value);
    }

    public int getIndex(Module module) {
        ContainerContext containerContext = this.getContainerInfo();
        return containerContext == null ? -1 : containerContext.indexOf(module, this);
    }
}

