/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;

public final class ODAExtensionElementDefn
extends ExtensionElementDefn {
    private List hidePrivateProps = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.metadata.ODAExtensionElementDefn");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ODAExtensionElementDefn(IElementDefn baseElementDefn) {
        if (!$assertionsDisabled && baseElementDefn == null) {
            throw new AssertionError();
        }
        this.name = baseElementDefn.getName();
        this.displayNameKey = (String)baseElementDefn.getDisplayNameKey();
        this.nameConfig.nameOption = 2;
        this.allowExtend = false;
        this.extendsFrom = baseElementDefn.getName();
    }

    public void buildDefinition() throws MetaDataException {
        this.build();
    }

    protected void build() throws MetaDataException {
        if (this.isBuilt) {
            return;
        }
        this.buildDefn();
        this.buildProperties();
        this.buildXmlName();
        this.buildPrivateDriverProperties();
        this.buildTriggerDefnSet();
        this.isBuilt = true;
    }

    private void buildXmlName() {
        String tmpXmlName = null;
        ElementDefn tmpDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("OdaDataSet");
        if (this.isKindOf(tmpDefn)) {
            tmpXmlName = tmpDefn.getXmlName();
        } else {
            tmpDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("OdaDataSource");
            if (this.isKindOf(tmpDefn)) {
                tmpXmlName = tmpDefn.getXmlName();
            }
        }
        this.setXmlName(tmpXmlName);
    }

    private void buildPrivateDriverProperties() {
        if (this.propVisibilites == null) {
            return;
        }
        Iterator propNames = this.propVisibilites.keySet().iterator();
        while (propNames.hasNext()) {
            String visibility;
            String propName = (String)propNames.next();
            IElementPropertyDefn propDefn = this.getProperty(propName);
            if (propDefn.getValueType() != 4 || !"hide".equalsIgnoreCase(visibility = (String)this.propVisibilites.get(propName))) continue;
            if (this.hidePrivateProps == null) {
                this.hidePrivateProps = new ArrayList();
            }
            this.hidePrivateProps.add(this.getProperty(propName));
            this.cachedProperties.remove(propName);
            this.properties.remove(propName);
        }
    }

    public List getODAPrivateDriverPropertyNames() {
        if (this.hidePrivateProps == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> retList = new ArrayList<String>();
        int i = 0;
        while (i < this.hidePrivateProps.size()) {
            IElementPropertyDefn propDefn = (IElementPropertyDefn)this.hidePrivateProps.get(i);
            retList.add(propDefn.getName());
            ++i;
        }
        return Collections.unmodifiableList(retList);
    }
}

