/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.util;

import org.eclipse.birt.report.item.crosstab.core.ICrosstabConstants;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class CrosstabUtil
implements ICrosstabConstants {
    private CrosstabUtil() {
    }

    public static IReportItem getReportItem(DesignElementHandle element) {
        if (!(element instanceof ExtendedItemHandle)) {
            return null;
        }
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)element;
        try {
            return extendedItem.getReportItem();
        }
        catch (ExtendedElementException extendedElementException) {
            return null;
        }
    }

    public static IReportItem getReportItem(DesignElementHandle element, String extensionName) {
        if (!(element instanceof ExtendedItemHandle)) {
            return null;
        }
        if (extensionName == null) {
            throw new IllegalArgumentException("extension name can not be null");
        }
        ExtendedItemHandle extendedItem = (ExtendedItemHandle)element;
        if (extensionName.equals(extendedItem.getExtensionName())) {
            try {
                return extendedItem.getReportItem();
            }
            catch (ExtendedElementException extendedElementException) {
                return null;
            }
        }
        return null;
    }

    public static boolean canContain(CrosstabReportItemHandle crosstab, DimensionHandle dimension) {
        if (crosstab != null && dimension != null) {
            CubeHandle currentCube = crosstab.getCube();
            if (currentCube == null) {
                return true;
            }
            if (dimension.getElement().isContentOf(currentCube.getElement())) {
                DimensionViewHandle dv;
                int i = 0;
                while (i < crosstab.getDimensionCount(0)) {
                    dv = crosstab.getDimension(0, i);
                    if (dv.getCubeDimension() == dimension) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < crosstab.getDimensionCount(1)) {
                    dv = crosstab.getDimension(1, i);
                    if (dv.getCubeDimension() == dimension) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean canContain(CrosstabReportItemHandle crosstab, MeasureHandle measure) {
        if (crosstab != null && measure != null) {
            CubeHandle currentCube = crosstab.getCube();
            if (currentCube == null) {
                return true;
            }
            if (measure.getElement().isContentOf(currentCube.getElement())) {
                int i = 0;
                while (i < crosstab.getMeasureCount()) {
                    MeasureViewHandle mv = crosstab.getMeasure(i);
                    if (mv.getCubeMeasure() == measure) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isAggregationAffectAllMeasures(CrosstabReportItemHandle crosstabItem, int axisType) {
        String measureDirection = crosstabItem.getMeasureDirection();
        return "horizontal".equals(measureDirection) && axisType == 0 || "vertical".equals(measureDirection) && axisType == 1;
    }
}

