/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.hyades.logging.adapter.AdapterException;
import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.AdapterPlugin;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IContext;
import org.eclipse.hyades.logging.adapter.IContextListener;
import org.eclipse.hyades.logging.adapter.IOutputter;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.impl.AdapterContext;
import org.eclipse.hyades.logging.adapter.impl.Component;
import org.eclipse.hyades.logging.adapter.impl.ComponentFactory;
import org.eclipse.hyades.logging.adapter.impl.Context;
import org.eclipse.hyades.logging.adapter.impl.ContextFactory;
import org.eclipse.hyades.logging.adapter.impl.Status;
import org.eclipse.hyades.logging.adapter.internal.util.AdapterConfigValidator;
import org.eclipse.hyades.logging.adapter.parsers.PreparationException;
import org.eclipse.hyades.logging.adapter.util.AdapterUtilities;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Controller
implements Runnable {
    private boolean singleFileInputMode = false;
    private Context[] contexts;
    private Thread[] contextThreads;
    private IOutputter logOutputter = null;
    private String contextConfigurationFile = "SimpleContextConfiguration.xml";
    private String componentConfigurationFile = "SimpleComponentConfigurations.xml";
    private DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private InputStream inContextParams = null;
    private InputStream inAppParams = null;
    private boolean running = false;
    private long sleepTime = 500L;

    public boolean isRunning() {
        return this.running;
    }

    public void start() {
        int i = 1;
        while (i < this.contextThreads.length) {
            if (this.contexts[i] != null) {
                this.contextThreads[i] = new Thread(this.contexts[i]);
                this.contextThreads[i].setName(String.valueOf(this.contexts[i].getName()) + ":" + this.contexts[i].getUniqueID());
                this.contextThreads[i].setDaemon(true);
                this.contextThreads[i].start();
            }
            ++i;
        }
        this.running = true;
    }

    public void stop() {
        if (this.contexts != null && this.contextThreads != null) {
            int contextStopCount = 0;
            int i = this.contexts.length - 1;
            while (i > 0) {
                if (this.contexts[i] != null && this.contextThreads.length > i && this.contextThreads[i] != null && this.contextThreads[i].isAlive()) {
                    this.contexts[i].setStopping(true);
                    ++contextStopCount;
                }
                --i;
            }
            if (contextStopCount > 0) {
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.contexts[0] != null && this.contextThreads.length > 0 && this.contextThreads[0] != null && this.contextThreads[0].isAlive()) {
                this.contexts[0].setStopping(true);
            }
        }
        this.running = false;
    }

    public void hardStop() {
        if (this.contexts != null && this.contextThreads != null) {
            int i = this.contexts.length - 1;
            while (i >= 0) {
                if (this.contexts[i] != null && this.contextThreads.length > i && this.contextThreads[i] != null && this.contextThreads[i].isAlive()) {
                    this.contexts[i].setHardStop();
                }
                --i;
            }
        }
        this.running = false;
    }

    public IContext[] getContexts() {
        return this.contexts;
    }

    public void setContextConfigPath(String config) {
        this.contextConfigurationFile = config;
    }

    public void setComponentConfigPath(String config) {
        this.componentConfigurationFile = config;
    }

    private void validateAdapterConfigurations(InputStream inAppStream, IProcessUnit logger) throws AdapterInvalidConfig {
        AdapterConfigValidator validator = new AdapterConfigValidator(logger);
        try {
            validator.validate(inAppStream);
        }
        catch (AdapterException e) {
            this.log(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void prepareAdapter() throws AdapterException {
        try {
            this.inContextParams = new FileInputStream(this.contextConfigurationFile);
            this.inAppParams = this.singleFileInputMode ? new FileInputStream(this.contextConfigurationFile) : new FileInputStream(this.componentConfigurationFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String filename = null;
            if (this.inContextParams == null) {
                filename = this.contextConfigurationFile;
                throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", filename));
            }
            filename = this.componentConfigurationFile;
            try {
                this.inContextParams.close();
                throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", filename));
            }
            catch (IOException iOException) {}
            throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", filename));
        }
        catch (Throwable e) {
            String filename = null;
            if (this.inContextParams == null) {
                filename = this.contextConfigurationFile;
                throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", filename), e);
            }
            filename = this.componentConfigurationFile;
            try {
                this.inContextParams.close();
                throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", filename), e);
            }
            catch (IOException iOException) {}
            throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Open_ERROR_", filename), e);
        }
        try {
            try {
                Context[] e = this.contexts = this.createContextsAndComponents(this.inContextParams);
                // MONITORENTER : this.contexts
                this.setComponentConfigurations(this.inAppParams);
                // MONITOREXIT : e
                try {
                    this.inContextParams.close();
                    if (!this.singleFileInputMode) {
                        this.inAppParams.close();
                    }
                }
                catch (IOException iOException) {}
                if (AdapterUtilities.isWorkbench()) {
                    try {
                        List contextListeners = AdapterPlugin.getContextListeners();
                        if (contextListeners != null) {
                            Iterator listenerIterator = contextListeners.iterator();
                            while (listenerIterator.hasNext()) {
                                IContextListener listener = (IContextListener)listenerIterator.next();
                                String[] targetContexts = listener.getTargetContextUniqueIds();
                                int j = 0;
                                block29: while (j < targetContexts.length) {
                                    int k = 0;
                                    while (true) {
                                        if (k >= this.contexts.length) {
                                            ++j;
                                            continue block29;
                                        }
                                        if (this.contexts[k].getUniqueID().equals(targetContexts[j])) {
                                            this.contexts[k].setContextListener(listener);
                                        }
                                        ++k;
                                    }
                                }
                            }
                        }
                    }
                    catch (AdapterException e2) {
                        throw e2;
                    }
                    catch (Throwable e3) {
                        throw new AdapterException(Messages.getString("HyadesGAInitialization_GetContextListeners_Failure_ERROR_"), e3);
                    }
                }
                IProcessUnit logger = this.startInternalLoggingContext();
                this.inAppParams = new FileInputStream(this.contextConfigurationFile);
                this.validateAdapterConfigurations(this.inAppParams, logger);
                if (!this.singleFileInputMode) {
                    this.inAppParams = new FileInputStream(this.componentConfigurationFile);
                    this.validateAdapterConfigurations(this.inAppParams, logger);
                }
                int contextsReadyCount = 0;
                AdapterException initException = null;
                Context[] contextArray = this.contexts;
                // MONITORENTER : this.contexts
                int i = 1;
                while (true) {
                    if (i >= this.contexts.length) {
                        // MONITOREXIT : contextArray
                        break;
                    }
                    if (this.contexts[i] != null) {
                        this.contexts[i].setLogger(logger);
                        if (!this.contexts[i].init()) {
                            this.contexts[i] = null;
                            this.log(Messages.getString("HyadesGAContextFatal_ERROR_"));
                        } else {
                            try {
                                this.contexts[i].update();
                                ++contextsReadyCount;
                            }
                            catch (AdapterException e4) {
                                this.contexts[i] = null;
                                this.log(Messages.getString("HyadesGAContextFatal_ERROR_"));
                                initException = e4;
                            }
                        }
                    }
                    ++i;
                }
                if (contextsReadyCount == 0) {
                    if (initException == null) throw new AdapterException(Messages.getString("HyadesGAContextFatal_ERROR_"));
                    throw initException;
                }
            }
            catch (Throwable e) {
                String errorMsg = e.getMessage();
                if (errorMsg != null) throw new AdapterException(errorMsg);
                errorMsg = e.toString();
                throw new AdapterException(errorMsg);
            }
            Object var7_19 = null;
        }
        catch (Throwable throwable) {
            Object var7_18 = null;
            try {
                if (this.inAppParams != null) {
                    this.inAppParams.close();
                }
                if (this.inContextParams == null) throw throwable;
                this.inContextParams.close();
                throw throwable;
            }
            catch (IOException e) {
                this.log(e.toString());
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            this.log(e.toString());
            return;
        }
        if (this.inAppParams != null) {
            this.inAppParams.close();
        }
        if (this.inContextParams == null) return;
        this.inContextParams.close();
    }

    private Context[] createContextsAndComponents(InputStream inContextStream) throws PreparationException {
        Document doc = null;
        Context[] contexts = null;
        try {
            int i;
            NodeList children;
            Node contextsElement;
            doc = this.docFactory.newDocumentBuilder().parse(inContextStream);
            Element loggingContext = doc.createElement("hga:Context");
            loggingContext.setAttribute("description", "Context instance for the current component");
            loggingContext.setAttribute("executableClass", "org.eclipse.hyades.logging.adapter.impl.AdapterContext");
            loggingContext.setAttribute("implementationCreationDate", "Fri Jan 09 15:27:17 EST 2004");
            loggingContext.setAttribute("loggingLevel", "60");
            loggingContext.setAttribute("name", "AdapterContext");
            loggingContext.setAttribute("role", "context");
            loggingContext.setAttribute("roleCreationDate", "Fri Jan 09 15:27:17 EST 2004");
            loggingContext.setAttribute("uniqueID", "NB1F4ED002DA11D8A519FBE7C98C2F53");
            Element loggingSensor = doc.createElement("hga:Component");
            loggingSensor.setAttribute("description", "Adapter logging sensor");
            loggingSensor.setAttribute("executableClass", "org.eclipse.hyades.logging.adapter.internal.util.AdapterSensor");
            loggingSensor.setAttribute("implementationCreationDate", "Fri Jan 09 15:27:17 EST 2004");
            if (this.logOutputter != null) {
                loggingSensor.setAttribute("loggingLevel", "30");
            } else {
                loggingSensor.setAttribute("loggingLevel", "0");
            }
            loggingSensor.setAttribute("name", "AdapterSensor");
            loggingSensor.setAttribute("role", "sensor");
            loggingSensor.setAttribute("roleCreationDate", "Fri Jan 09 15:27:17 EST 2004");
            loggingSensor.setAttribute("uniqueID", "NF991E0004FF11D8930381B6A308BEB5");
            loggingContext.appendChild(loggingSensor);
            Element loggingOutputter = doc.createElement("hga:Component");
            loggingOutputter.setAttribute("description", "Adapter logging outputter");
            loggingOutputter.setAttribute("implementationCreationDate", "Fri Jan 09 15:27:17 EST 2004");
            loggingOutputter.setAttribute("implementationVersion", "");
            loggingOutputter.setAttribute("implementationVersionDescription", "");
            loggingOutputter.setAttribute("role", "outputter");
            loggingOutputter.setAttribute("roleCreationDate", "Fri Jan 09 15:27:17 EST 2004");
            loggingOutputter.setAttribute("uniqueID", "N5F286A002DA11D8BC799C6AF4352915");
            if (this.logOutputter != null) {
                loggingOutputter.setAttribute("loggingLevel", "30");
                loggingOutputter.setAttribute("executableClass", this.logOutputter.getClass().getName());
                loggingOutputter.setAttribute("name", "AdapterLogOutputter");
            } else if (AdapterUtilities.isWorkbench()) {
                loggingOutputter.setAttribute("loggingLevel", "10");
                loggingOutputter.setAttribute("executableClass", "org.eclipse.hyades.logging.adapter.internal.util.GlaTaskOutputter");
                loggingOutputter.setAttribute("name", "CBEEclipseProblemsViewOutputter");
            } else {
                loggingOutputter.setAttribute("loggingLevel", "30");
                loggingOutputter.setAttribute("executableClass", "org.eclipse.hyades.logging.adapter.internal.util.AdapterLogFileOutputter");
                loggingOutputter.setAttribute("name", "AdapterLogFileOutputter");
            }
            loggingContext.appendChild(loggingOutputter);
            NodeList contextsNodeList = doc.getElementsByTagName("hga:Contexts");
            if (contextsNodeList.getLength() == 0) {
                contextsElement = doc.createElement("hga:Contexts");
                children = contextsElement.getChildNodes();
                i = 0;
                while (i < children.getLength()) {
                    if (children.item(i).getNodeType() == 1) {
                        contextsElement.insertBefore(loggingContext, children.item(i));
                        break;
                    }
                    ++i;
                }
                doc.getDocumentElement().appendChild(contextsElement);
            } else {
                contextsElement = contextsNodeList.item(0);
                children = contextsElement.getChildNodes();
                i = 0;
                while (i < children.getLength()) {
                    if (children.item(i).getNodeType() == 1) {
                        contextsElement.insertBefore(loggingContext, children.item(i));
                        break;
                    }
                    ++i;
                }
                doc.getDocumentElement().appendChild(contextsElement);
            }
            try {
                NodeList contextList = doc.getElementsByTagName("hga:Context");
                NodeList tempInstanceList = doc.getElementsByTagName("cc:ContextInstance");
                this.singleFileInputMode = tempInstanceList.getLength() > 0;
                int count = contextList.getLength();
                contexts = new Context[count];
                int j = 0;
                Element element = null;
                Context context = null;
                Component component = null;
                int i2 = 0;
                while (i2 < count) {
                    element = (Element)contextList.item(i2);
                    context = ContextFactory.buildContext(element.getAttribute("executableClass"), element.getAttribute("uniqueID"), element.getAttribute("name"));
                    context.setContextConfiguration(element);
                    NodeList componentList = element.getElementsByTagName("hga:Component");
                    IComponent[] compArray = null;
                    int componentCount = componentList.getLength();
                    compArray = new IComponent[componentCount];
                    int k = 0;
                    int l = 0;
                    while (k < componentCount) {
                        element = (Element)componentList.item(k);
                        if (i2 == 0 && k == 1 && this.logOutputter != null) {
                            component = (Component)((Object)this.logOutputter);
                            component.setName(element.getAttribute("name"));
                            component.setUniqueID(element.getAttribute("uniqueID"));
                            component.setExecutableClassName(element.getAttribute("executableClass"));
                        } else {
                            component = ComponentFactory.buildComponent(element.getAttribute("executableClass"), element.getAttribute("uniqueID"), element.getAttribute("name"));
                        }
                        component.setContextConfiguration(element);
                        compArray[l++] = component;
                        ++k;
                    }
                    context.setComponents(compArray);
                    contexts[j++] = context;
                    ++i2;
                }
            }
            catch (PreparationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PreparationException(Messages.getString("HyadesGAInitialization_ContextConfiguration_Failure_ERROR_", this.contextConfigurationFile), e);
            }
        }
        catch (SAXException e) {
            throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", this.contextConfigurationFile), e);
        }
        catch (ParserConfigurationException e) {
            throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", this.contextConfigurationFile), e);
        }
        catch (IOException e) {
            throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", this.contextConfigurationFile), e);
        }
        return contexts;
    }

    private void setComponentConfigurations(InputStream inAppStream) throws AdapterInvalidConfig, PreparationException {
        Document doc = null;
        try {
            Node loggerConfigurationInstance;
            Element loggingOutputterInstance;
            doc = this.docFactory.newDocumentBuilder().parse(inAppStream);
            Element loggingSensorInstance = doc.createElement("cc:Sensor");
            loggingSensorInstance.setAttribute("description", "An adapter CBE sensor");
            loggingSensorInstance.setAttribute("maximumBlocking", "5");
            loggingSensorInstance.setAttribute("uniqueID", "NF991E0004FF11D8930381B6A308BEB5");
            Element loggerContextInstance = doc.createElement("cc:ContextInstance");
            loggerContextInstance.setAttribute("description", "Context instance for the current component");
            loggerContextInstance.setAttribute("continuousOperation", "true");
            loggerContextInstance.setAttribute("maximumIdleTime", "600000");
            loggerContextInstance.setAttribute("pauseInterval", "10");
            loggerContextInstance.setAttribute("uniqueID", "NB1F4ED002DA11D8A519FBE7C98C2F53");
            loggerContextInstance.appendChild(loggingSensorInstance);
            if (this.logOutputter != null) {
                loggingOutputterInstance = doc.createElement("cc:Outputter");
                loggingOutputterInstance.setAttribute("description", "Adapter log outputter");
                loggingOutputterInstance.setAttribute("uniqueID", "N5F286A002DA11D8BC799C6AF4352915");
                loggerContextInstance.appendChild(loggingOutputterInstance);
            } else if (AdapterUtilities.isWorkbench()) {
                loggingOutputterInstance = doc.createElement("cc:Outputter");
                loggingOutputterInstance.setAttribute("description", "Eclipse error dialog outputter");
                loggingOutputterInstance.setAttribute("uniqueID", "N5F286A002DA11D8BC799C6AF4352915");
                Element resourcePathProperty = doc.createElement("pu:Property");
                resourcePathProperty.setAttribute("propertyName", "resourceName");
                resourcePathProperty.setAttribute("propertyValue", this.contextConfigurationFile);
                loggingOutputterInstance.appendChild(resourcePathProperty);
                loggerContextInstance.appendChild(loggingOutputterInstance);
            } else {
                loggingOutputterInstance = doc.createElement("cc:Outputter");
                loggingOutputterInstance.setAttribute("description", "Single file outputter");
                loggingOutputterInstance.setAttribute("uniqueID", "N5F286A002DA11D8BC799C6AF4352915");
                Element outputterProperty = doc.createElement("pu:Property");
                outputterProperty.setAttribute("propertyValue", ".");
                outputterProperty.setAttribute("propertyName", "directory");
                loggingOutputterInstance.appendChild(outputterProperty);
                outputterProperty = doc.createElement("pu:Property");
                outputterProperty.setAttribute("propertyValue", "hgla.log");
                outputterProperty.setAttribute("propertyName", "fileName");
                loggingOutputterInstance.appendChild(outputterProperty);
                loggerContextInstance.appendChild(loggingOutputterInstance);
            }
            NodeList configurationNodeList = doc.getElementsByTagName("cc:Configuration");
            if (configurationNodeList.getLength() == 0) {
                loggerConfigurationInstance = doc.createElement("cc:Configuration");
                loggerConfigurationInstance.setAttribute("description", "The component level configurations for this adapter");
                loggerConfigurationInstance.setAttribute("uniqueID", "N06FBD3004FF11D8BCF4CFA9EA8F31E7");
                loggerConfigurationInstance.appendChild(loggerContextInstance);
                doc.getDocumentElement().appendChild(loggerConfigurationInstance);
            } else {
                loggerConfigurationInstance = configurationNodeList.item(0);
                loggerConfigurationInstance.appendChild(loggerContextInstance);
                doc.getDocumentElement().appendChild(loggerConfigurationInstance);
            }
            try {
                NodeList contextInstanceList = doc.getElementsByTagName("cc:ContextInstance");
                int contextInstanceCount = contextInstanceList.getLength();
                int i = 0;
                while (i < contextInstanceCount) {
                    try {
                        Element contextElement = (Element)contextInstanceList.item(i);
                        String contextInstanceID = contextElement.getAttribute("uniqueID");
                        int contextCount = this.contexts.length;
                        if (contextInstanceCount != contextCount) {
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextConfigurationErrorContextCountMismatchFatal_ERROR_"));
                        }
                        boolean contextFound = false;
                        int j = 0;
                        while (j < contextCount) {
                            if (this.contexts[j].getUniqueID().equals(contextInstanceID)) {
                                this.contexts[j].setConfiguration(contextElement);
                                contextFound = true;
                                NodeList componentInstanceList = contextElement.getChildNodes();
                                int numberOfComponentInstances = componentInstanceList.getLength();
                                IComponent[] components = this.contexts[j].getComponents();
                                int componentCount = components.length;
                                int componentInstanceCount = 0;
                                int k = 0;
                                while (k < numberOfComponentInstances) {
                                    if (componentInstanceList.item(k).getNodeType() == 1) {
                                        Element componentElement = (Element)componentInstanceList.item(k);
                                        String componentInstanceID = componentElement.getAttribute("uniqueID");
                                        boolean componentFound = false;
                                        ++componentInstanceCount;
                                        int l = 0;
                                        while (l < componentCount) {
                                            if (components[l].getUniqueID().equals(componentInstanceID)) {
                                                components[l].setConfiguration(componentElement);
                                                componentFound = true;
                                                if (!componentElement.getNodeName().equals("fmt:Formatter") || this.logOutputter != null || !AdapterUtilities.isWorkbench()) break;
                                                componentElement.setAttribute("test", "true");
                                                break;
                                            }
                                            ++l;
                                        }
                                        if (!componentFound) {
                                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorComponentIdNotFoundFatal_ERROR_", componentInstanceID, this.contexts[j].getUniqueID()));
                                        }
                                    }
                                    ++k;
                                }
                                if (componentInstanceCount == componentCount) break;
                                throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorComponentMismatchFatal_ERROR_", this.contexts[j].getUniqueID()));
                            }
                            ++j;
                        }
                        if (!contextFound) {
                            throw new AdapterInvalidConfig(Messages.getString("HyadesGAContextInstanceConfigurationErrorContextIdNotFoundFatal_ERROR_", contextInstanceID));
                        }
                    }
                    catch (AdapterInvalidConfig e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new PreparationException(Messages.getString("HyadesGAInitialization_ContextInstanceConfiguration_Failure_ERROR_", this.componentConfigurationFile), e);
                    }
                    ++i;
                }
            }
            catch (AdapterInvalidConfig e) {
                throw e;
            }
            catch (Exception e) {
                throw new PreparationException(Messages.getString("HyadesGAInitialization_ContextInstanceConfiguration_Failure_ERROR_", this.componentConfigurationFile), e);
            }
        }
        catch (SAXException e) {
            throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", this.componentConfigurationFile), e);
        }
        catch (ParserConfigurationException e) {
            throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", this.componentConfigurationFile), e);
        }
        catch (IOException e) {
            throw new PreparationException(Messages.getString("HyadesGA_CBE_Adapter_Config_File_Parse_ERROR_", this.componentConfigurationFile), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.start();
        while (this.isRunning()) {
            Controller controller = this;
            synchronized (controller) {
                try {
                    this.wait(this.sleepTime);
                }
                catch (Exception e) {
                    this.log(e.toString());
                }
                if (this.areContextsDone()) {
                    this.stop();
                }
            }
        }
    }

    private boolean areContextsDone() {
        if (this.contextThreads != null) {
            int i = 1;
            while (i < this.contextThreads.length) {
                if (this.contextThreads[i] != null && this.contextThreads[i].isAlive() && !(this.contexts[i] instanceof AdapterContext)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void clean() {
        if (this.contexts != null) {
            int i = 0;
            while (i < this.contexts.length) {
                this.contexts[i] = null;
                ++i;
            }
        }
        this.contexts = null;
    }

    private IProcessUnit startInternalLoggingContext() {
        this.contexts[0].init();
        this.contextThreads = new Thread[this.contexts.length];
        try {
            this.contexts[0].update();
            this.contextThreads[0] = new Thread(this.contexts[0]);
            this.contextThreads[0].setName(String.valueOf(this.contexts[0].getName()) + ":" + this.contexts[0].getUniqueID());
            this.contextThreads[0].setDaemon(true);
            this.contextThreads[0].start();
            return (IProcessUnit)this.contexts[0].getComponents()[0];
        }
        catch (AdapterException e) {
            this.log(Messages.getString("HyadesGAInitialization_Internal_Logging_Not_Started_WARN_", e.getLocalizedMessage()));
        }
        catch (Exception e) {
            this.log(Messages.getString("HyadesGAInitialization_Internal_Logging_Not_Started_WARN_", e.toString()));
        }
        return null;
    }

    public void log(String logRecord) {
        if (!AdapterUtilities.isWorkbench()) {
            System.err.println(logRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Status[] getStatus() {
        Status[] statuses = null;
        if (this.contexts == null) return statuses;
        Context[] contextArray = this.contexts;
        synchronized (this.contexts) {
            statuses = new Status[this.contexts.length];
            int i = 0;
            while (i < this.contexts.length) {
                statuses[i] = this.contexts[i] != null ? this.contexts[i].getContextStatus() : null;
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return statuses;
        }
    }

    public IOutputter getLogOutputter() {
        return this.logOutputter;
    }

    public void setLogOutputter(IOutputter logOutputter) {
        this.logOutputter = logOutputter;
    }
}

