/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IResultMetaData;

public class DataIterator
implements IDataIterator {
    protected IExtractionResults results;
    protected IResultIterator iterator;

    DataIterator(IExtractionResults results, IResultIterator iterator) {
        this.results = results;
        this.iterator = iterator;
    }

    public IExtractionResults getQueryResults() {
        return this.results;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        return this.results.getResultMetaData();
    }

    public boolean next() throws BirtException {
        return this.iterator.next();
    }

    public Object getValue(String columnName) throws BirtException {
        return this.iterator.getValue(columnName);
    }

    public Object getValue(int index) throws BirtException {
        IResultMetaData metaData = this.getResultMetaData();
        String columnName = metaData.getColumnName(index);
        return this.iterator.getValue(columnName);
    }

    public void close() {
        try {
            this.iterator.close();
        }
        catch (BirtException birtException) {}
    }
}

