/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.ir.TextItemDesign;

public class TextContent
extends AbstractContent
implements ITextContent {
    protected String text;
    protected static final short FIELD_TEXT = 1100;

    public int getContentType() {
        return 11;
    }

    public TextContent(ReportContent report) {
        super(report);
    }

    public TextContent(IContent content) {
        super(content);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitText(this, value);
    }

    public void setTextKey(String key) {
        if (this.generateBy instanceof TextItemDesign) {
            ((TextItemDesign)this.generateBy).setText(key, this.text);
        }
    }

    public String getTextKey() {
        if (this.generateBy instanceof TextItemDesign) {
            return ((TextItemDesign)this.generateBy).getTextKey();
        }
        return null;
    }

    public void setTextType(String type) {
        if (this.generateBy instanceof TextItemDesign) {
            ((TextItemDesign)this.generateBy).setTextType(type);
        }
    }

    public String getTextType() {
        if (this.generateBy instanceof TextItemDesign) {
            return ((TextItemDesign)this.generateBy).getTextType();
        }
        return null;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.text != null) {
            IOUtil.writeShort((OutputStream)out, (short)1100);
            IOUtil.writeString((DataOutputStream)out, (String)this.text);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 1100: {
                this.text = IOUtil.readString((DataInputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in);
            }
        }
    }

    public boolean needSave() {
        return true;
    }
}

