/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.html;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.emitter.BufferedReportEmitter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.layout.LayoutUtil;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutEmitter;
import org.eclipse.birt.report.engine.presentation.UnresolvedRowHint;

public class HTMLTableLayoutNoNestEmitter
extends HTMLTableLayoutEmitter {
    protected UnresolvedRowHint hint = null;
    protected boolean isFirst = true;
    int nestTableCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.html.HTMLTableLayoutNoNestEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HTMLTableLayoutNoNestEmitter(IContentEmitter emitter, HTMLLayoutContext context) {
        super(emitter, context);
    }

    private boolean isNestTable() {
        return this.nestTableCount > 1;
    }

    public void startTable(ITableContent table) {
        ++this.nestTableCount;
        if (this.cellEmitter != null) {
            this.cellEmitter.startTable(table);
        } else {
            if (!this.isNestTable()) {
                this.initLayout(table);
                if (this.isFirst && this.context != null) {
                    this.hint = this.context.getUnresolvedRowHint(table);
                    this.isFirst = false;
                }
                this.layout.setUnresolvedRowHint(this.hint);
            }
            this.emitter.startTable(table);
        }
    }

    public void resolveAll(boolean finished) {
        this.layout.resolveDropCells(finished);
        this.hint = this.layout.getUnresolvedRow();
        if (this.context != null && this.hint != null) {
            this.context.addUnresolvedRowHint(this.hint);
        }
        this.hasDropCell = this.layout.hasDropCell();
    }

    public void createCell(int colId, int rowSpan, int colSpan, Cell.Content cellContent) {
        this.layout.createCell(colId, rowSpan, colSpan, cellContent);
        if (rowSpan < 0 || rowSpan > 1) {
            this.hasDropCell = true;
        }
    }

    public void endTable(ITableContent table) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTable(table);
        } else {
            if (!this.isNestTable()) {
                this.resolveAll(this.isContentFinished(table));
                this.flush();
            }
            this.emitter.endTable(table);
        }
        --this.nestTableCount;
    }

    public void startTableGroup(ITableGroupContent group) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTableGroup(group);
        } else {
            if (!this.isNestTable()) {
                int groupLevel = group.getGroupLevel();
                this.groupStack.push(new Integer(groupLevel));
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(0, group));
                    return;
                }
            }
            this.emitter.startTableGroup(group);
        }
    }

    public void endTableGroup(ITableGroupContent group) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTableGroup(group);
        } else {
            if (!this.isNestTable()) {
                int groupLevel = this.getGroupLevel();
                this.resolveCellsOfDrop(groupLevel, false, this.isContentFinished(group));
                this.resolveCellsOfDrop(groupLevel, true, this.isContentFinished(group));
                if (!$assertionsDisabled && this.groupStack.isEmpty()) {
                    throw new AssertionError();
                }
                this.groupStack.pop();
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(2, group));
                    return;
                }
                this.flush();
            }
            this.emitter.endTableGroup(group);
        }
    }

    public void startTableBand(ITableBandContent band) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startTableBand(band);
        } else {
            if (!this.isNestTable()) {
                if (band.getBandType() == 4) {
                    int groupLevel = this.getGroupLevel();
                    this.resolveCellsOfDrop(groupLevel, false, true);
                }
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(1, band));
                    return;
                }
                this.flush();
            }
            this.emitter.startTableBand(band);
        }
    }

    public void endTableBand(ITableBandContent band) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endTableBand(band);
        } else {
            if (!this.isNestTable()) {
                if (band.getBandType() == 4) {
                    int groupLevel = this.getGroupLevel();
                    this.resolveCellsOfDrop(groupLevel, true, this.isContentFinished(band));
                }
                if (this.hasDropCell()) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(3, band));
                    return;
                }
                this.flush();
            }
            this.emitter.endTableBand(band);
        }
    }

    public void startRow(IRowContent row) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startRow(row);
        } else {
            boolean isHidden = LayoutUtil.isRowHidden(row, this.emitter.getOutputFormat());
            if (!this.isNestTable()) {
                this.layout.createRow(row, isHidden);
                if (!isHidden) {
                    if (this.hasDropCell()) {
                        this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(4, new HTMLTableLayoutEmitter.StartInfo(this.layout.getRowCount() - 1, 0)));
                        return;
                    }
                    if (this.layout.hasUnResolvedRow() && !LayoutUtil.isRepeatableRow(row)) {
                        this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(4, new HTMLTableLayoutEmitter.StartInfo(this.layout.getRowCount() - 1, 0)));
                        this.hasDropCell = true;
                        return;
                    }
                }
            }
            if (!isHidden) {
                this.emitter.startRow(row);
            }
        }
    }

    public void endRow(IRowContent row) {
        if (this.cellEmitter != null) {
            this.cellEmitter.endRow(row);
        } else {
            boolean isHidden;
            if (!this.isNestTable()) {
                this.layout.endRow(row);
                this.hasDropCell = this.layout.hasDropCell();
                if (this.hasDropCell()) {
                    return;
                }
                if (this.layoutEvents.size() > 0) {
                    this.flush();
                    return;
                }
            }
            if (!(isHidden = LayoutUtil.isRowHidden(row, this.emitter.getOutputFormat()))) {
                this.emitter.endRow(row);
            }
        }
    }

    public void startCell(ICellContent cell) {
        if (this.cellEmitter != null) {
            this.cellEmitter.startCell(cell);
        } else {
            if (!this.isNestTable()) {
                String dropType;
                BufferedReportEmitter buffer = null;
                int colId = cell.getColumn();
                int colSpan = cell.getColSpan();
                int rowSpan = cell.getRowSpan();
                CellDesign cellDesign = (CellDesign)cell.getGenerateBy();
                if (cellDesign != null && (dropType = cellDesign.getDrop()) != null && !"none".equals(dropType)) {
                    rowSpan = this.createDropID(this.getGroupLevel(), dropType);
                }
                if (!(this.hasDropCell() || rowSpan >= 0 && rowSpan <= 1)) {
                    this.layoutEvents.push(new HTMLTableLayoutEmitter.LayoutEvent(5, new HTMLTableLayoutEmitter.StartInfo(this.layout.getRowCount() - 1, colId)));
                }
                if (this.hasDropCell() || rowSpan < 0 || rowSpan > 1) {
                    buffer = new BufferedReportEmitter(this.emitter);
                    this.cellEmitter = buffer;
                }
                this.createCell(colId, rowSpan, colSpan, new HTMLTableLayoutEmitter.CellContent(cell, buffer));
                if (this.hasDropCell()) {
                    return;
                }
            }
            this.emitter.startCell(cell);
        }
    }

    public void endCell(ICellContent cell) {
        if (!this.isNestTable()) {
            if (this.cellEmitter != null) {
                this.cellEmitter = null;
                return;
            }
            this.emitter.endCell(cell);
        } else if (this.cellEmitter != null) {
            this.cellEmitter.endCell(cell);
        } else {
            this.emitter.endCell(cell);
        }
    }
}

