/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.layout.ILineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.ImageArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFImageLM
extends PDFLeafItemLM {
    protected static final int DEFAULT_WIDHT = 212000;
    protected static final int DEFAULT_HEIGHT = 130000;
    protected IImageContent image;
    protected int maxWidth;
    protected ContainerArea root;
    private Dimension instrinsic;
    private static final String BOOKMARK_PREFIX = "javascript:catchBookmark('";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.PDFImageLM");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public PDFImageLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.init();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Dimension getIntrinsicDimension(IImageContent content) throws BadElementException, MalformedURLException, IOException {
        InputStream in;
        Object design;
        Image image = null;
        switch (content.getImageSource()) {
            case 0: {
                design = content.getReportContent().getDesign().getReportDesign();
                URL url = design.findResource(content.getURI(), 1);
                in = url.openStream();
                try {
                    try {
                        byte[] buffer = new byte[in.available()];
                        in.read(buffer);
                        image = Image.getInstance((byte[])buffer);
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    in.close();
                    throw throwable;
                }
            }
            {
                Object var7_11 = null;
            }
            in.close();
            break;
            case 1: 
            case 2: {
                image = Image.getInstance((byte[])content.getData());
                break;
            }
            case 3: {
                image = Image.getInstance((URL)new URL(content.getURI()));
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        if (image == null) {
            return null;
        }
        design = content.getGenerateBy();
        int resolution = 96;
        if (design instanceof ExtendedItemDesign) {
            resolution = 192;
        }
        return new Dimension((int)(image.plainWidth() * 1000.0f / (float)resolution * 72.0f), (int)(image.plainHeight() * 1000.0f / (float)resolution * 72.0f));
    }

    protected Dimension getSpecifiedDimension(IImageContent content) {
        Dimension dim = new Dimension(212000, 130000);
        try {
            this.instrinsic = this.getIntrinsicDimension(content);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage());
        }
        boolean scale = false;
        int specifiedWidth = this.getDimensionValue(content.getWidth());
        int specifiedHeight = this.getDimensionValue(content.getHeight());
        if (this.instrinsic == null) {
            dim.setDimension(specifiedWidth == 0 ? 212000 : specifiedWidth, specifiedHeight == 0 ? 130000 : specifiedHeight);
            return dim;
        }
        if (scale) {
            double ratio = this.instrinsic.getRatio();
            if (specifiedWidth > 0) {
                if (specifiedHeight > 0) {
                    dim.setDimension(specifiedWidth, specifiedHeight);
                } else {
                    dim.setDimension(specifiedWidth, (int)((double)specifiedWidth / ratio));
                }
            } else if (specifiedHeight > 0) {
                dim.setDimension((int)((double)specifiedHeight * ratio), specifiedHeight);
            } else {
                dim.setDimension(this.instrinsic.getWidth(), this.instrinsic.getHeight());
            }
        } else if (specifiedWidth > 0) {
            if (specifiedHeight > 0) {
                dim.setDimension(specifiedWidth, specifiedHeight);
            } else {
                dim.setDimension(specifiedWidth, this.instrinsic.getHeight());
            }
        } else if (specifiedHeight > 0) {
            dim.setDimension(this.instrinsic.getWidth(), specifiedHeight);
        } else {
            dim.setDimension(this.instrinsic.getWidth(), this.instrinsic.getHeight());
        }
        return dim;
    }

    public boolean layoutChildren() {
        if (this.root == null) {
            return false;
        }
        if (!$assertionsDisabled && !(this.parent instanceof ILineStackingLayoutManager)) {
            throw new AssertionError();
        }
        ILineStackingLayoutManager lineParent = (ILineStackingLayoutManager)((Object)this.parent);
        if (this.root.getAllocatedHeight() > lineParent.getCurrentMaxContentHeight()) {
            if (!this.parent.isPageEmpty()) {
                return true;
            }
            this.root.setAllocatedHeight(lineParent.getCurrentMaxContentHeight());
            this.parent.addArea(this.root, false, false);
            return false;
        }
        if (this.parent.getCurrentIP() + this.root.getAllocatedWidth() > this.maxWidth) {
            if (!lineParent.isEmptyLine()) {
                boolean ret = lineParent.endLine();
                if (!$assertionsDisabled && !ret) {
                    throw new AssertionError();
                }
                return this.layoutChildren();
            }
            this.parent.addArea(this.root, false, false);
            return false;
        }
        this.parent.addArea(this.root, false, false);
        return false;
    }

    protected void init() {
        if (!$assertionsDisabled && !(this.content instanceof IImageContent)) {
            throw new AssertionError();
        }
        this.image = (IImageContent)this.content;
        this.maxWidth = this.parent.getCurrentMaxContentWidth();
        Dimension contentDimension = this.getSpecifiedDimension(this.image);
        this.root = (ContainerArea)this.createInlineContainer(this.image, true, true);
        this.validateBoxProperty(this.root.getStyle(), this.maxWidth, this.context.getMaxHeight());
        this.root.setAllocatedWidth(this.maxWidth);
        int maxContentWidth = this.root.getContentWidth();
        if (contentDimension.getWidth() > maxContentWidth) {
            contentDimension.setDimension(maxContentWidth, (int)((double)maxContentWidth / contentDimension.getRatio()));
        }
        ImageArea imageArea = (ImageArea)AreaFactory.createImageArea(this.image);
        imageArea.setWidth(contentDimension.getWidth());
        imageArea.setHeight(contentDimension.getHeight());
        this.root.addChild(imageArea);
        imageArea.setPosition(this.root.getContentX(), this.root.getContentY());
        this.processChartLegend(this.image, imageArea);
        this.root.setContentWidth(contentDimension.getWidth());
        this.root.setContentHeight(Math.min(this.context.getMaxHeight(), contentDimension.getHeight()));
    }

    private void processChartLegend(IImageContent imageContent, IImageArea imageArea) {
        boolean hasImageMap;
        Object imageMapObject = imageContent.getImageMap();
        boolean bl = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
        if (hasImageMap) {
            this.createImageMap((String)imageMapObject, imageArea);
        }
    }

    private void createImageMap(String imageMapObject, IImageArea imageArea) {
        Pattern pattern = Pattern.compile("<AREA[^<>]*coords=\"([\\d,]*)\" href=\"([^<>\"]*)\" target=\"([^<>\"]*)\"/>");
        Matcher matcher = pattern.matcher(imageMapObject);
        String url = null;
        String targetWindow = null;
        ArrayList<int[]> areas = new ArrayList<int[]>();
        while (matcher.find()) {
            try {
                areas.add(this.getArea(matcher.group(1)));
                if (url == null) {
                    url = matcher.group(2);
                }
                if (targetWindow != null) continue;
                targetWindow = matcher.group(3);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (url == null) {
            return;
        }
        ActionContent link = new ActionContent();
        if (this.isBookmark(url)) {
            String bookmark = this.getBookmark(url);
            link.setBookmark(bookmark);
        } else {
            link.setHyperlink(url, targetWindow);
        }
        this.createImageMaps(areas, imageArea, link);
    }

    private void createImageMaps(ArrayList areas, IImageArea imageArea, IHyperlinkAction link) {
        int i = 0;
        while (i < areas.size()) {
            int[] area = (int[])areas.get(i);
            area = this.getAbsoluteArea(area, imageArea);
            this.createImageMapContainer(area[0], area[1], area[2], area[3], link);
            ++i;
        }
    }

    private void createImageMapContainer(int x, int y, int width, int height, IHyperlinkAction link) {
        ReportContent reportContent = (ReportContent)this.image.getReportContent();
        IContainerContent mapContent = reportContent.createContainerContent();
        mapContent.setHyperlinkAction(link);
        BlockContainerArea area = (BlockContainerArea)AreaFactory.createBlockContainer(mapContent);
        area.setPosition(x, y);
        area.setWidth(width);
        area.setHeight(height);
        this.root.addChild(area);
    }

    private int[] getAbsoluteArea(int[] area, IImageArea imageArea) {
        int i = 0;
        while (i < 4) {
            area[i] = this.getTranslatedLength(area[i]);
            ++i;
        }
        int[] result = new int[4];
        int imageX = imageArea.getX();
        int imageY = imageArea.getY();
        int imageHeight = imageArea.getHeight();
        int imageWidth = imageArea.getWidth();
        int intrinsicWidth = this.instrinsic.getWidth();
        int intrinsicHeight = this.instrinsic.getHeight();
        float ratio = (float)imageWidth / (float)intrinsicWidth;
        result[0] = imageX + (int)((float)area[0] * ratio);
        result[2] = (int)((float)area[2] * ratio);
        ratio = (float)imageHeight / (float)intrinsicHeight;
        result[1] = imageY + (int)((float)area[1] * ratio);
        result[3] = (int)((float)area[3] * ratio);
        return result;
    }

    private int getTranslatedLength(int length) {
        return length * 1000 / 192 * 72;
    }

    private boolean isBookmark(String url) {
        return url.startsWith(BOOKMARK_PREFIX) && url.endsWith("')");
    }

    private String getBookmark(String url) {
        int start = url.indexOf(BOOKMARK_PREFIX) + BOOKMARK_PREFIX.length();
        int end = url.length() - 2;
        return url.substring(start, end);
    }

    private int[] getArea(String string) {
        int[] area;
        String[] rawDatas = string.split(",");
        area = new int[]{Integer.parseInt(rawDatas[0]), Integer.parseInt(rawDatas[1]), Integer.parseInt(rawDatas[4]) - area[0], Integer.parseInt(rawDatas[5]) - area[1]};
        return area;
    }
}

