/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.util;

public class ParameterValueUtil {
    private static final String QUOTE_DELIMITER = "'";
    private static final String DOUBLE_QUOTE_DELIMITER = "\"";
    private static final String ESCAPE_QUOTE_CHAR = "\\";
    private static final String ESCAPED_LITERAL_QUOTE = "\\'";

    public static String toJsExprValue(String literalValue) {
        if (literalValue == null || literalValue.length() == 0) {
            return literalValue;
        }
        StringBuffer value = new StringBuffer(literalValue);
        int index = 0;
        while ((index = value.indexOf(QUOTE_DELIMITER, index)) >= 0) {
            value.insert(index, ESCAPE_QUOTE_CHAR);
            index += 2;
        }
        value.insert(0, QUOTE_DELIMITER);
        value.append(QUOTE_DELIMITER);
        return value.toString();
    }

    public static String toLiteralValue(String jsExprValue) {
        if (!ParameterValueUtil.isQuoted(jsExprValue)) {
            return jsExprValue;
        }
        StringBuffer value = new StringBuffer(jsExprValue);
        value.deleteCharAt(jsExprValue.length() - 1);
        value.deleteCharAt(0);
        int index = 0;
        while ((index = value.indexOf(ESCAPED_LITERAL_QUOTE, index)) >= 0) {
            value.deleteCharAt(index);
            ++index;
        }
        return value.toString();
    }

    public static boolean isQuoted(String jsExprValue) {
        if (jsExprValue == null || jsExprValue.length() == 0) {
            return false;
        }
        boolean isDoubleQuoted = jsExprValue.startsWith(DOUBLE_QUOTE_DELIMITER);
        boolean isSingleQuoted = jsExprValue.startsWith(QUOTE_DELIMITER);
        if (!isDoubleQuoted && !isSingleQuoted) {
            return false;
        }
        if (isDoubleQuoted) {
            return jsExprValue.endsWith(DOUBLE_QUOTE_DELIMITER);
        }
        return jsExprValue.endsWith(QUOTE_DELIMITER);
    }
}

