/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.wpml.EmitterContext;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.emitter.wpml.WpmlWriter;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.w3c.dom.css.CSSValue;
import sun.misc.BASE64Encoder;

public class WordEmitter
extends ContentEmitterAdapter {
    protected static Logger logger;
    protected OutputStream out = null;
    IEmitterServices eservice = null;
    protected ContentEmitterVisitor contentVisitor;
    WpmlWriter writer = null;
    public static final String OUTPUT_FORMAT = "doc";
    private int pageWidth = 0;
    private int pageHeight = 0;
    private int contentHeight = 0;
    private int contentWidth = 0;
    private int headerHeight = 0;
    private int footerHeight = 0;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private int leftMargin = 0;
    private int rightMargin = 0;
    private boolean firstBg = true;
    private String orientation = "portrait";
    private EmitterContext context = null;
    private IPageContent page = null;
    private Stack styles = new Stack();
    private Vector cacheCells = new Vector();
    static final int NORMAL = -1;
    private static int firstPage;
    private static int normalPage;
    private int pageStatus;
    private HashSet marks = new HashSet();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.wpml.WordEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.emitter.wpml.WordEmitter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
        firstPage = 0;
        normalPage = 1;
    }

    public WordEmitter() {
        this.contentVisitor = new ContentEmitterVisitor((IContentEmitter)this);
    }

    public void initialize(IEmitterServices service) {
        Object val;
        this.eservice = service;
        if (service != null) {
            Object fd = this.eservice.getOption("outputFile");
            File file = null;
            if (fd != null) {
                try {
                    file = new File(fd.toString());
                    File parent = file.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    this.out = new BufferedOutputStream(new FileOutputStream(file));
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        if (this.out == null && (val = this.eservice.getOption("outputStream")) != null && val instanceof OutputStream) {
            this.out = (OutputStream)val;
        }
        this.writer = new WpmlWriter(this.out);
        this.context = new EmitterContext();
    }

    public String getOutputFormat() {
        return OUTPUT_FORMAT;
    }

    public void startPage(IPageContent page) {
        if (this.page != null) {
            this.completePrePage(this.page);
            this.pageStatus = normalPage;
            this.context.resetWidth();
        } else {
            this.pageStatus = firstPage;
            this.writer.start();
        }
        this.page = page;
        this.accountPageProp(page);
        this.context.addWidth(this.contentWidth);
        this.writer.startPg();
    }

    public void completePrePage(IPageContent page) {
        if (this.context.isInline()) {
            this.writer.endParagraph();
        }
        this.context.endInline();
        this.writer.startPageBreak();
        this.writeSection(page);
        this.writer.endPageBreak();
        this.writer.endPg();
        this.handlePageBg();
    }

    private void handlePageBg() {
        if (this.firstBg) {
            IStyle style = this.page.getStyle();
            String bgcolor = style.getBackgroundColor();
            String bgimg = style.getBackgroundImage();
            if (bgimg != null) {
                try {
                    File file = new File(bgimg);
                    byte[] img = this.getImage(new FileInputStream(file));
                    String pic2Text = new BASE64Encoder().encode(img);
                    this.writer.writePageBackground("image", pic2Text);
                    this.firstBg = false;
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Can not get background image");
                }
            } else if (bgcolor != null && !"transparent".equalsIgnoreCase(bgcolor)) {
                this.writer.writePageBackground("color", bgcolor);
                this.firstBg = false;
            }
        }
    }

    public void end(IReportContent report) {
        if (this.context.isInline()) {
            this.writer.endParagraph();
        }
        this.context.endInline();
        this.writeSection(this.page);
        this.writer.endPg();
        this.handlePageBg();
        this.writer.end();
    }

    public void writeSection(IPageContent page) {
        this.accountPageProp(page);
        this.writer.startSection();
        if (this.pageStatus == firstPage) {
            this.writeHeaderFooter();
        }
        this.writer.writePgProp(this.pageHeight, this.pageWidth, this.headerHeight, this.footerHeight, this.topMargin, this.bottomMargin, this.leftMargin, this.rightMargin, this.orientation);
        this.writer.endSection();
    }

    public void writeHeaderFooter() {
        SimpleMasterPageDesign master = (SimpleMasterPageDesign)this.page.getReportContent().getDesign().getPageSetup().getMasterPage(0);
        if (!master.isShowHeaderOnFirst()) {
            this.writer.startHeader(true);
        } else {
            this.writer.startHeader(false);
        }
        if (this.page.getPageHeader() != null) {
            this.contentVisitor.visitChildren(this.page.getPageHeader(), null);
        }
        this.writer.endHeader();
        this.writer.startFooter();
        if (this.page.getPageFooter() != null) {
            this.contentVisitor.visitChildren(this.page.getPageFooter(), null);
        }
        this.writer.endFooter();
    }

    public void accountPageProp(IPageContent page) {
        this.pageWidth = WordUtil.convertTo(page.getPageWidth(), 0);
        this.pageHeight = WordUtil.convertTo(page.getPageHeight(), 0);
        this.footerHeight = WordUtil.convertTo(page.getFooterHeight(), 0);
        this.headerHeight = WordUtil.convertTo(page.getHeaderHeight(), 0);
        this.topMargin = WordUtil.convertTo(page.getMarginTop(), 0);
        this.bottomMargin = WordUtil.convertTo(page.getMarginBottom(), 0);
        this.contentHeight = this.pageHeight - this.headerHeight - this.footerHeight - this.topMargin - this.bottomMargin;
        this.leftMargin = WordUtil.convertTo(page.getMarginLeft(), 0);
        this.rightMargin = WordUtil.convertTo(page.getMarginRight(), 0);
        this.contentWidth = this.pageWidth - this.leftMargin - this.rightMargin;
        this.orientation = page.getOrientation();
    }

    public void endCell(ICellContent cell) {
        this.adjustInline();
        this.context.removeWidth();
        this.writer.endTblCell(this.context.needEmptyP());
        this.context.endCell();
    }

    public void endContainer(IContainerContent container) {
        this.adjustInline();
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.writer.endTblCell(this.context.needEmptyP());
        this.context.endCell();
        this.context.addContainer(true);
        this.writer.endTblRow();
        this.writer.endTable();
        this.context.setLast(true);
    }

    public void endContent(IContent content) {
    }

    public void endGroup(IGroupContent group) {
    }

    public void endList(IListContent list) {
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.context.addContainer(true);
        this.writer.endTable();
        this.context.setLast(true);
    }

    public void endListBand(IListBandContent listBand) {
        this.adjustInline();
        this.context.endCell();
        this.writer.endTblCell(true);
        this.writer.endTblRow();
    }

    public void endListGroup(IListGroupContent group) {
    }

    public void endPage(IPageContent page) {
    }

    public void endRow(IRowContent row) {
        if (!this.isHidden((IContent)row)) {
            this.styles.pop();
            int col = this.context.getCurrentTblCols().length - 1;
            List spans = this.context.getSpans(col);
            if (spans != null) {
                int i = 0;
                while (i < spans.size()) {
                    this.writer.writeSpanCell((SpanInfo)spans.get(i));
                    ++i;
                }
            }
            this.writer.endTblRow();
        }
    }

    public void endTable(ITableContent table) {
        this.context.addContainer(true);
        if (!this.styles.isEmpty()) {
            this.styles.pop();
        }
        this.writer.endTable();
        this.context.setLast(true);
        this.context.removeTable();
    }

    public void endTableBand(ITableBandContent band) {
    }

    public void endTableGroup(ITableGroupContent group) {
    }

    public void start(IReportContent report) {
    }

    public void startAutoText(IAutoTextContent autoText) {
        this.writeContent(autoText.getType(), null, (IContent)autoText);
    }

    public void startCell(ICellContent cell) {
        this.context.startCell();
        int col = cell.getColumn();
        List spans = this.context.getSpans(col);
        if (spans != null) {
            int i = 0;
            while (i < spans.size()) {
                this.writer.writeSpanCell((SpanInfo)spans.get(i));
                ++i;
            }
        }
        int cs = cell.getColSpan();
        int rs = cell.getRowSpan();
        int cw = this.context.getCellWidth(col, cs);
        IStyle style = this.computeStyle(cell.getComputedStyle());
        if (rs > 1) {
            this.context.addSpan(col, cs, cw, rs, style);
            this.cacheCells.add(new SpanCell(cell, rs, col, cw, style));
        }
        SpanInfo info = null;
        if (cs > 1 || rs > 1) {
            info = new SpanInfo(col, cs, cw, true, style);
        }
        this.writer.startTblCell(cw, style, info);
        this.context.addWidth(WordUtil.getWidth(cw, style));
    }

    private IStyle computeStyle(IStyle style) {
        if (this.styles.size() == 0) {
            return style;
        }
        int i = 0;
        while (i < 57) {
            if (this.isHeritProperty(i) && this.isNullValue(style.getProperty(i))) {
                style.setProperty(i, null);
                int p = this.styles.size() - 1;
                while (p >= 0) {
                    IStyle pstyle = (IStyle)this.styles.get(p);
                    if (!this.isNullValue(pstyle.getProperty(i))) {
                        style.setProperty(i, pstyle.getProperty(i));
                        break;
                    }
                    --p;
                }
            }
            ++i;
        }
        return style;
    }

    private boolean isNullValue(CSSValue value) {
        String[] nullvals = new String[]{"none", "transparent"};
        if (value == null) {
            return true;
        }
        int i = 0;
        while (i < nullvals.length) {
            if (nullvals[i].equalsIgnoreCase(value.getCssText())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isHeritProperty(int p) {
        int[] ignores = new int[]{24, 13, 19, 21, 10, 15, 22, 11, 17, 23, 12, 18};
        int i = 0;
        while (i < ignores.length) {
            if (p == ignores[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void startContainer(IContainerContent container) {
        this.adjustInline();
        this.context.startCell();
        if (this.context.isLastTable()) {
            this.writer.insertHiddenP();
        }
        this.writer.startTable(container.getComputedStyle(), this.context.getCurrentWidth());
        this.writer.startTblRow(-1.0, "normal");
        this.styles.push(container.getComputedStyle());
        IStyle style = this.computeStyle(container.getComputedStyle());
        this.writer.startTblCell(this.context.getCurrentWidth(), style, null);
    }

    public void startContent(IContent content) {
    }

    public void startData(IDataContent data) {
        this.writeContent(-1, data.getText(), (IContent)data);
    }

    public void startForeign(IForeignContent foreign) {
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content convert = new HTML2Content(foreign.getReportContent().getDesign().getReportDesign());
            convert.html2Content(foreign);
            this.context.startCell();
            if (this.context.isLastTable()) {
                this.writer.insertHiddenP();
            }
            this.writer.startTable(foreign.getComputedStyle(), this.context.getCurrentWidth());
            this.writer.startTblRow(-1.0, "normal");
            this.writer.startTblCell(this.context.getCurrentWidth(), foreign.getComputedStyle(), null);
            this.contentVisitor.visitChildren((IContent)foreign, null);
            this.adjustInline();
            this.writer.endTblCell(this.context.needEmptyP());
            this.context.endCell();
            this.writer.endTblRow();
            this.writer.endTable();
            this.context.setLast(true);
            this.context.addContainer(true);
        } else {
            this.writeContent(-1, foreign.getRawValue().toString(), (IContent)foreign);
        }
    }

    public void startGroup(IGroupContent group) {
    }

    public void startImage(IImageContent image) {
        this.adjustInline();
        byte[] data = this.parseImage(image);
        if (data == null) {
            return;
        }
        int defaultW = 0;
        int defaultH = 0;
        try {
            BufferedImage i = ImageIO.read(new ByteArrayInputStream(data));
            defaultW = ((Image)i).getWidth(null);
            defaultH = ((Image)i).getHeight(null);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        double height = WordUtil.convertImageSize(image.getHeight(), defaultH);
        double width = WordUtil.convertImageSize(image.getWidth(), defaultW);
        double originalRatio = height / width;
        double cellWidth = WordUtil.twipToPt(this.context.getCurrentWidth());
        if (width > cellWidth) {
            width = cellWidth;
            height = (int)(width * originalRatio);
        }
        String pic2Text = new BASE64Encoder().encode(data);
        this.writeBookmark((IContent)image);
        this.writeToc((IContent)image);
        HyperlinkInfo hyper = this.getHyperlink((IContent)image);
        this.writer.drawImage(pic2Text, height, width, hyper, image.getComputedStyle());
    }

    public void startLabel(ILabelContent label) {
        String txt = label.getText() == null ? label.getLabelText() : label.getText();
        txt = txt == null ? "" : txt;
        this.writeContent(-1, txt, (IContent)label);
    }

    private Object getReportContext() {
        if (this.eservice != null) {
            return this.eservice.getReportContext();
        }
        return null;
    }

    public void startList(IListContent list) {
        this.adjustInline();
        this.styles.push(list.getComputedStyle());
        this.writeBookmark((IContent)list);
        this.writeToc((IContent)list);
        if (this.context.isLastTable()) {
            this.writer.insertHiddenP();
        }
        this.writer.startTable(list.getComputedStyle(), this.context.getCurrentWidth());
    }

    public void startListBand(IListBandContent listBand) {
        this.context.startCell();
        this.writer.startTblRow(-1.0, "normal");
        IStyle style = this.computeStyle(listBand.getComputedStyle());
        this.writer.startTblCell(this.context.getCurrentWidth(), style, null);
    }

    public void startListGroup(IListGroupContent group) {
    }

    public void startRow(IRowContent row) {
        if (!this.isHidden((IContent)row)) {
            String type = "normal";
            this.styles.push(row.getComputedStyle());
            if (row.getBand() != null && row.getBand().getBandType() == 1) {
                type = "header";
            }
            double height = WordUtil.convertTo(row.getHeight());
            this.writer.startTblRow(height, type);
            this.context.newRow();
        }
    }

    protected boolean isHidden(IContent content) {
        if (content != null) {
            IStyle style = content.getStyle();
            if (!IStyle.NONE_VALUE.equals(style.getProperty(33))) {
                return this.isHiddenByVisibility(content);
            }
            return true;
        }
        return false;
    }

    private boolean isHiddenByVisibility(IContent content) {
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        IStyle style = content.getStyle();
        String formats = style.getVisibleFormat();
        return this.contains(formats, OUTPUT_FORMAT);
    }

    private boolean contains(String formats, String format) {
        return formats != null && (formats.indexOf("viewer") >= 0 || formats.indexOf("all") >= 0 || formats.indexOf(format) >= 0);
    }

    public void startTable(ITableContent table) {
        this.adjustInline();
        this.styles.push(table.getComputedStyle());
        IStyle style = table.getComputedStyle();
        this.writeBookmark((IContent)table);
        this.writeToc((IContent)table);
        if (this.context.isLastTable()) {
            this.writer.insertHiddenP();
        }
        this.writer.startTable(table.getComputedStyle(), this.context.getCurrentWidth());
        int tblWid = WordUtil.convertTo(table.getWidth(), this.context.getCurrentWidth());
        int colCount = table.getColumnCount();
        int[] cols = new int[colCount];
        int count = 0;
        int total = 0;
        int i = 0;
        while (i < colCount) {
            IColumn col = table.getColumn(i);
            if (col.getWidth() == null) {
                cols[i] = -1;
                ++count;
            } else {
                cols[i] = WordUtil.convertTo(col.getWidth(), tblWid);
                total += cols[i];
            }
            ++i;
        }
        i = 0;
        while (i < cols.length) {
            if (cols[i] == -1) {
                cols[i] = (tblWid - total) / count;
            }
            ++i;
        }
        this.writer.writeCol(cols);
        this.context.addTable(cols, style);
    }

    public void startTableBand(ITableBandContent band) {
    }

    public void startTableGroup(ITableGroupContent group) {
    }

    public void startText(ITextContent text) {
        this.writeContent(-1, text.getText(), (IContent)text);
    }

    private void writeToc(IContent content) {
        Object tocObj = content.getTOC();
        if (tocObj == null) {
            return;
        }
        if (tocObj instanceof String) {
            String toc = (String)tocObj;
            this.writer.writeBookmark(toc);
        }
    }

    private void writeBookmark(IContent content) {
        Object design = content.getGenerateBy();
        if (this.marks.contains(design)) {
            return;
        }
        String bookmark = content.getBookmark();
        if (bookmark == null || bookmark.toLowerCase().indexOf("_toc") > 0) {
            return;
        }
        bookmark = bookmark.replaceAll(" ", "_");
        this.writer.writeBookmark(bookmark);
        this.marks.add(design);
    }

    private HyperlinkInfo getHyperlink(IContent content) {
        IHyperlinkAction linkaction = content.getHyperlinkAction();
        HyperlinkInfo hyper = null;
        if (linkaction != null) {
            if (linkaction.getType() == 2) {
                String bookmark = linkaction.getBookmark().replaceAll(" ", "_");
                hyper = new HyperlinkInfo(HyperlinkInfo.BOOKMARK, bookmark);
            } else if (linkaction.getType() == 1) {
                hyper = new HyperlinkInfo(HyperlinkInfo.HYPERLINK, linkaction.getHyperlink());
            } else if (linkaction.getType() == 3) {
                Action act = new Action(linkaction);
                IHTMLActionHandler actionHandler = null;
                Object ac = this.eservice.getOption("actionHandler");
                if (ac != null && ac instanceof IHTMLActionHandler) {
                    actionHandler = (IHTMLActionHandler)ac;
                    String url = actionHandler.getURL((IAction)act, this.getReportContext());
                    hyper = new HyperlinkInfo(HyperlinkInfo.HYPERLINK, url);
                }
            }
        }
        return hyper;
    }

    private byte[] getImage(InputStream is) throws Exception {
        int cnt;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((cnt = is.read(buf)) >= 0) {
            baos.write(buf, 0, cnt);
        }
        is.close();
        baos.close();
        return baos.toByteArray();
    }

    private byte[] parseImage(IImageContent image) {
        byte[] data = null;
        if (image.getData() != null) {
            data = image.getData();
        } else {
            String url = image.getURI();
            if (url == null) {
                return null;
            }
            try {
                URL Ourl = new URL(url);
                return this.getImage(Ourl.openStream());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return data;
    }

    private void writeContent(int type, String txt, IContent content) {
        this.context.addContainer(false);
        boolean inline = false;
        boolean first_inline = false;
        if ("inline".equalsIgnoreCase(content.getComputedStyle().getDisplay())) {
            if (!this.context.isInline()) {
                this.context.startInline();
                first_inline = true;
            }
            inline = true;
        } else if (this.context.isInline()) {
            this.context.endInline();
            this.writer.endParagraph();
        }
        this.writeBookmark(content);
        this.writeToc(content);
        HyperlinkInfo hyper = this.getHyperlink(content);
        this.writer.writeContent(type, txt, content.getComputedStyle(), hyper, inline, first_inline);
        this.context.setLast(false);
    }

    private void adjustInline() {
        if (this.context.isInline()) {
            this.writer.endParagraph();
        }
        this.context.endInline();
    }

    class SpanCell {
        ICellContent cell;
        int rowSpan;
        int col;
        int cw;
        IStyle style;

        SpanCell(ICellContent cell, int rowSpan, int col, int cw, IStyle style) {
            this.cell = cell;
            this.rowSpan = rowSpan;
            this.col = col;
            this.cw = cw;
            this.style = style;
        }
    }
}

