/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import org.eclipse.birt.report.model.api.metadata.IMetaLogger;

class FileMetaLogger
implements IMetaLogger {
    protected static final String DEFAULT_LOG_FILE = "meta.log";
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected Writer writer = null;
    private String fileName = null;
    protected static final SimpleDateFormat df;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.metadata.FileMetaLogger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public FileMetaLogger() {
        this(DEFAULT_LOG_FILE);
    }

    public FileMetaLogger(String fileName) {
        this.fileName = fileName;
    }

    public void log(String message) {
        if (this.canLog()) {
            try {
                Date dateTime = Calendar.getInstance().getTime();
                StringBuffer sb = new StringBuffer();
                sb.append(df.format(dateTime));
                sb.append(" Message [");
                sb.append(String.valueOf(message.toString()) + "]" + "\n");
                this.writer.write(sb.toString());
                this.writer.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public void log(String message, Throwable t) {
        if (this.canLog()) {
            try {
                Date dateTime = Calendar.getInstance().getTime();
                StringBuffer sb = new StringBuffer();
                sb.append(df.format(dateTime));
                sb.append("  Message [");
                sb.append(String.valueOf(message.toString()) + "]" + "\n");
                sb.append("\t\t\t\t\t");
                sb.append(" Exception [");
                sb.append(this.getExceptionString(t));
                sb.append("]\n");
                this.writer.write(sb.toString());
                this.writer.flush();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getExceptionString(Throwable aException) {
        ByteArrayOutputStream outStream = null;
        PrintStream printStream = null;
        try {
            String string;
            try {
                outStream = new ByteArrayOutputStream();
                printStream = new PrintStream(outStream);
                aException.printStackTrace(printStream);
                String stackTrace = outStream.toString();
                printStream.close();
                printStream = null;
                outStream.close();
                outStream = null;
                string = stackTrace;
                Object var5_6 = null;
            }
            catch (Exception exception) {}
            try {
                if (printStream != null) {
                    printStream.close();
                }
                if (outStream == null) return string;
                outStream.close();
                return string;
            }
            catch (IOException iOException) {}
            return string;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            try {}
            catch (IOException iOException) {}
            if (printStream != null) {
                printStream.close();
            }
            if (outStream == null) throw throwable;
            outStream.close();
            throw throwable;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (printStream != null) {
            printStream.close();
        }
        if (outStream == null) return null;
        outStream.close();
        return null;
    }

    protected OutputStreamWriter createWriter(String fileName) throws IOException {
        OutputStreamWriter retWriter;
        block2: {
            retWriter = null;
            try {
                retWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName), false), DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return retWriter;
    }

    protected boolean canLog() {
        if (this.fileName != null && this.writer == null) {
            try {
                this.writer = this.createWriter(this.fileName);
            }
            catch (IOException iOException) {
                this.fileName = null;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (this.writer == null) return;
        try {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.writer = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.writer = null;
            return;
        }
    }
}

