/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.birt.report.model.activity.LayoutRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.UnicodeUtil;
import org.eclipse.birt.report.model.command.ContentElementInfo;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.IReferencableElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.ReferenceableElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ContentElement;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;
import org.eclipse.birt.report.model.util.VersionInfo;
import org.eclipse.birt.report.model.util.VersionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.SAXException;

public class ModelUtil {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.model.util.ModelUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static SharedStyleHandle TransferCssStyleToSharedStyle(Module module, SharedStyleHandle cssStyleHandle) {
        if (cssStyleHandle == null) {
            return null;
        }
        Style newStyle = new Style(cssStyleHandle.getName());
        SharedStyleHandle styleHandle = newStyle.handle(module);
        ModelUtil.duplicateProperties(cssStyleHandle, styleHandle, false);
        return styleHandle;
    }

    public static int getStylePosition(List styleList, String name) {
        int i = 0;
        while (i < styleList.size()) {
            boolean isSelector;
            StyleElement style = (StyleElement)styleList.get(i);
            String styleName = style.getName();
            boolean bl = isSelector = MetaDataDictionary.getInstance().getPredefinedStyle(styleName) != null;
            if (!isSelector && styleName.equals(name) || isSelector && styleName.equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static Object wrapPropertyValue(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ReferenceValue) {
            return ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, module);
        }
        if (value instanceof List && defn != null && defn.getSubTypeCode() == 20) {
            List valueList = (List)value;
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < valueList.size()) {
                ElementRefValue item = (ElementRefValue)valueList.get(i);
                names.add(ReferenceValueUtil.needTheNamespacePrefix(item, module));
                ++i;
            }
            return names;
        }
        if (defn != null && defn.isElementType()) {
            if (value instanceof DesignElement) {
                return ((DesignElement)value).getHandle(module);
            }
            if (value instanceof List) {
                List items = (List)value;
                ArrayList<DesignElementHandle> handles = new ArrayList<DesignElementHandle>();
                int i = 0;
                while (i < items.size()) {
                    DesignElement item = (DesignElement)items.get(i);
                    handles.add(item.getHandle(module));
                    ++i;
                }
                return handles;
            }
        }
        return value;
    }

    public static void duplicateProperties(DesignElementHandle source, DesignElementHandle destination, boolean onlyFactoryProperty) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && destination == null) {
            throw new AssertionError();
        }
        if (!(source instanceof ReportDesignHandle && destination instanceof LibraryHandle || $assertionsDisabled || destination.getDefn().getName().equalsIgnoreCase(source.getDefn().getName()))) {
            throw new AssertionError();
        }
        if (source.getDefn().allowsUserProperties()) {
            PropertyHandle propHandle = source.getPropertyHandle("userProperties");
            List value = source.getElement().getUserProperties();
            Object valueToSet = null;
            if (propHandle != null) {
                valueToSet = ModelUtil.copyValue(propHandle.getDefn(), value);
            }
            if (valueToSet != null) {
                Iterator iter = ((List)valueToSet).iterator();
                while (iter.hasNext()) {
                    UserPropertyDefn userPropDefn = (UserPropertyDefn)iter.next();
                    destination.getElement().addUserPropertyDefn(userPropDefn);
                }
            }
        }
        if (source.getElement() instanceof IExtendableElement) {
            ModelUtil.duplicateExtensionIdentifier(source.getElement(), destination.getElement(), source.getModule());
        }
        Iterator iter = source.getPropertyIterator();
        while (iter.hasNext()) {
            ElementPropertyDefn propDefn;
            PropertyHandle propHandle = (PropertyHandle)iter.next();
            String propName = propHandle.getDefn().getName();
            if ("style".equals(propName) || "extends".equals(propName) || "userProperties".equals(propName) || "extensionID".equals(propName) || "extensionName".equals(propName) || "refTemplateParameter".equals(propName) || "viewAction".equals(propName) || (propDefn = destination.getElement().getPropertyDefn(propName)) == null || propDefn.getTypeCode() == 23) continue;
            Object value = null;
            if (propHandle.getElement() instanceof GroupElement && ("toc".equals(propName) || "pageBreakAfter".equals(propName) || "pageBreakBefore".equals(propName) || "pageBreakInside".equals(propName))) {
                value = propHandle.getElement().getLocalProperty(propHandle.getModule(), propDefn);
            } else if (onlyFactoryProperty) {
                value = propHandle.getElement().getFactoryProperty(propHandle.getModule(), propDefn);
            } else {
                if ("images".equals(propName)) {
                    Iterator images = source.getPropertyHandle("images").iterator();
                    while (images.hasNext()) {
                        StructureHandle image = (StructureHandle)images.next();
                        try {
                            ElementExportUtil.exportStructure(image, (LibraryHandle)destination, false);
                        }
                        catch (SemanticException semanticException) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                        }
                    }
                    continue;
                }
                value = propHandle.getElement().getStrategy().getPropertyExceptRomDefault(propHandle.getModule(), propHandle.getElement(), propDefn);
            }
            Object valueToSet = ModelUtil.copyValue(propHandle.getDefn(), value);
            destination.getElement().setProperty(propName, valueToSet);
        }
    }

    static void duplicateExtensionIdentifier(DesignElement source, DesignElement destination, Module sourceModule) {
        if (source instanceof IOdaExtendableElementModel) {
            String extensionId = (String)source.getProperty(sourceModule, "extensionID");
            destination.setProperty("extensionID", (Object)extensionId);
        } else if (source instanceof IExtendedItemModel) {
            String extensionId = (String)source.getProperty(sourceModule, "extensionName");
            destination.setProperty("extensionName", (Object)extensionId);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    private static ArrayList cloneStructList(List list) {
        if (list == null) {
            return null;
        }
        ArrayList<IStructure> returnList = new ArrayList<IStructure>();
        int i = 0;
        while (i < list.size()) {
            Object item = list.get(i);
            if (item instanceof IStructure) {
                returnList.add(((IStructure)item).copy());
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            ++i;
        }
        return returnList;
    }

    public static Object copyValue(IPropertyDefn propDefn, Object value) {
        if (value == null || propDefn == null) {
            return null;
        }
        switch (propDefn.getTypeCode()) {
            case 16: {
                if (propDefn.isList()) {
                    return ModelUtil.cloneStructList((List)value);
                }
                return ((Structure)value).copy();
            }
            case 15: 
            case 19: {
                ReferenceValue refValue = (ReferenceValue)value;
                return refValue.copy();
            }
            case 20: {
                return ModelUtil.clonePropertyList((List)value);
            }
            case 23: 
            case 24: {
                if (propDefn.isList()) {
                    return ModelUtil.cloneElementList((List)value);
                }
                return ModelUtil.getCopy((DesignElement)value);
            }
        }
        return value;
    }

    private static Object clonePropertyList(List value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> returnList = new ArrayList<Object>();
        int i = 0;
        while (i < value.size()) {
            Object item = value.get(i);
            if (item instanceof ElementRefValue) {
                returnList.add(((ElementRefValue)item).copy());
            } else {
                returnList.add(item);
            }
            ++i;
        }
        return returnList;
    }

    private static List cloneElementList(List value) {
        if (value == null) {
            return null;
        }
        ArrayList<DesignElement> returnList = new ArrayList<DesignElement>();
        int i = 0;
        while (i < value.size()) {
            DesignElement item = (DesignElement)value.get(i);
            returnList.add(ModelUtil.getCopy(item));
            ++i;
        }
        return returnList;
    }

    public static List filterLayoutTasks(List tasks) {
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>();
        LinkedHashSet<DesignElement> elements = new LinkedHashSet<DesignElement>();
        int i = 0;
        while (i < tasks.size()) {
            DesignElement compoundElement;
            RecordTask task = (RecordTask)tasks.get(i);
            if (task instanceof LayoutRecordTask && !elements.contains(compoundElement = (DesignElement)((LayoutRecordTask)task).getTarget())) {
                retList.add(task);
                elements.add(compoundElement);
            }
            ++i;
        }
        return retList;
    }

    public static Exception getFirstFatalException(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String errorCode;
            XMLParserException parserException;
            Exception ex = (Exception)iter.next();
            if (!(ex instanceof XMLParserException) || !((parserException = (XMLParserException)ex).getException() instanceof LibraryException) || (errorCode = ((LibraryException)((Object)parserException.getException())).getErrorCode()) != "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY" && errorCode != "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE") continue;
            return parserException.getException();
        }
        return null;
    }

    public static String checkUTFSignature(InputStream inputStream, String fileName) throws IOException, SAXException {
        String encoding = UnicodeUtil.checkUTFSignature(inputStream);
        if (encoding != null && !"UTF-8".equals(encoding)) {
            DesignParserException cause = new DesignParserException("Error.DesignParserException.UNSUPPORTED_ENCODING");
            DesignFileException fileException = new DesignFileException(fileName, (Exception)((Object)cause));
            throw new SAXException((Exception)((Object)fileException));
        }
        return encoding;
    }

    public static List sortPropertiesByLocalizedName(List propDefns) {
        ULocale locale = ThreadResources.getLocale();
        Collator collator = Collator.getInstance((ULocale)locale);
        if (Locale.ENGLISH.equals(locale)) {
            collator.setStrength(0);
        }
        final HashMap<PropertyDefn, CollationKey> keysMap = new HashMap<PropertyDefn, CollationKey>();
        int i = 0;
        while (i < propDefns.size()) {
            PropertyDefn propDefn = (PropertyDefn)propDefns.get(i);
            CollationKey key = collator.getCollationKey(propDefn.getDisplayName());
            keysMap.put(propDefn, key);
            ++i;
        }
        Collections.sort(propDefns, new Comparator(){

            public int compare(Object o1, Object o2) {
                PropertyDefn p1 = (PropertyDefn)o1;
                PropertyDefn p2 = (PropertyDefn)o2;
                CollationKey key1 = (CollationKey)keysMap.get(p1);
                CollationKey key2 = (CollationKey)keysMap.get(p2);
                return key1.compareTo(key2);
            }
        });
        return propDefns;
    }

    public static List sortElementsByName(List elements) {
        ArrayList temp = new ArrayList(elements);
        Collections.sort(temp, new Comparator(){

            public int compare(Object o1, Object o2) {
                DesignElementHandle handle1 = (DesignElementHandle)o1;
                DesignElementHandle handle2 = (DesignElementHandle)o2;
                String name1 = handle1.getName();
                String name2 = handle2.getName();
                if (name1 == null) {
                    if (name2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (name2 == null) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        return temp;
    }

    public static void insertCompatibleThemeToLibrary(Library library, Theme theme) {
        if (!$assertionsDisabled && library == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && theme == null) {
            throw new AssertionError();
        }
        String name = theme.getName();
        if (!($assertionsDisabled || !StringUtil.isBlank(name) && ModelMessages.getMessage("Theme.defaultThemeName").equals(name))) {
            throw new AssertionError();
        }
        NameSpace ns = library.getNameHelper().getNameSpace(6);
        if (!$assertionsDisabled && !library.getNameHelper().canContain(6, name)) {
            throw new AssertionError();
        }
        ns.insert(theme);
        library.add(theme, 0);
    }

    public static void reviseNameSpace(Module module, DesignElement content, String nameSpace) {
        Iterator propNames = content.propertyWithLocalValueIterator();
        IElementDefn defn = content.getDefn();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            ElementPropertyDefn propDefn = (ElementPropertyDefn)defn.getProperty(propName);
            ModelUtil.revisePropertyNameSpace(module, content, propDefn, nameSpace);
        }
        LevelContentIterator iter = new LevelContentIterator(module, content, 1);
        while (iter.hasNext()) {
            DesignElement item = (DesignElement)iter.next();
            ModelUtil.reviseNameSpace(module, item, nameSpace);
        }
    }

    public static void revisePropertyNameSpace(Module module, DesignElement content, IElementPropertyDefn propDefn, String nameSpace) {
        if (propDefn == null || content == null) {
            return;
        }
        if (propDefn.getTypeCode() != 15 && propDefn.getTypeCode() != 17) {
            return;
        }
        Object value = content.getLocalProperty(module, (ElementPropertyDefn)propDefn);
        if (value == null) {
            return;
        }
        ReferenceValue refValue = (ReferenceValue)value;
        refValue.setLibraryNamespace(nameSpace);
    }

    public static boolean containElement(Module module, DesignElement element, IElementDefn defn) {
        if (element == null || defn == null) {
            return false;
        }
        ContentIterator iter = new ContentIterator(module, element);
        while (iter.hasNext()) {
            DesignElement e = (DesignElement)iter.next();
            IElementDefn targetDefn = e.getDefn();
            if (!targetDefn.isKindOf(defn)) continue;
            return true;
        }
        return false;
    }

    public static boolean containElement(Module module, DesignElement element, String elementName) {
        IElementDefn defn = MetaDataDictionary.getInstance().getElement(elementName);
        return ModelUtil.containElement(module, element, defn);
    }

    public static DesignElement getCopy(DesignElement element) {
        if (element == null) {
            return null;
        }
        try {
            DesignElement copy = (DesignElement)element.clone();
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static String searchForExternalizedValue(DesignElement element, String propIDName, ULocale locale) {
        if (element == null) {
            return null;
        }
        ElementPropertyDefn defn = element.getPropertyDefn(propIDName);
        if (defn == null) {
            return null;
        }
        String textKey = (String)element.getProperty(element.getRoot(), propIDName);
        if (StringUtil.isBlank(textKey)) {
            return null;
        }
        DesignElement temp = element;
        while (temp != null) {
            String externalizedText = temp.getRoot().getMessage(textKey, locale);
            if (externalizedText != null) {
                return externalizedText;
            }
            if (!defn.canInherit()) {
                return null;
            }
            temp = -1L != temp.getBaseId() ? temp.getVirtualParent() : temp.getExtendsElement();
        }
        return null;
    }

    public static String getExternalizedValue(DesignElement element, String propIDName, String propName, ULocale locale) {
        if (element == null || element.getPropertyDefn(propName) == null || element.getPropertyDefn(propIDName) == null) {
            return null;
        }
        String textKey = ModelUtil.searchForExternalizedValue(element, propIDName, locale);
        if (!StringUtil.isBlank(textKey)) {
            return textKey;
        }
        return element.getStringProperty(element.getRoot(), propName);
    }

    public static String getExternalizedStructValue(Module module, IStructure structure, String propIDName, String propName, ULocale locale) {
        String externalizedText;
        if (structure == null) {
            return null;
        }
        String textKey = (String)structure.getProperty(module, propIDName);
        if (!StringUtil.isBlank(textKey) && !StringUtil.isBlank(externalizedText = module.getMessage(textKey, locale))) {
            return externalizedText;
        }
        return (String)structure.getProperty(module, propName);
    }

    public static boolean hasLibrary(ReportDesignHandle designToExport, LibraryHandle targetLibraryHandle) {
        String reportLocation = targetLibraryHandle.getModule().getLocation();
        List libList = designToExport.getModule().getAllLibraries();
        Iterator libIter = libList.iterator();
        while (libIter.hasNext()) {
            Library library = (Library)libIter.next();
            String libLocation = library.getRoot().getLocation();
            if (!reportLocation.equals(libLocation)) continue;
            return true;
        }
        return false;
    }

    public static List checkVersion(String version) {
        ArrayList<VersionInfo> rtnList = new ArrayList<VersionInfo>();
        int versionNo = -1;
        try {
            versionNo = VersionUtil.parseVersion(version);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        if (versionNo < 0 || versionNo > 3021400) {
            rtnList.add(new VersionInfo(version, 2));
        }
        if (versionNo <= 3000000) {
            rtnList.add(new VersionInfo(version, 1));
        }
        return rtnList;
    }

    public static boolean isTemplateSupported(DesignElement element) {
        if (element instanceof DataSet) {
            return true;
        }
        if (element instanceof ReportItem) {
            IChoiceSet choiceSet = MetaDataDictionary.getInstance().getChoiceSet("templateElementType");
            if (!$assertionsDisabled && choiceSet == null) {
                throw new AssertionError();
            }
            IChoice[] choices = choiceSet.getChoices();
            int i = 0;
            while (i < choices.length) {
                String name = choices[i].getName();
                MetaDataDictionary dd = MetaDataDictionary.getInstance();
                if ("ExtendedItem".equals(name)) {
                    if (element instanceof ExtendedItem && element.getDefn().isKindOf(dd.getElement("ReportItem"))) {
                        return true;
                    }
                } else {
                    IElementDefn defn = MetaDataDictionary.getInstance().getElement(name);
                    if (element.getDefn().isKindOf(defn)) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isValidReferenceForCompoundElement(Module module, DesignElement element) {
        ElementRefValue refValue = (ElementRefValue)element.getLocalProperty(module, "extends");
        if (refValue == null) {
            return true;
        }
        if (element.getDefn().isContainer() && !refValue.isResolved()) {
            return false;
        }
        DesignElement parent = element.getExtendsElement();
        while (parent != null) {
            if (!ModelUtil.isValidReferenceForCompoundElement(parent.getRoot(), parent)) {
                return false;
            }
            parent = parent.getExtendsElement();
        }
        return true;
    }

    public static DesignElement getParent(DesignElement element) {
        DesignElement parent = null;
        parent = element.isVirtualElement() ? element.getVirtualParent() : element.getExtendsElement();
        return parent;
    }

    public static boolean isValidLayout(Module module, DesignElement element) {
        int columnCount;
        if (!(element instanceof ReportItem)) {
            return true;
        }
        if (!element.getDefn().isContainer()) {
            return true;
        }
        if (element instanceof TableItem) {
            return LayoutUtil.isValidLayout((TableItem)element, module);
        }
        return !(element instanceof GridItem) || (columnCount = ((GridItem)element).getColumnCount(module)) != 0;
    }

    public static DesignElement newElement(Module module, String elementTypeName, String name) {
        DesignElement element = ModelUtil.newElement(elementTypeName, name);
        if (element != null && module != null) {
            module.makeUniqueName(element);
        }
        return element;
    }

    public static DesignElement newElement(String elementTypeName, String name) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        String javaClass = elemDefn.getJavaClass();
        if (javaClass == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(javaClass);
            DesignElement element = null;
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz;
                Constructor<?> constructor = c.getConstructor(classArray);
                element = (DesignElement)constructor.newInstance(name);
                return element;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                element = (DesignElement)c.newInstance();
                return element;
            }
        }
        catch (Exception exception) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public static void addElement2NameSpace(Module module, DesignElement element) {
        if (module == null || element == null || !element.isManagedByNameSpace()) {
            return;
        }
        module.makeUniqueName(element);
        int ns = ((ElementDefn)element.getDefn()).getNameSpaceID();
        if (element.getName() != null && ns != -1) {
            new NameExecutor(element).getNameSpace(module).insert(element);
        }
    }

    public static boolean isRecursiveReference(DesignElement reference, IReferencableElement referred) {
        if (reference == referred) {
            return true;
        }
        List backRefs = referred.getClientList();
        ArrayList<DesignElement> referenceElements = new ArrayList<DesignElement>();
        int i = 0;
        while (i < backRefs.size()) {
            BackRef backRef = (BackRef)backRefs.get(i);
            DesignElement tmpElement = backRef.getElement();
            if (tmpElement == reference) {
                return true;
            }
            if (tmpElement instanceof ReferenceableElement) {
                referenceElements.add(tmpElement);
            }
            ++i;
        }
        i = 0;
        while (i < referenceElements.size()) {
            if (ModelUtil.isRecursiveReference(reference, (ReferenceableElement)referenceElements.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static URL getURLPresentation(String filePath) {
        try {
            return new URL(filePath);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                return new File(filePath).toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    public static String toUniversalFileFormat(String filePath) {
        if (StringUtil.isBlank(filePath)) {
            return filePath;
        }
        if (filePath.indexOf(92) == -1) {
            return filePath;
        }
        return filePath.replace('\\', '/');
    }

    public static String getTagByPropertyType(PropertyDefn prop) {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && prop.getTypeCode() == 16) {
            throw new AssertionError();
        }
        switch (prop.getTypeCode()) {
            case 7: {
                return "expression";
            }
            case 12: {
                return "xml-property";
            }
            case 18: {
                return "method";
            }
        }
        if (prop.isEncryptable()) {
            return "encrypted-property";
        }
        return "property";
    }

    public static ContentElementInfo getContentContainer(DesignElement content, PropertyDefn propDefn) {
        Module root = content.getRoot();
        DesignElement tmpElement = content;
        PropertyDefn tmpPropDefn = propDefn;
        ContentElementInfo retTarget = new ContentElementInfo(true);
        while (tmpElement != null && tmpPropDefn != null) {
            List tmplist;
            DesignElement tmpContainer = tmpElement.getContainer();
            if (tmpContainer == null) {
                return null;
            }
            int index = -1;
            if (tmpPropDefn.isList() && (tmplist = (List)tmpContainer.getLocalProperty(root, (ElementPropertyDefn)tmpPropDefn)) != null) {
                index = tmplist.indexOf(tmpElement);
            }
            retTarget.pushStep(tmpPropDefn, index);
            if (tmpPropDefn.getTypeCode() == 24 && !(tmpContainer instanceof ContentElement)) {
                retTarget.setTopElement(tmpContainer);
                return retTarget;
            }
            ContainerContext context = tmpElement.getContainerInfo();
            if (context == null) break;
            context = (tmpElement = tmpElement.getContainer()).getContainerInfo();
            if (context == null) {
                return null;
            }
            tmpContainer = tmpElement.getContainer();
            tmpPropDefn = tmpContainer.getPropertyDefn(context.getPropertyName());
        }
        return null;
    }
}

