/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.LegendLayoutHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Direction;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.LabelImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.emf.common.util.EList;

public final class LegendBuilder
implements IConstants {
    private static final String ELLIPSIS_STRING = "...";
    private Size sz;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Size compute(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc) throws ChartException {
        Legend lg = cm.getLegend();
        LegendData legendData = new LegendData();
        if (!lg.isSetOrientation()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.legend.orientation.horzvert", Messages.getResourceBundle(xs.getULocale()));
        }
        if (!lg.isSetDirection()) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.legend.direction.tblr", Messages.getResourceBundle(xs.getULocale()));
        }
        Orientation orientation = lg.getOrientation();
        Direction direction = lg.getDirection();
        Position lgPosition = lg.getPosition();
        boolean bPaletteByCategory = lg.getItemType().getValue() == 1;
        Label la = LabelImpl.create();
        la.setCaption(TextImpl.copyInstance(lg.getText()));
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        legendData.dSeparatorThickness = lia.getThickness();
        la.getCaption().setValue("X");
        ITextMetrics itm = xs.getTextMetrics(la);
        legendData.dItemHeight = itm.getFullHeight();
        la.getCaption().setValue(ELLIPSIS_STRING);
        itm.reuse(la);
        legendData.dEllipsisWidth = itm.getFullWidth();
        legendData.dScale = (double)xs.getDpiResolution() / 72.0;
        legendData.insCa = ca.getInsets().scaledInstance(legendData.dScale);
        legendData.maxWrappingSize = lg.getWrappingSize() * legendData.dScale;
        legendData.dHorizontalSpacing = 3.0 * legendData.dScale;
        legendData.dVerticalSpacing = 3.0 * legendData.dScale;
        legendData.dSafeSpacing = 3.0 * legendData.dScale;
        legendData.dHorizonalReservedSpace = legendData.insCa.getLeft() + legendData.insCa.getRight() + 3.0 * legendData.dItemHeight / 2.0 + legendData.dHorizontalSpacing;
        legendData.dVerticalReservedSpace = legendData.insCa.getTop() + legendData.insCa.getBottom() + legendData.dVerticalSpacing;
        Block bl = cm.getBlock();
        Bounds boFull = bl.getBounds().scaledInstance(legendData.dScale);
        Insets ins = bl.getInsets().scaledInstance(legendData.dScale);
        Insets lgIns = lg.getInsets().scaledInstance(legendData.dScale);
        boolean titleWPos = false;
        boolean titleHPos = false;
        TitleBlock titleBlock = cm.getTitle();
        Bounds titleBounds = titleBlock.getBounds().scaledInstance(legendData.dScale);
        if (titleBlock.isVisible()) {
            switch (titleBlock.getAnchor().getValue()) {
                case 2: 
                case 6: {
                    titleWPos = true;
                    break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    titleHPos = true;
                }
            }
        }
        legendData.dAvailableWidth = boFull.getWidth() - ins.getLeft() - ins.getRight() - lgIns.getLeft() - lgIns.getRight() - titleBounds.getWidth() * (double)titleWPos;
        legendData.dAvailableHeight = boFull.getHeight() - ins.getTop() - ins.getBottom() - lgIns.getTop() - lgIns.getBottom() - titleBounds.getHeight() * (double)titleHPos;
        double dMaxLegendWidth = boFull.getWidth() / 3.0;
        double dMaxLegendHeight = boFull.getHeight() / 3.0;
        switch (lgPosition.getValue()) {
            case 2: 
            case 3: 
            case 5: {
                if (!(legendData.dAvailableWidth > dMaxLegendWidth)) break;
                legendData.dAvailableWidth = dMaxLegendWidth;
                break;
            }
            case 0: 
            case 1: {
                if (!(legendData.dAvailableHeight > dMaxLegendHeight)) break;
                legendData.dAvailableHeight = dMaxLegendHeight;
            }
        }
        boolean bMinSliceDefined = false;
        if (cm instanceof ChartWithoutAxes) {
            bMinSliceDefined = ((ChartWithoutAxes)cm).isSetMinSlice();
            legendData.sMinSliceLabel = ((ChartWithoutAxes)cm).getMinSliceLabel();
            if (legendData.sMinSliceLabel == null || legendData.sMinSliceLabel.length() == 0) {
                legendData.sMinSliceLabel = "";
            } else {
                legendData.sMinSliceLabel = rtc.externalizedMessage(legendData.sMinSliceLabel);
            }
        }
        if (bMinSliceDefined && bPaletteByCategory && cm instanceof ChartWithoutAxes) {
            this.calculateExtraLegend(cm, rtc, legendData);
        }
        Label lgTitle = lg.getTitle();
        Size titleSize = null;
        BoundingBox titleBounding = null;
        int iTitlePos = -1;
        if (lgTitle != null && lgTitle.isSetVisible() && lgTitle.isVisible()) {
            lgTitle = LabelImpl.copyInstance(lgTitle);
            String sPreviousValue = lgTitle.getCaption().getValue();
            lgTitle.getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
            try {
                titleBounding = Methods.computeBox(xs, 3, lgTitle, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
            }
            iTitlePos = lg.getTitlePosition().getValue();
            if (rtc.isRightToLeft()) {
                if (iTitlePos == 2) {
                    iTitlePos = 3;
                } else if (iTitlePos == 3) {
                    iTitlePos = 2;
                }
            }
            double shadowness = 3.0 * legendData.dScale;
            switch (iTitlePos) {
                case 0: 
                case 1: {
                    LegendData legendData2 = legendData;
                    legendData2.dAvailableHeight = legendData2.dAvailableHeight - (titleBounding.getHeight() + 2.0 * shadowness);
                    break;
                }
                case 2: 
                case 3: {
                    LegendData legendData3 = legendData;
                    legendData3.dAvailableWidth = legendData3.dAvailableWidth - (titleBounding.getWidth() + 2.0 * shadowness);
                }
            }
            titleSize = SizeImpl.create(titleBounding.getWidth() + 2.0 * shadowness, titleBounding.getHeight() + 2.0 * shadowness);
        }
        double[] size = null;
        if (orientation.getValue() == 1) {
            if (bPaletteByCategory) {
                size = this.computeVerticalByCategory(xs, cm, rtc, itm, la, legendData);
            } else if (direction.getValue() == 1) {
                size = this.computeVerticalByTopBottomValue(xs, cm, seda, rtc, itm, la, legendData);
            } else {
                if (direction.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.direction", new Object[]{direction.getName()}, Messages.getResourceBundle(xs.getULocale()));
                size = this.computeVerticalByLeftRightValue(xs, cm, seda, rtc, itm, la, legendData);
            }
        } else {
            if (orientation.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.orientation", new Object[]{orientation}, Messages.getResourceBundle(xs.getULocale()));
            if (bPaletteByCategory) {
                size = this.computeHorizalByCategory(xs, cm, rtc, itm, la, legendData);
            } else if (direction.getValue() == 1) {
                size = this.computeHorizalByTopBottomValue(xs, cm, seda, rtc, itm, la, legendData);
            } else {
                if (direction.getValue() != 0) throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.illegal.rendering.direction", new Object[]{direction}, Messages.getResourceBundle(xs.getULocale()));
                size = this.computeHorizalByLeftRightValue(xs, cm, seda, rtc, itm, la, legendData);
            }
        }
        if (size == null) {
            return SizeImpl.create(0.0, 0.0);
        }
        double dWidth = size[0];
        double dHeight = size[1];
        if (iTitlePos != -1) {
            double shadowness = 3.0 * legendData.dScale;
            switch (iTitlePos) {
                case 0: 
                case 1: {
                    dHeight += titleBounding.getHeight() + 2.0 * shadowness;
                    dWidth = Math.max(dWidth, titleBounding.getWidth() + 2.0 * shadowness);
                    break;
                }
                case 2: 
                case 3: {
                    dWidth += titleBounding.getWidth() + 2.0 * shadowness;
                    dHeight = Math.max(dHeight, titleBounding.getHeight() + 2.0 * shadowness);
                }
            }
        }
        itm.dispose();
        if (rtc != null) {
            List legendItems = legendData.legendItems;
            LegendItemHints[] liha = legendItems.toArray(new LegendItemHints[legendItems.size()]);
            if (liha.length > 1) {
                boolean needInvert = false;
                if (cm instanceof ChartWithAxes) {
                    needInvert = ((ChartWithAxes)cm).isTransposed();
                }
                boolean isStack = true;
                int i = 0;
                while (i < seda.length) {
                    if (isStack) {
                        Iterator iter = seda[i].getSeries().iterator();
                        while (iter.hasNext()) {
                            Series series = (Series)iter.next();
                            if (series.isStacked()) continue;
                            isStack = false;
                            break;
                        }
                    }
                    ++i;
                }
                if (isStack) {
                    boolean bl2 = needInvert = !needInvert;
                }
                if (needInvert) {
                    liha = this.invertLegendItems(liha);
                }
            }
            LegendLayoutHints lilh = new LegendLayoutHints(SizeImpl.create(dWidth, dHeight), titleSize, legendData.bMinSliceApplied, legendData.sMinSliceLabel, liha);
            rtc.setLegendLayoutHints(lilh);
        }
        this.sz = SizeImpl.create(dWidth, dHeight);
        return this.sz;
    }

    private void calculateExtraLegend(Chart cm, RunTimeContext rtc, LegendData legendData) throws ChartException {
        Map renders = rtc.getSeriesRenderers();
        if (renders != null && !((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
            SeriesDefinition sdBase = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
            EList sdA = sdBase.getSeriesDefinitions();
            SeriesDefinition[] sdOrtho = (SeriesDefinition[])sdA.toArray((Object[])new SeriesDefinition[sdA.size()]);
            DataSetIterator dsiOrtho = null;
            boolean started = false;
            int i = 0;
            block2: while (i < sdOrtho.length) {
                List sdRuntimeSA = sdOrtho[i].getRunTimeSeries();
                Series[] alRuntimeSeries = sdRuntimeSA.toArray(new Series[sdRuntimeSA.size()]);
                int j = 0;
                while (j < alRuntimeSeries.length) {
                    try {
                        dsiOrtho = new DataSetIterator(alRuntimeSeries[j].getDataSet());
                        LegendItemRenderingHints lirh = (LegendItemRenderingHints)renders.get(alRuntimeSeries[j]);
                        if (lirh == null) {
                            legendData.filteredMinSliceEntry = null;
                            break block2;
                        }
                        BaseRenderer br = lirh.getRenderer();
                        int[] fsa = br.getFilteredMinSliceEntry(dsiOrtho);
                        if (fsa != null && fsa.length > 0) {
                            legendData.bMinSliceApplied = true;
                        }
                        if (!started) {
                            started = true;
                            legendData.filteredMinSliceEntry = fsa;
                        } else {
                            legendData.filteredMinSliceEntry = LegendBuilder.getDuplicateIndices(fsa, legendData.filteredMinSliceEntry);
                            if (legendData.filteredMinSliceEntry == null || legendData.filteredMinSliceEntry.length == 0) {
                                legendData.filteredMinSliceEntry = null;
                                break block2;
                            }
                        }
                    }
                    catch (Exception ex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, ex);
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (legendData.filteredMinSliceEntry == null) {
            legendData.filteredMinSliceEntry = new int[0];
        }
    }

    private double[] computeVerticalByCategory(IDisplayServer xs, Chart cm, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData) throws ChartException {
        double dColumnWidth;
        double dDeltaHeight;
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dRealHeight = 0.0;
        double dExtraWidth = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        SeriesDefinition sdBase = null;
        if (cm instanceof ChartWithAxes) {
            Axis axPrimaryBase = ((ChartWithAxes)cm).getBaseAxes()[0];
            if (axPrimaryBase.getSeriesDefinitions().isEmpty()) {
                return null;
            }
            sdBase = (SeriesDefinition)axPrimaryBase.getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            if (((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
                return null;
            }
            sdBase = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
        }
        Series seBase = (Series)sdBase.getRunTimeSeries().get(0);
        DataSetIterator dsiBase = null;
        try {
            dsiBase = new DataSetIterator(seBase.getDataSet());
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
        }
        FormatSpecifier fs = null;
        if (sdBase != null) {
            fs = sdBase.getFormatSpecifier();
        }
        int pos = -1;
        while (dsiBase.hasNext()) {
            Object obj = dsiBase.next();
            obj = this.getNonEmptyValue(obj, " ");
            while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                obj = dsiBase.next();
            }
            if (legendData.bMinSliceApplied && Arrays.binarySearch(legendData.filteredMinSliceEntry, ++pos) >= 0) continue;
            String lgtext = String.valueOf(obj);
            if (fs != null) {
                try {
                    lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                }
                catch (ChartException chartException) {}
            }
            la.getCaption().setValue(lgtext);
            itm.reuse(la, legendData.maxWrappingSize);
            BoundingBox bb = null;
            try {
                bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
            }
            double dFWidth = bb.getWidth();
            double dFHeight = bb.getHeight();
            double dExceedingSpace = dExtraWidth + dFWidth + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
            double[] newMetrics = this.checkEllipsisText(dExceedingSpace, dFWidth, xs, itm, la, legendData.dEllipsisWidth, legendData.maxWrappingSize);
            if (newMetrics != null) {
                dFWidth = newMetrics[0];
                dFHeight = newMetrics[1];
            }
            if (dHeight + (dDeltaHeight = legendData.insCa.getTop() + dFHeight + legendData.insCa.getBottom()) > legendData.dAvailableHeight) {
                dColumnWidth = dWidth + legendData.dHorizonalReservedSpace;
                if (dExtraWidth + dColumnWidth > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                    dWidth = -legendData.dHorizonalReservedSpace;
                    columnList.clear();
                    break;
                }
                legendData.legendItems.addAll(columnList);
                columnList.clear();
                dExceedingSpace = (dExtraWidth += dColumnWidth) + dFWidth + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
                newMetrics = this.checkEllipsisText(dExceedingSpace, dFWidth, xs, itm, la, legendData.dEllipsisWidth, legendData.maxWrappingSize);
                if (newMetrics != null) {
                    dFWidth = newMetrics[0];
                    dFHeight = newMetrics[1];
                    dDeltaHeight = legendData.insCa.getTop() + dFHeight + legendData.insCa.getBottom();
                }
                dWidth = dFWidth;
                dRealHeight = Math.max(dRealHeight, dHeight);
                dHeight = dDeltaHeight;
            } else {
                dWidth = Math.max(dFWidth, dWidth);
                dHeight += dDeltaHeight;
            }
            columnList.add(new LegendItemHints(1, new Point(dExtraWidth, dHeight - dDeltaHeight), dFWidth, dFHeight, la.getCaption().getValue(), pos));
        }
        if (legendData.bMinSliceApplied) {
            la.getCaption().setValue(legendData.sMinSliceLabel);
            itm.reuse(la, legendData.maxWrappingSize);
            BoundingBox bb = null;
            try {
                bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
            }
            double dFWidth = bb.getWidth();
            double dFHeight = bb.getHeight();
            double dExceedingSpace = dExtraWidth + dFWidth + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
            double[] newMetrics = this.checkEllipsisText(dExceedingSpace, dFWidth, xs, itm, la, legendData.dEllipsisWidth, legendData.maxWrappingSize);
            if (newMetrics != null) {
                dFWidth = newMetrics[0];
                dFHeight = newMetrics[1];
            }
            if (dHeight + (dDeltaHeight = legendData.insCa.getTop() + dFHeight + legendData.insCa.getBottom()) > legendData.dAvailableHeight) {
                dColumnWidth = dWidth + legendData.dHorizonalReservedSpace;
                if (dExtraWidth + dColumnWidth > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                    dWidth = -legendData.dHorizonalReservedSpace;
                    columnList.clear();
                } else {
                    legendData.legendItems.addAll(columnList);
                    columnList.clear();
                    dExceedingSpace = (dExtraWidth += dColumnWidth) + dFWidth + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
                    newMetrics = this.checkEllipsisText(dExceedingSpace, dFWidth, xs, itm, la, legendData.dEllipsisWidth, legendData.maxWrappingSize);
                    if (newMetrics != null) {
                        dFWidth = newMetrics[0];
                        dFHeight = newMetrics[1];
                        dDeltaHeight = legendData.insCa.getTop() + dFHeight + legendData.insCa.getBottom();
                    }
                    dWidth = dFWidth;
                    dRealHeight = Math.max(dRealHeight, dHeight);
                    dHeight = dDeltaHeight;
                    columnList.add(new LegendItemHints(5, new Point(dExtraWidth, dHeight - dDeltaHeight), dFWidth, dFHeight, la.getCaption().getValue(), dsiBase.size()));
                }
            } else {
                dWidth = Math.max(dFWidth, dWidth);
                columnList.add(new LegendItemHints(5, new Point(dExtraWidth, (dHeight += dDeltaHeight) - dDeltaHeight), dFWidth, dFHeight, la.getCaption().getValue(), dsiBase.size()));
            }
        }
        if (dExtraWidth + (dColumnWidth = dWidth + legendData.dHorizonalReservedSpace) > legendData.dAvailableWidth + legendData.dSafeSpacing) {
            dWidth = -legendData.dHorizonalReservedSpace;
        } else {
            legendData.legendItems.addAll(columnList);
        }
        columnList.clear();
        dHeight = Math.max(dRealHeight, dHeight);
        return new double[]{dWidth += legendData.dHorizonalReservedSpace + dExtraWidth, dHeight};
    }

    private Object getNonEmptyValue(Object value, Object defaultValue) {
        if (value == null || value.toString().length() == 0) {
            return defaultValue;
        }
        return value;
    }

    private double[] computeVerticalByTopBottomValue(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dMaxW = 0.0;
        double dRealHeight = 0.0;
        double dExtraWidth = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        double dSeparatorThickness = legendData.dSeparatorThickness + legendData.dVerticalSpacing;
        int j = 0;
        while (j < seda.length) {
            double dColumnWidth;
            List al = seda[j].getRunTimeSeries();
            FormatSpecifier fs = seda[j].getFormatSpecifier();
            boolean oneVisibleSerie = false;
            int i = 0;
            while (i < al.size()) {
                Series se = (Series)al.get(i);
                if (se.isVisible()) {
                    oneVisibleSerie = true;
                    Object obj = se.getSeriesIdentifier();
                    String lgtext = rtc.externalizedMessage(String.valueOf(obj));
                    if (fs != null) {
                        try {
                            lgtext = ValueFormatter.format(lgtext, fs, rtc.getULocale(), null);
                        }
                        catch (ChartException chartException) {}
                    }
                    la.getCaption().setValue(lgtext);
                    itm.reuse(la, legendData.maxWrappingSize);
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    double dW = bb.getWidth();
                    double dFHeight = bb.getHeight();
                    double dExtraHeight = 0.0;
                    String extraText = null;
                    double dExceedingSpace = dExtraWidth + dW + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
                    double[] newMetrics = this.checkEllipsisText(dExceedingSpace, dW, xs, itm, la, legendData.dEllipsisWidth, legendData.maxWrappingSize);
                    if (newMetrics != null) {
                        dW = newMetrics[0];
                        dFHeight = newMetrics[1];
                    }
                    double dDeltaHeight = legendData.insCa.getTop() + dFHeight + legendData.insCa.getBottom();
                    if (cm.getLegend().isShowValue()) {
                        DataSetIterator dsiBase = null;
                        try {
                            dsiBase = new DataSetIterator(se.getDataSet());
                        }
                        catch (Exception ex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                        }
                        if (dsiBase.hasNext()) {
                            obj = dsiBase.next();
                            while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                                obj = dsiBase.next();
                            }
                            String valueText = String.valueOf(obj);
                            if (fs != null) {
                                try {
                                    lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                                }
                                catch (ChartException chartException) {}
                            }
                            Label seLabel = LabelImpl.copyInstance(se.getLabel());
                            seLabel.getCaption().setValue(valueText);
                            itm.reuse(seLabel);
                            BoundingBox bbV = null;
                            try {
                                bbV = Methods.computeBox(xs, 3, seLabel, 0.0, 0.0);
                            }
                            catch (IllegalArgumentException uiex) {
                                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                            }
                            double dWV = bbV.getWidth();
                            double dFHeightV = bbV.getHeight();
                            double dExceedingSpaceV = dExtraWidth + dWV + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
                            newMetrics = this.checkEllipsisText(dExceedingSpaceV, dWV, xs, itm, seLabel, legendData.dEllipsisWidth, legendData.maxWrappingSize);
                            if (newMetrics != null) {
                                dW = newMetrics[0];
                                dFHeightV = newMetrics[1];
                            }
                            dW = Math.max(dW, itm.getFullWidth());
                            dExtraHeight = Math.max(itm.getFullHeight(), dFHeightV);
                            extraText = seLabel.getCaption().getValue();
                            dDeltaHeight += dExtraHeight + 2.0 * legendData.dScale;
                        }
                    }
                    if (dHeight + dDeltaHeight > legendData.dAvailableHeight) {
                        dColumnWidth = dMaxW + legendData.dHorizonalReservedSpace;
                        if (dExtraWidth + dColumnWidth > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                            dMaxW = -legendData.dHorizonalReservedSpace;
                            columnList.clear();
                            break;
                        }
                        legendData.legendItems.addAll(columnList);
                        columnList.clear();
                        dExceedingSpace = (dExtraWidth += dColumnWidth) + dW + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
                        newMetrics = this.checkEllipsisText(dExceedingSpace, dW, xs, itm, la, legendData.dEllipsisWidth, legendData.maxWrappingSize);
                        if (newMetrics != null) {
                            dW = newMetrics[0];
                            dFHeight = newMetrics[1];
                            dDeltaHeight = legendData.insCa.getTop() + dFHeight + legendData.insCa.getBottom();
                        }
                        dMaxW = dW;
                        dRealHeight = Math.max(dRealHeight, dHeight);
                        dHeight = dDeltaHeight;
                    } else {
                        dMaxW = Math.max(dW, dMaxW);
                        dHeight += dDeltaHeight;
                    }
                    columnList.add(new LegendItemHints(1, new Point(dExtraWidth, dHeight - dDeltaHeight), dW, dFHeight, la.getCaption().getValue(), dExtraHeight, extraText));
                }
                ++i;
            }
            dColumnWidth = dMaxW + legendData.dHorizonalReservedSpace;
            if (dExtraWidth + dColumnWidth > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                dMaxW = -legendData.dHorizonalReservedSpace;
            } else {
                legendData.legendItems.addAll(columnList);
                if (oneVisibleSerie && j < seda.length - 1 && (cm.getLegend().getSeparator() == null || cm.getLegend().getSeparator().isVisible())) {
                    legendData.legendItems.add(new LegendItemHints(2, new Point(dExtraWidth, (dHeight += dSeparatorThickness) - dSeparatorThickness / 2.0), dMaxW + legendData.insCa.getLeft() + legendData.insCa.getRight() + 3.0 * legendData.dItemHeight / 2.0, 0.0, null, 0.0, null));
                }
            }
            columnList.clear();
            ++j;
        }
        dWidth = dMaxW + legendData.dHorizonalReservedSpace + dExtraWidth;
        dHeight = Math.max(dRealHeight, dHeight);
        return new double[]{dWidth, dHeight};
    }

    private double[] computeVerticalByLeftRightValue(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dMaxW = 0.0;
        double dRealHeight = 0.0;
        double dExtraWidth = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        double dSeparatorThickness = legendData.dSeparatorThickness + legendData.dHorizontalSpacing;
        int j = 0;
        while (j < seda.length) {
            double dColumnWidth;
            List al = seda[j].getRunTimeSeries();
            FormatSpecifier fs = seda[j].getFormatSpecifier();
            boolean oneVisibleSerie = false;
            int i = 0;
            while (i < al.size()) {
                Series se = (Series)al.get(i);
                if (se.isVisible()) {
                    oneVisibleSerie = true;
                    Object obj = se.getSeriesIdentifier();
                    String lgtext = rtc.externalizedMessage(String.valueOf(obj));
                    if (fs != null) {
                        try {
                            lgtext = ValueFormatter.format(lgtext, fs, rtc.getULocale(), null);
                        }
                        catch (ChartException chartException) {}
                    }
                    la.getCaption().setValue(lgtext);
                    itm.reuse(la, legendData.maxWrappingSize);
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    double dW = bb.getWidth();
                    double dFHeight = bb.getHeight();
                    double dExtraHeight = 0.0;
                    String extraText = null;
                    double dExceedingSpace = dExtraWidth + dW + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
                    double[] newMetrics = this.checkEllipsisText(dExceedingSpace, dW, xs, itm, la, legendData.dEllipsisWidth, legendData.maxWrappingSize);
                    if (newMetrics != null) {
                        dW = newMetrics[0];
                        dFHeight = newMetrics[1];
                    }
                    double dDeltaHeight = legendData.insCa.getTop() + dFHeight + legendData.insCa.getBottom();
                    if (cm.getLegend().isShowValue()) {
                        DataSetIterator dsiBase = null;
                        try {
                            dsiBase = new DataSetIterator(se.getDataSet());
                        }
                        catch (Exception ex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                        }
                        if (dsiBase.hasNext()) {
                            obj = dsiBase.next();
                            while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                                obj = dsiBase.next();
                            }
                            String valueText = String.valueOf(obj);
                            if (fs != null) {
                                try {
                                    lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                                }
                                catch (ChartException chartException) {}
                            }
                            Label seLabel = LabelImpl.copyInstance(se.getLabel());
                            seLabel.getCaption().setValue(valueText);
                            itm.reuse(seLabel);
                            dW = Math.max(dW, itm.getFullWidth());
                            dExtraHeight = itm.getFullHeight();
                            extraText = seLabel.getCaption().getValue();
                            dDeltaHeight += itm.getFullHeight() + 2.0 * legendData.dScale;
                        }
                    }
                    if (dHeight + dDeltaHeight > legendData.dAvailableHeight) {
                        dColumnWidth = dMaxW + legendData.dHorizonalReservedSpace;
                        if (dExtraWidth + dColumnWidth > legendData.dAvailableWidth + legendData.dSafeSpacing) {
                            dMaxW = -legendData.dHorizonalReservedSpace;
                            columnList.clear();
                            break;
                        }
                        legendData.legendItems.addAll(columnList);
                        columnList.clear();
                        dExceedingSpace = (dExtraWidth += dColumnWidth) + dW + legendData.dHorizonalReservedSpace - legendData.dAvailableWidth - legendData.dSafeSpacing;
                        newMetrics = this.checkEllipsisText(dExceedingSpace, dW, xs, itm, la, legendData.dEllipsisWidth, legendData.maxWrappingSize);
                        if (newMetrics != null) {
                            dW = newMetrics[0];
                            dFHeight = newMetrics[1];
                            dDeltaHeight = legendData.insCa.getTop() + dFHeight + legendData.insCa.getBottom();
                        }
                        dMaxW = dW;
                        dRealHeight = Math.max(dRealHeight, dHeight);
                        dHeight = dDeltaHeight;
                    } else {
                        dMaxW = Math.max(dW, dMaxW);
                        dHeight += dDeltaHeight;
                    }
                    columnList.add(new LegendItemHints(1, new Point(dExtraWidth, dHeight - dDeltaHeight), dW, dFHeight, la.getCaption().getValue(), dExtraHeight, extraText));
                }
                ++i;
            }
            dRealHeight = Math.max(dRealHeight, dHeight);
            dColumnWidth = dMaxW + legendData.dHorizonalReservedSpace;
            if (!(dExtraWidth + dColumnWidth > legendData.dAvailableWidth + legendData.dSafeSpacing)) {
                legendData.legendItems.addAll(columnList);
                if (oneVisibleSerie) {
                    dExtraWidth += dMaxW + legendData.dHorizonalReservedSpace;
                    if (j < seda.length - 1 && (cm.getLegend().getSeparator() == null || cm.getLegend().getSeparator().isVisible())) {
                        legendData.legendItems.add(new LegendItemHints(2, new Point((dExtraWidth += dSeparatorThickness) - dSeparatorThickness / 2.0, 0.0), 0.0, dRealHeight, null, 0.0, null));
                    }
                }
            }
            columnList.clear();
            dMaxW = 0.0;
            dHeight = 0.0;
            ++j;
        }
        dHeight = Math.max(dRealHeight, dHeight);
        return new double[]{dWidth += dExtraWidth, dHeight};
    }

    private double[] computeHorizalByCategory(IDisplayServer xs, Chart cm, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData) throws ChartException {
        double dRowHeight;
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dRealWidth = 0.0;
        double dExtraHeight = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        SeriesDefinition sdBase = null;
        if (cm instanceof ChartWithAxes) {
            Axis axPrimaryBase = ((ChartWithAxes)cm).getBaseAxes()[0];
            if (axPrimaryBase.getSeriesDefinitions().isEmpty()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.base.axis.no.series.definitions", Messages.getResourceBundle(xs.getULocale()));
            }
            sdBase = (SeriesDefinition)axPrimaryBase.getSeriesDefinitions().get(0);
        } else if (cm instanceof ChartWithoutAxes) {
            if (((ChartWithoutAxes)cm).getSeriesDefinitions().isEmpty()) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, "exception.base.axis.no.series.definitions", Messages.getResourceBundle(xs.getULocale()));
            }
            sdBase = (SeriesDefinition)((ChartWithoutAxes)cm).getSeriesDefinitions().get(0);
        }
        Series seBase = (Series)sdBase.getRunTimeSeries().get(0);
        DataSetIterator dsiBase = null;
        try {
            dsiBase = new DataSetIterator(seBase.getDataSet());
        }
        catch (Exception ex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
        }
        FormatSpecifier fs = null;
        if (sdBase != null) {
            fs = sdBase.getFormatSpecifier();
        }
        int pos = -1;
        while (dsiBase.hasNext()) {
            Object obj = dsiBase.next();
            obj = this.getNonEmptyValue(obj, " ");
            while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                obj = dsiBase.next();
            }
            if (legendData.bMinSliceApplied && Arrays.binarySearch(legendData.filteredMinSliceEntry, ++pos) >= 0) continue;
            String lgtext = String.valueOf(obj);
            if (fs != null) {
                try {
                    lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                }
                catch (ChartException chartException) {}
            }
            la.getCaption().setValue(lgtext);
            itm.reuse(la, legendData.maxWrappingSize);
            BoundingBox bb = null;
            try {
                bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
            }
            double dFWidth = bb.getWidth();
            double dFHeight = bb.getHeight();
            double dDeltaWidth = legendData.insCa.getLeft() + dFWidth + 3.0 * legendData.dItemHeight / 2.0 + legendData.insCa.getRight();
            if (dWidth + dDeltaWidth > legendData.dAvailableWidth) {
                dRowHeight = dHeight + legendData.dVerticalReservedSpace;
                if (dExtraHeight + dRowHeight > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                    dHeight = -legendData.dVerticalReservedSpace;
                    columnList.clear();
                    break;
                }
                legendData.legendItems.addAll(columnList);
                columnList.clear();
                dExtraHeight += dRowHeight;
                dHeight = dFHeight;
                dRealWidth = Math.max(dRealWidth, dWidth);
                dWidth = dDeltaWidth;
            } else {
                dHeight = Math.max(dFHeight, dHeight);
                dWidth += dDeltaWidth;
            }
            columnList.add(new LegendItemHints(1, new Point(dWidth - dDeltaWidth, dExtraHeight), dFWidth, dFHeight, la.getCaption().getValue(), pos));
        }
        if (legendData.bMinSliceApplied) {
            la.getCaption().setValue(legendData.sMinSliceLabel);
            itm.reuse(la, legendData.maxWrappingSize);
            BoundingBox bb = null;
            try {
                bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
            }
            catch (IllegalArgumentException uiex) {
                throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
            }
            double dFWidth = bb.getWidth();
            double dFHeight = bb.getHeight();
            double dDeltaWidth = legendData.insCa.getLeft() + dFWidth + 3.0 * legendData.dItemHeight / 2.0 + legendData.insCa.getRight();
            if (dWidth + dDeltaWidth > legendData.dAvailableWidth) {
                dRowHeight = dHeight + legendData.dVerticalReservedSpace;
                if (dExtraHeight + dRowHeight > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                    dHeight = -legendData.dVerticalReservedSpace;
                    columnList.clear();
                } else {
                    legendData.legendItems.addAll(columnList);
                    columnList.clear();
                    dHeight = dFHeight;
                    dRealWidth = Math.max(dRealWidth, dWidth);
                    dWidth = dDeltaWidth;
                    columnList.add(new LegendItemHints(5, new Point(dWidth - dDeltaWidth, dExtraHeight += dRowHeight), dFWidth, dFHeight, la.getCaption().getValue(), dsiBase.size()));
                }
            } else {
                dHeight = Math.max(dFHeight, dHeight);
                columnList.add(new LegendItemHints(5, new Point((dWidth += dDeltaWidth) - dDeltaWidth, dExtraHeight), dFWidth, dFHeight, la.getCaption().getValue(), dsiBase.size()));
            }
        }
        if (dExtraHeight + (dRowHeight = dHeight + legendData.dVerticalReservedSpace) > legendData.dAvailableHeight + legendData.dSafeSpacing) {
            dHeight = -legendData.dVerticalReservedSpace;
        } else {
            legendData.legendItems.addAll(columnList);
        }
        columnList.clear();
        dWidth = Math.max(dWidth, dRealWidth);
        return new double[]{dWidth, dHeight += dExtraHeight + legendData.dVerticalReservedSpace};
    }

    private double[] computeHorizalByTopBottomValue(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dMaxH = 0.0;
        double dRealWidth = 0.0;
        double dExtraHeight = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        LegendData legendData2 = legendData;
        legendData2.dSeparatorThickness = legendData2.dSeparatorThickness + legendData.dVerticalSpacing;
        int j = 0;
        while (j < seda.length) {
            double dRowHeight;
            dWidth = 0.0;
            List al = seda[j].getRunTimeSeries();
            FormatSpecifier fs = seda[j].getFormatSpecifier();
            boolean oneVisibleSerie = false;
            int i = 0;
            while (i < al.size()) {
                Series se = (Series)al.get(i);
                if (se.isVisible()) {
                    double dH;
                    oneVisibleSerie = true;
                    Object obj = se.getSeriesIdentifier();
                    String lgtext = rtc.externalizedMessage(String.valueOf(obj));
                    if (fs != null) {
                        try {
                            lgtext = ValueFormatter.format(lgtext, fs, rtc.getULocale(), null);
                        }
                        catch (ChartException chartException) {}
                    }
                    la.getCaption().setValue(lgtext);
                    itm.reuse(la, legendData.maxWrappingSize);
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    double dFHeight = dH = bb.getHeight();
                    double dFWidth = bb.getWidth();
                    double dEHeight = 0.0;
                    String extraText = null;
                    double dDeltaWidth = legendData.insCa.getLeft() + 3.0 * legendData.dItemHeight / 2.0 + dFWidth + legendData.insCa.getRight() + legendData.dHorizontalSpacing;
                    if (cm.getLegend().isShowValue()) {
                        DataSetIterator dsiBase = null;
                        try {
                            dsiBase = new DataSetIterator(se.getDataSet());
                        }
                        catch (Exception ex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                        }
                        if (dsiBase.hasNext()) {
                            obj = dsiBase.next();
                            while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                                obj = dsiBase.next();
                            }
                            String valueText = String.valueOf(obj);
                            if (fs != null) {
                                try {
                                    lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                                }
                                catch (ChartException chartException) {}
                            }
                            Label seLabel = LabelImpl.copyInstance(se.getLabel());
                            seLabel.getCaption().setValue(valueText);
                            itm.reuse(seLabel);
                            dEHeight = itm.getFullHeight();
                            extraText = seLabel.getCaption().getValue();
                            dH += dEHeight + 2.0 * legendData.dScale;
                            dDeltaWidth = Math.max(dDeltaWidth, itm.getFullWidth());
                        }
                    }
                    if (dWidth + dDeltaWidth > legendData.dAvailableWidth) {
                        dRowHeight = dMaxH + legendData.dVerticalReservedSpace;
                        if (dExtraHeight + dRowHeight > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                            dMaxH = -legendData.dVerticalReservedSpace;
                            columnList.clear();
                            break;
                        }
                        legendData.legendItems.addAll(columnList);
                        columnList.clear();
                        dExtraHeight += dRowHeight;
                        dMaxH = dH;
                        dRealWidth = Math.max(dRealWidth, dWidth);
                        dWidth = dDeltaWidth;
                    } else {
                        dMaxH = Math.max(dH, dMaxH);
                        dWidth += dDeltaWidth;
                    }
                    columnList.add(new LegendItemHints(1, new Point(dWidth - dDeltaWidth, dExtraHeight), dFWidth, dFHeight, la.getCaption().getValue(), dEHeight, extraText));
                }
                ++i;
            }
            dRealWidth = Math.max(dRealWidth, dWidth);
            dRowHeight = dMaxH + legendData.dVerticalReservedSpace;
            if (!(dExtraHeight + dRowHeight > legendData.dAvailableHeight + legendData.dSafeSpacing)) {
                legendData.legendItems.addAll(columnList);
                if (oneVisibleSerie) {
                    dExtraHeight += dRowHeight;
                    if (j < seda.length - 1 && (cm.getLegend().getSeparator() == null || cm.getLegend().getSeparator().isVisible())) {
                        dHeight += legendData.dSeparatorThickness;
                        legendData.legendItems.add(new LegendItemHints(2, new Point(0.0, dExtraHeight - legendData.dSeparatorThickness / 2.0), dRealWidth, 0.0, null, 0.0, null));
                    }
                }
            }
            columnList.clear();
            dMaxH = 0.0;
            dWidth = 0.0;
            ++j;
        }
        dWidth = Math.max(dRealWidth, dWidth);
        return new double[]{dWidth, dHeight += dExtraHeight};
    }

    private double[] computeHorizalByLeftRightValue(IDisplayServer xs, Chart cm, SeriesDefinition[] seda, RunTimeContext rtc, ITextMetrics itm, Label la, LegendData legendData) throws ChartException {
        double dWidth = 0.0;
        double dHeight = 0.0;
        double dMaxH = 0.0;
        double dRealWidth = 0.0;
        double dExtraHeight = 0.0;
        ArrayList<LegendItemHints> columnList = new ArrayList<LegendItemHints>();
        double dSeparatorThickness = legendData.dSeparatorThickness + legendData.dHorizontalSpacing;
        int j = 0;
        while (j < seda.length) {
            double dRowHeight;
            List al = seda[j].getRunTimeSeries();
            FormatSpecifier fs = seda[j].getFormatSpecifier();
            boolean oneVisibleSerie = false;
            int i = 0;
            while (i < al.size()) {
                Series se = (Series)al.get(i);
                if (se.isVisible()) {
                    double dH;
                    oneVisibleSerie = true;
                    Object obj = se.getSeriesIdentifier();
                    String lgtext = rtc.externalizedMessage(String.valueOf(obj));
                    if (fs != null) {
                        try {
                            lgtext = ValueFormatter.format(lgtext, fs, rtc.getULocale(), null);
                        }
                        catch (ChartException chartException) {}
                    }
                    la.getCaption().setValue(lgtext);
                    itm.reuse(la, legendData.maxWrappingSize);
                    BoundingBox bb = null;
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    double dFHeight = dH = bb.getHeight();
                    double dFWidth = bb.getWidth();
                    double dEHeight = 0.0;
                    String extraText = null;
                    double dDeltaWidth = legendData.insCa.getLeft() + 3.0 * legendData.dItemHeight / 2.0 + dFWidth + legendData.insCa.getRight() + legendData.dHorizontalSpacing;
                    if (cm.getLegend().isShowValue()) {
                        DataSetIterator dsiBase = null;
                        try {
                            dsiBase = new DataSetIterator(se.getDataSet());
                        }
                        catch (Exception ex) {
                            throw new ChartException("org.eclipse.birt.chart.engine", 3, ex);
                        }
                        if (dsiBase.hasNext()) {
                            obj = dsiBase.next();
                            while (!this.isValidValue(obj) && dsiBase.hasNext()) {
                                obj = dsiBase.next();
                            }
                            String valueText = String.valueOf(obj);
                            if (fs != null) {
                                try {
                                    lgtext = ValueFormatter.format(obj, fs, rtc.getULocale(), null);
                                }
                                catch (ChartException chartException) {}
                            }
                            Label seLabel = LabelImpl.copyInstance(se.getLabel());
                            seLabel.getCaption().setValue(valueText);
                            itm.reuse(seLabel);
                            dEHeight = itm.getFullHeight();
                            extraText = seLabel.getCaption().getValue();
                            dH += dEHeight + 2.0 * legendData.dScale;
                            dDeltaWidth = Math.max(dDeltaWidth, itm.getFullWidth());
                        }
                    }
                    if (dWidth + dDeltaWidth > legendData.dAvailableWidth) {
                        dRowHeight = dMaxH + legendData.dVerticalReservedSpace;
                        if (dExtraHeight + dRowHeight > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                            dMaxH = -legendData.dVerticalReservedSpace;
                            columnList.clear();
                            break;
                        }
                        legendData.legendItems.addAll(columnList);
                        columnList.clear();
                        dExtraHeight += dRowHeight;
                        dMaxH = dH;
                        dRealWidth = Math.max(dRealWidth, dWidth);
                        dWidth = dDeltaWidth;
                    } else {
                        dMaxH = Math.max(dH, dMaxH);
                        dWidth += dDeltaWidth;
                    }
                    columnList.add(new LegendItemHints(1, new Point(dWidth - dDeltaWidth, dExtraHeight), dFWidth, dFHeight, la.getCaption().getValue(), dEHeight, extraText));
                }
                ++i;
            }
            dRowHeight = dMaxH + legendData.dVerticalReservedSpace;
            if (dExtraHeight + dRowHeight > legendData.dAvailableHeight + legendData.dSafeSpacing) {
                dMaxH = -legendData.dVerticalReservedSpace;
            } else {
                legendData.legendItems.addAll(columnList);
                if (oneVisibleSerie && j < seda.length - 1 && (cm.getLegend().getSeparator() == null || cm.getLegend().getSeparator().isVisible())) {
                    legendData.legendItems.add(new LegendItemHints(2, new Point((dWidth += dSeparatorThickness) - dSeparatorThickness / 2.0, dExtraHeight), 0.0, dMaxH + legendData.insCa.getTop() + legendData.insCa.getBottom(), null, 0.0, null));
                }
            }
            columnList.clear();
            ++j;
        }
        dWidth = Math.max(dRealWidth, dWidth);
        return new double[]{dWidth, dHeight += legendData.dVerticalReservedSpace + dMaxH + dExtraHeight};
    }

    private static int[] getDuplicateIndices(int[] a1, int[] a2) {
        if (a1 == null || a2 == null || a1.length == 0 || a2.length == 0) {
            return null;
        }
        Arrays.sort(a1);
        Arrays.sort(a2);
        if (a1[a1.length - 1] < a2[0] || a1[0] > a2[a2.length - 1]) {
            return null;
        }
        if (a1.length > a2.length) {
            int[] tmp = a1;
            a1 = a2;
            a2 = tmp;
        }
        ArrayList<Integer> dup = new ArrayList<Integer>();
        int i = 0;
        while (i < a1.length) {
            if (Arrays.binarySearch(a2, a1[i]) >= 0) {
                dup.add(new Integer(a1[i]));
            }
            ++i;
        }
        if (dup.size() == 0) {
            return null;
        }
        int[] pia = new int[dup.size()];
        int i2 = 0;
        while (i2 < pia.length) {
            pia[i2] = (Integer)dup.get(i2);
            ++i2;
        }
        return pia;
    }

    public final Size getSize() {
        return this.sz;
    }

    private double[] checkEllipsisText(double dExceedingSpace, double dOriginalTextWidth, IDisplayServer xs, ITextMetrics itm, Label la, double dEllipsisWidth, double maxWrappingSize) throws ChartException {
        if (dExceedingSpace > 0.0) {
            String firstRowText = itm.getLine(0);
            int nchars = (int)Math.round(3.0 * (dExceedingSpace + dEllipsisWidth) / dEllipsisWidth);
            if (firstRowText.length() >= nchars) {
                double dReducedSpace = 0.0;
                int idx = 0;
                BoundingBox bb = null;
                while (dReducedSpace < dExceedingSpace) {
                    if (firstRowText.length() < nchars + idx) break;
                    String newText = String.valueOf(firstRowText.substring(0, firstRowText.length() - nchars - idx)) + ELLIPSIS_STRING;
                    la.getCaption().setValue(newText);
                    itm.reuse(la, maxWrappingSize);
                    try {
                        bb = Methods.computeBox(xs, 3, la, 0.0, 0.0);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 11, uiex);
                    }
                    dReducedSpace = dOriginalTextWidth - bb.getWidth();
                    ++idx;
                }
                if (bb != null) {
                    return new double[]{bb.getWidth(), bb.getHeight()};
                }
            }
        }
        return null;
    }

    private boolean isValidValue(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Double) {
            return !((Double)obj).isNaN() && !((Double)obj).isInfinite();
        }
        if (obj instanceof String) {
            return ((String)obj).length() != 0;
        }
        return true;
    }

    private LegendItemHints[] invertLegendItems(LegendItemHints[] liha) {
        ArrayList<LegendItemHints> legendItem = new ArrayList<LegendItemHints>(liha.length);
        int i = liha.length - 1;
        while (i >= 0) {
            LegendItemHints legendItem1 = liha[i];
            LegendItemHints legendItem2 = liha[liha.length - i - 1];
            legendItem.add(new LegendItemHints(legendItem2.getType(), legendItem1.getLocation(), legendItem2.getWidth(), legendItem2.getHeight(), legendItem2.getText(), legendItem2.getExtraHeight(), legendItem2.getExtraText(), legendItem2.getCategoryIndex()));
            --i;
        }
        return legendItem.toArray(new LegendItemHints[liha.length]);
    }

    private class LegendData {
        private boolean bMinSliceApplied;
        private int[] filteredMinSliceEntry;
        private double maxWrappingSize;
        private double dHorizonalReservedSpace;
        private double dVerticalReservedSpace;
        private double dAvailableWidth;
        private double dAvailableHeight;
        private double dItemHeight;
        private double dVerticalSpacing;
        private double dHorizontalSpacing;
        private double dScale;
        private double dSeparatorThickness;
        private double dSafeSpacing;
        private double dEllipsisWidth;
        private List legendItems = new ArrayList();
        private Insets insCa;
        private String sMinSliceLabel;

        private LegendData() {
        }
    }
}

