/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class DataPointComponentType
extends AbstractEnumerator {
    public static final int BASE_VALUE = 0;
    public static final int ORTHOGONAL_VALUE = 1;
    public static final int SERIES_VALUE = 2;
    public static final int PERCENTILE_ORTHOGONAL_VALUE = 3;
    public static final DataPointComponentType BASE_VALUE_LITERAL = new DataPointComponentType(0, "BaseValue", "Base_Value");
    public static final DataPointComponentType ORTHOGONAL_VALUE_LITERAL = new DataPointComponentType(1, "OrthogonalValue", "Orthogonal_Value");
    public static final DataPointComponentType SERIES_VALUE_LITERAL = new DataPointComponentType(2, "SeriesValue", "Series_Value");
    public static final DataPointComponentType PERCENTILE_ORTHOGONAL_VALUE_LITERAL = new DataPointComponentType(3, "PercentileOrthogonalValue", "Percentile_Orthogonal_Value");
    private static final DataPointComponentType[] VALUES_ARRAY = new DataPointComponentType[]{BASE_VALUE_LITERAL, ORTHOGONAL_VALUE_LITERAL, SERIES_VALUE_LITERAL, PERCENTILE_ORTHOGONAL_VALUE_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static DataPointComponentType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataPointComponentType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataPointComponentType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataPointComponentType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataPointComponentType get(int value) {
        switch (value) {
            case 0: {
                return BASE_VALUE_LITERAL;
            }
            case 1: {
                return ORTHOGONAL_VALUE_LITERAL;
            }
            case 2: {
                return SERIES_VALUE_LITERAL;
            }
            case 3: {
                return PERCENTILE_ORTHOGONAL_VALUE_LITERAL;
            }
        }
        return null;
    }

    private DataPointComponentType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

