/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.utility.WidgetRegistry");
cosmos.utility.WidgetRegistry = function () {
	this.initialize = function(message){
		initParam = message.styles.getStyles()["cosmos:WidgetRegistry"];
	    this.widgetRegistry = initParam["widgetRegistry"];
		this.styles = message.styles;
		console.debug("initializing registry");	
	}	
	this.dojoCellFactory = function(value, cell){
		var register = this.widgetRegistry[value.type];
		console.debug(value.type+ ' found ' + register);
		
		if (typeof(register) != 'undefined'){
			var properties= this.styles.getStyles()[register];
			if (typeof(properties) == 'undefined')
				properties = value;
			if (typeof(value.data) != 'undefined')
				properties.data = value.data;
			
			properties.value = value.value;
			properties.caption = value.caption;
			properties.datasource = value.datasource;
			var widget = eval("new "+properties.type+"(properties, cell)");
			
			//widgetContainer.appendChild(widget.domNode);
			return widget;
		}
		else{
			cell.innerHTML=value.value;
		}
		return null;
	}
	
	this.setRegistry = function(message){
			message.component.setRegistry(this);
	}
  	dojo.subscribe("pullRegistry", this, this.setRegistry);				
  	dojo.subscribe("initializeWidget", this, this.initialize);				
};

