/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.utility.WidgetStyles");
cosmos.utility.WidgetStyles = function (href) {
	this.components = new Array();
	this.initialize = function(){
			//populate node
			dojo.xhrGet({
	  			    widgetStyle: this,
					url: "WidgetStyleJSON?href="+href,    
//					url: "json/widgetstyle.json",
			        handleAs: "json",
			        handle: function(response, ioArgs){
			                //This function handles the response.
			                //Inside this function, the "this" variable
			                //will be the object used as the argument to the dojo.xhrGet() call.
			                if(response instanceof Error){
			                        if(response.dojoType == "cancel"){
			                                //The request was canceled by some other JavaScript code.
			                                console.debug("Request canceled.");
			                        }else if(response.dojoType == "timeout"){
			                                //The request took over 5 seconds to complete.
			                                console.debug("Request timed out.");
			                        }else{
			                                //Some other error happened.
			                                console.error(response);
			                        }
			                }else{
								    this.widgetStyle.setStyles(response);
			                }
			                //If you think there could be other callback handlers registered with this deferred, then
			                //return response to propagate the same response to other callback handlers. Otherwise,
			                //the error callbacks may be called in the success case.
			                return response;
			        }
			});
	},
	this.setStyles = function(styles){
	   this.styles = styles;
	   dojo.publish("initializeWidget", [{styles:this}]);
	}
	this.getStyles = function(){
	   return this.styles;
	}
	this.href = href;	
 	dojo.subscribe("initialize", this, this.initialize);			
	
};

