/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.Navigator");
dojo.require("dijit.Tree");
dojo.require("dijit.TitlePane");
dojo.require("dijit.layout.ContentPane");
dojo.require("dojo.data.JsonItemStore");

dojo.declare(
	// class
	"cosmos.widget.Navigator",

	// superclass	
	[dijit.Tree],
	
	// member variables/functions
	{
		widgetClass:'cosmos:Navigator',  
	    treeHandler: function(message){
		  if (message.event != 'execute') {
    		return;
  		}
			var params= new Array();
			params['RESOURCE_CONTEXT']=message.node.item.object;
			params['RESOURCE_CLASS']=message.node.item.nodeClass;
			if (typeof(this.publish) != 'undefined'){
					for (i=0;i < this.publish.length;i++){
						dojo.publish(this.publish[i], [{contextMap:params}]);
		 			}
 			}	    
	    },
		initWidget: function(message){
			this.styles = message.styles;
			initParam = this.styles.getStyles()[this.widgetClass];
		    this.publish = initParam.publish;
		    this.handler = initParam.handler;
			//populate node
			dojo.xhrGet({
  				    treeWidget: this,
					url: this.handler,    
			        handleAs: "json",
			        handle: function(response, ioArgs){
			                //This function handles the response.
			                //Inside this function, the "this" variable
			                //will be the object used as the argument to the dojo.xhrGet() call.
			                if(response instanceof Error){
			                        if(response.dojoType == "cancel"){
			                                //The request was canceled by some other JavaScript code.
			                                console.debug("Request canceled.");
			                        }else if(response.dojoType == "timeout"){
			                                //The request took over 5 seconds to complete.
			                                console.debug("Request timed out.");
			                        }else{
			                                //Some other error happened.
			                                console.error(response);
			                        }
			                }else{
									this.treeWidget.updateNodes(response);
			                }
			                //If you think there could be other callback handlers registered with this deferred, then
			                //return response to propagate the same response to other callback handlers. Otherwise,
			                //the error callbacks may be called in the success case.
			                return response;
			        }
			});
			
			console.debug("initalizing Navigator"  + this.id);	
		},
		addChildIcon: function(el){
			var value = el.label;
		    if ((el.item.nodeClass) && (this.styles)){
				initParam = this.styles.getStyles()[el.item.nodeClass];
				if (initParam){
					value="<img src=\""+initParam.icon+"\"/>"+ el.label;
					}
		    }
			el.labelNode.innerHTML=value;	
			dojo.connect(el,"addChild", this, "addChildIcon");
		},
		postCreate: function(){
			this.query={nodeClass:"machine"};
			//call superclass
			this.store = new dojo.data.JsonItemStore({data: {}});
			cosmos.widget.Navigator.superclass.postCreate.apply(this, arguments);
		  	dojo.subscribe(this.id, this, this.treeHandler);
		  	dojo.subscribe("initializeWidget", this, this.initWidget);
		  	dojo.connect(this, "addChild", this,"addChildIcon");
		},
		updateNodes: function(nodes){
			this.labelAttr="title" ;
			this.typeAttr="type";
			this.store = new dojo.data.JsonItemStore({data: nodes});
			this.store.styles = this.styles;			
			this._controller.store = this.store;	
			this._publish("afterTreeCreate");							
		}			
	}
);

