/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("cosmos.widget.PropertiesContainer");
dojo.require("dijit.TitlePane");
dojo.require("dijit.layout.ContentPane");
dojo.require("cosmos.widget.Property");
dojo.require("cosmos.widget.TitlePane");


dojo.declare(
	// class
	"cosmos.widget.PropertiesContainer",
	// superclass	
	[dijit.TitlePane],
	
	// member variables/functions
	{
		tableLabelNodeClass:"tplabel",
		widgetClass:'cosmos:PropertiesContainer',
		postCreate: function(){
			cosmos.widget.PropertiesContainer.superclass.postCreate.apply(this, arguments);			
			//call superclass			
		  	dojo.subscribe("initializeWidget", this, this.initWidget);
		},
		setRegistry: function(registryObj){
			this.renderDojoCell=registryObj;
		},
		initWidget: function(message){
			this.styles = message.styles;
			if (typeof(this.styles) != 'undefined'){
				initParam = this.styles.getStyles()[this.widgetClass];
			    this.subscribe = initParam.subscribe;
			    this.handler = initParam.handler;
			}
			dojo.publish("pullRegistry", [{component:this}]);
			dojo.subscribe(this.subscribe, this, this.refreshContainer);
			console.debug("initalizing PropertiesContainer"  + this.id);	
		},
	    refreshContainer:function(message) {
	    	if (typeof(message.contextMap) != 'undefined'){
		  	//should add a javascript method that will render itself and make a call
			//back to the server.  It will get the context from a queue.			
				resourceContext = message.contextMap['RESOURCE_CONTEXT'];	
				resourceClass = message.contextMap['RESOURCE_CLASS'];	
			}
			//make REST call to get content data
	    	if (typeof(resourceContext) != 'undefined'){
				dojo.xhrGet({
						url: this.handler+"?context="+resourceContext,
						resourceClass:resourceClass,    
						storeFunction:this,
				        handleAs: "json",
				        handle: function(response, ioArgs){
				                //This function handles the response.
				                //Inside this function, the "this" variable
				                //will be the object used as the argument to the dojo.xhrGet() call.
				                if(response instanceof Error){
				                        if(response.dojoType == "cancel"){
				                                //The request was canceled by some other JavaScript code.
				                                console.debug("Request canceled.");
				                        }else if(response.dojoType == "timeout"){
				                                //The request took over 5 seconds to complete.
				                                console.debug("Request timed out.");
				                        }else{
				                                //Some other error happened.
				                                console.error(response);
				                        }
				                }else{
									this.storeFunction.store(response, resourceClass);
				                }
				                //If you think there could be other callback handlers registered with this deferred, then
				                //return response to propagate the same response to other callback handlers. Otherwise,
				                //the error callbacks may be called in the success case.
				                return response;
				        }
				});			    	
	    	
			}
	    },
	    setHandler:function(handler){
	    	this.handler = handler;
	    },
	    setTableLabelClass:function(value){
	      this.tableLabelNodeClass = value;
	    },
	    store:function(data, resourceClass){
	      if (typeof(this.containers) != 'undefined'){
			  var len = this.containers.length;
			  //clear the div element
			  for(var j = 0; j < len; j++)
	   		  {
	   		  	this.containers[j].destroy();
	   		  }
	   		}
			this.containers = new Array();
			customWidget = null;
			var div = null;
			if ((this.renderDojoCell) && (resourceClass)){
					div = document.createElement("div");			
					this.containerNode.appendChild(div);
					var argument = new Object;
					argument.type = resourceClass;
					argument.data = data;
					try{
						customWidget = this.renderDojoCell.dojoCellFactory(argument, div);
					}catch(e){
						customWidget = null;
					}
			}
			if (customWidget != null){
				this.containers.push(customWidget);
				}
			else{
				if (div != null){
					this.containerNode.removeChild(div);
				}
	        	this.createContainerWidget(data, this.containerNode, "pcRoot", 0);
	        }
	    },
	    createContainerWidget:function(data, parent, containerId, indent){
			for (var i=0;i < data.length;i++){
					var div = document.createElement("div");			
					parent.appendChild(div);
				if ((typeof(this.renderDojoCell) != "undefined") && (typeof(data[i].value)!="undefined")){
					this.containers.push(this.renderDojoCell.dojoCellFactory(data[i].value, div));
				}
				else{					
					var properties = data[i].properties;
					if (typeof(data[i].properties) != 'undefined'){								
						var propTable = document.createElement("table");
						div.appendChild(propTable);
						this.containers.push(new cosmos.widget.Property({properties: data[i].properties, indent:((indent+1)*20)}, propTable));
					}
					var lc = new cosmos.widget.TitlePane({indent:(indent*20),open:false, sizeMin:33, sizeShare:33, label:data[i].name, labelNodeClass:this.tableLabelNodeClass, containerNodeClass:"tpcontent"}, div);
					this.containers.push(lc);
					if (typeof(data[i].childProperties) != 'undefined')					
						this.createContainerWidget(data[i].childProperties, lc.containerNode, containerId+i+"_n_", indent+1);
				}
			}	    
	    }
		
	}
);
